/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.hud;

import com.stevekung.indicatia.config.ExtendedConfig;
import com.stevekung.indicatia.core.IndicatiaMod;
import com.stevekung.indicatia.hud.InfoOverlay;
import com.stevekung.indicatia.integration.GalacticraftPlanetsTime;
import com.stevekung.stevekungslib.client.event.ClientEventHandler;
import com.stevekung.stevekungslib.utils.LangUtils;
import com.stevekung.stevekungslib.utils.ModDecimalFormat;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.world.dimension.DimensionType;

public class InfoOverlays {
    public static InfoOverlay OVERALL_TPS = InfoOverlay.empty();
    public static InfoOverlay OVERWORLD_TPS = InfoOverlay.empty();
    public static InfoOverlay TPS = InfoOverlay.empty();
    public static final List<InfoOverlay> ALL_TPS = new ArrayList<InfoOverlay>();
    private static final ModDecimalFormat TPS_FORMAT = new ModDecimalFormat("########0.00");

    public static InfoOverlay getDirection(Minecraft mc) {
        String direction;
        String coord;
        int facing;
        Entity entity = mc.func_175606_aa();
        Direction coordDirection = entity.func_174811_aO();
        int yaw = (int)entity.field_70177_z + 22;
        if ((yaw %= 360) < 0) {
            yaw += 360;
        }
        if ((facing = yaw / 45) < 0) {
            facing = 7;
        }
        switch (coordDirection) {
            default: {
                coord = "-Z";
                break;
            }
            case SOUTH: {
                coord = "+Z";
                break;
            }
            case WEST: {
                coord = "-X";
                break;
            }
            case EAST: {
                coord = "+X";
            }
        }
        switch (facing) {
            case 0: {
                direction = "hud.direction.south";
                break;
            }
            case 1: {
                direction = "hud.direction.south_west";
                break;
            }
            case 2: {
                direction = "hud.direction.west";
                break;
            }
            case 3: {
                direction = "hud.direction.north_west";
                break;
            }
            default: {
                direction = "hud.direction.north";
                break;
            }
            case 5: {
                direction = "hud.direction.north_east";
                break;
            }
            case 6: {
                direction = "hud.direction.east";
                break;
            }
            case 7: {
                direction = "hud.direction.south_east";
            }
        }
        direction = LangUtils.translate((String)direction);
        direction = direction + " (" + coord + ")";
        return new InfoOverlay("hud.direction", direction, ExtendedConfig.INSTANCE.directionColor, ExtendedConfig.INSTANCE.directionValueColor, InfoOverlay.Position.LEFT);
    }

    public static void getTPS(MinecraftServer server) {
        if (ClientEventHandler.ticks % 2 == 0) {
            double overallTPS = (double)InfoOverlays.mean(server.field_71311_j) * 1.0E-6;
            double overworldTPS = (double)InfoOverlays.mean(server.getTickTime(DimensionType.field_223227_a_)) * 1.0E-6;
            double tps = Math.min(1000.0 / overallTPS, 20.0);
            ALL_TPS.clear();
            OVERALL_TPS = new InfoOverlay("Overall TPS", TPS_FORMAT.format(overallTPS), ExtendedConfig.INSTANCE.tpsColor, ExtendedConfig.INSTANCE.tpsValueColor, InfoOverlay.Position.LEFT);
            if (ExtendedConfig.INSTANCE.tpsAllDims) {
                OVERWORLD_TPS = InfoOverlay.empty();
                for (DimensionType dimension : DimensionType.func_212681_b()) {
                    long[] values = server.getTickTime(dimension);
                    String dimensionName = DimensionType.func_212678_a((DimensionType)dimension).func_110623_a();
                    if (values == null) continue;
                    double dimensionTPS = (double)InfoOverlays.mean(values) * 1.0E-6;
                    ALL_TPS.add(new InfoOverlay("Dimension " + dimensionName, TPS_FORMAT.format(dimensionTPS), ExtendedConfig.INSTANCE.tpsColor, ExtendedConfig.INSTANCE.tpsValueColor, InfoOverlay.Position.LEFT));
                }
            } else {
                OVERWORLD_TPS = new InfoOverlay("Overworld TPS", TPS_FORMAT.format(overworldTPS), ExtendedConfig.INSTANCE.tpsColor, ExtendedConfig.INSTANCE.tpsValueColor, InfoOverlay.Position.LEFT);
            }
            TPS = new InfoOverlay("TPS", TPS_FORMAT.format(tps), ExtendedConfig.INSTANCE.tpsColor, ExtendedConfig.INSTANCE.tpsValueColor, InfoOverlay.Position.LEFT);
        }
    }

    public static InfoOverlay getRealWorldTime() {
        Date date = new Date();
        String dateIns = DateFormat.getDateInstance(2, Locale.getDefault()).format(date);
        String timeIns = DateFormat.getTimeInstance(2, Locale.getDefault()).format(date);
        return new InfoOverlay("hud.real_time", dateIns + " " + timeIns, ExtendedConfig.INSTANCE.realTimeColor, ExtendedConfig.INSTANCE.realTimeValueColor, InfoOverlay.Position.RIGHT);
    }

    public static InfoOverlay getGameTime(Minecraft mc) {
        boolean isSpace = false;
        if (IndicatiaMod.GALACTICRAFT_LOADED) {
            try {
                Class<?> spaceWorld = Class.forName("micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace");
                isSpace = spaceWorld.isAssignableFrom(mc.field_71439_g.field_70170_p.field_73011_w.getClass());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isSpace) {
                return GalacticraftPlanetsTime.getSpaceTime(mc);
            }
        }
        return InfoOverlays.getVanillaGameTime(mc.field_71441_e.func_72820_D() % 24000L);
    }

    private static InfoOverlay getVanillaGameTime(long worldTicks) {
        StringBuilder builder = new StringBuilder();
        int hours = (int)((worldTicks / 1000L + 6L) % 24L);
        int minutes = (int)(60L * (worldTicks % 1000L) / 1000L);
        if (hours <= 9) {
            builder.append(0);
        }
        builder.append(hours);
        builder.append(":");
        if (minutes <= 9) {
            builder.append(0);
        }
        builder.append(minutes);
        builder.append(" " + (hours >= 12 ? "PM" : "AM"));
        return new InfoOverlay("hud.time", builder.toString(), ExtendedConfig.INSTANCE.gameTimeColor, ExtendedConfig.INSTANCE.gameTimeValueColor, InfoOverlay.Position.RIGHT);
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long value : values) {
            sum += value;
        }
        return sum / (long)values.length;
    }
}

