/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.integration;

import com.stevekung.indicatia.config.ExtendedConfig;
import com.stevekung.indicatia.hud.InfoOverlay;
import com.stevekung.stevekungslib.utils.LangUtils;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import net.minecraft.client.Minecraft;

public class GalacticraftPlanetsTime {
    public static InfoOverlay getSpaceTime(Minecraft mc) {
        if (!(mc.field_71441_e.field_73011_w instanceof WorldProviderSpace)) {
            return null;
        }
        WorldProviderSpace space = (WorldProviderSpace)mc.field_71441_e.field_73011_w;
        long dayLength = space.getDayLength();
        StringBuilder builder = new StringBuilder();
        String celestialName = space.getCelestialBody().getLocalizedName();
        long spaceWorldTime = space.getWorldTime() % dayLength;
        long worldTimeDivide = dayLength / 24L;
        int hours = (int)((spaceWorldTime / worldTimeDivide + 6L) % 24L);
        int minutes = (int)(60L * (spaceWorldTime % worldTimeDivide) / worldTimeDivide);
        if (dayLength >= 1L && dayLength <= 24L) {
            return new InfoOverlay(celestialName, LangUtils.translate((String)"hud.time.galacticraft.fastest_dn_cycle"), ExtendedConfig.INSTANCE.gameTimeColor, ExtendedConfig.INSTANCE.gameTimeValueColor, InfoOverlay.Position.RIGHT);
        }
        if (dayLength == 0L) {
            return new InfoOverlay(celestialName, LangUtils.translate((String)"hud.time.galacticraft.no_dn_cycle"), ExtendedConfig.INSTANCE.gameTimeColor, ExtendedConfig.INSTANCE.gameTimeValueColor, InfoOverlay.Position.RIGHT);
        }
        if (hours <= 9) {
            builder.append(0);
        }
        builder.append(hours);
        builder.append(":");
        if (minutes <= 9) {
            builder.append(0);
        }
        builder.append(minutes);
        builder.append(" " + (hours >= 12 ? "PM" : "AM"));
        return new InfoOverlay(celestialName, builder.toString(), ExtendedConfig.INSTANCE.gameTimeColor, ExtendedConfig.INSTANCE.gameTimeValueColor, InfoOverlay.Position.RIGHT);
    }
}

