/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.stevekungslib.utils;

import com.stevekung.stevekungslib.utils.CommonUtils;
import com.stevekung.stevekungslib.utils.enums.EntityTrackerType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class CommonRegistryUtils {
    private static final List<DeferredRegister<?>> ALL_REGISTRIES = new ArrayList();
    private final String modId;
    private static DeferredRegister<Block> BLOCKS;
    private static DeferredRegister<Enchantment> ENCHANTMENTS;
    private static DeferredRegister<EntityType<?>> ENTITY_TYPES;
    private static DeferredRegister<MemoryModuleType<?>> MEMORY_MODULE_TYPES;
    private static DeferredRegister<Activity> ACTIVITIES;
    private static DeferredRegister<Schedule> SCHEDULES;
    private static DeferredRegister<SensorType<?>> SENSOR_TYPES;
    private static DeferredRegister<VillagerProfession> VILLAGER_PROFESSIONS;
    private static DeferredRegister<Fluid> FLUIDS;
    private static DeferredRegister<ContainerType<?>> CONTAINER_TYPES;
    private static DeferredRegister<Item> ITEMS;
    private static DeferredRegister<IRecipeSerializer<?>> RECIPE_SERIALIZERS;
    private static DeferredRegister<ParticleType<?>> PARTICLE_TYPES;
    private static DeferredRegister<Effect> EFFECTS;
    private static DeferredRegister<Potion> POTIONS;
    private static DeferredRegister<TileEntityType<?>> TILE_ENTITY_TYPES;
    private static DeferredRegister<SoundEvent> SOUND_EVENTS;
    private static DeferredRegister<PointOfInterestType> POINT_OF_INTEREST_TYPES;
    private static DeferredRegister<Biome> BIOMES;
    private static DeferredRegister<BiomeProviderType<?, ?>> BIOME_PROVIDER_TYPES;
    private static DeferredRegister<ModDimension> MOD_DIMENSIONS;
    private static DeferredRegister<WorldCarver<?>> WORLD_CARVERS;
    private static DeferredRegister<Feature<?>> FEATURES;
    private static DeferredRegister<Placement<?>> PLACEMENTS;
    private static DeferredRegister<SurfaceBuilder<?>> SURFACE_BUILDERS;
    private static DeferredRegister<DataSerializerEntry> DATA_SERIALIZERS;

    public CommonRegistryUtils(String modId) {
        this.modId = modId;
        BLOCKS = new DeferredRegister(ForgeRegistries.BLOCKS, modId);
        ENCHANTMENTS = new DeferredRegister(ForgeRegistries.ENCHANTMENTS, modId);
        ENTITY_TYPES = new DeferredRegister(ForgeRegistries.ENTITIES, modId);
        MEMORY_MODULE_TYPES = new DeferredRegister(ForgeRegistries.MEMORY_MODULE_TYPES, modId);
        ACTIVITIES = new DeferredRegister(ForgeRegistries.ACTIVITIES, modId);
        SCHEDULES = new DeferredRegister(ForgeRegistries.SCHEDULES, modId);
        SENSOR_TYPES = new DeferredRegister(ForgeRegistries.SENSOR_TYPES, modId);
        VILLAGER_PROFESSIONS = new DeferredRegister(ForgeRegistries.PROFESSIONS, modId);
        FLUIDS = new DeferredRegister(ForgeRegistries.FLUIDS, modId);
        CONTAINER_TYPES = new DeferredRegister(ForgeRegistries.CONTAINERS, modId);
        ITEMS = new DeferredRegister(ForgeRegistries.ITEMS, modId);
        RECIPE_SERIALIZERS = new DeferredRegister(ForgeRegistries.RECIPE_SERIALIZERS, modId);
        PARTICLE_TYPES = new DeferredRegister(ForgeRegistries.PARTICLE_TYPES, modId);
        EFFECTS = new DeferredRegister(ForgeRegistries.POTIONS, modId);
        POTIONS = new DeferredRegister(ForgeRegistries.POTION_TYPES, modId);
        TILE_ENTITY_TYPES = new DeferredRegister(ForgeRegistries.TILE_ENTITIES, modId);
        SOUND_EVENTS = new DeferredRegister(ForgeRegistries.SOUND_EVENTS, modId);
        POINT_OF_INTEREST_TYPES = new DeferredRegister(ForgeRegistries.POI_TYPES, modId);
        BIOMES = new DeferredRegister(ForgeRegistries.BIOMES, modId);
        BIOME_PROVIDER_TYPES = new DeferredRegister(ForgeRegistries.BIOME_PROVIDER_TYPES, modId);
        MOD_DIMENSIONS = new DeferredRegister(ForgeRegistries.MOD_DIMENSIONS, modId);
        WORLD_CARVERS = new DeferredRegister(ForgeRegistries.WORLD_CARVERS, modId);
        FEATURES = new DeferredRegister(ForgeRegistries.FEATURES, modId);
        PLACEMENTS = new DeferredRegister(ForgeRegistries.DECORATORS, modId);
        SURFACE_BUILDERS = new DeferredRegister(ForgeRegistries.SURFACE_BUILDERS, modId);
        DATA_SERIALIZERS = new DeferredRegister(ForgeRegistries.DATA_SERIALIZERS, modId);
        ALL_REGISTRIES.add(BLOCKS);
        ALL_REGISTRIES.add(ENCHANTMENTS);
        ALL_REGISTRIES.add(ENTITY_TYPES);
        ALL_REGISTRIES.add(MEMORY_MODULE_TYPES);
        ALL_REGISTRIES.add(ACTIVITIES);
        ALL_REGISTRIES.add(SCHEDULES);
        ALL_REGISTRIES.add(SENSOR_TYPES);
        ALL_REGISTRIES.add(VILLAGER_PROFESSIONS);
        ALL_REGISTRIES.add(FLUIDS);
        ALL_REGISTRIES.add(CONTAINER_TYPES);
        ALL_REGISTRIES.add(ITEMS);
        ALL_REGISTRIES.add(RECIPE_SERIALIZERS);
        ALL_REGISTRIES.add(PARTICLE_TYPES);
        ALL_REGISTRIES.add(EFFECTS);
        ALL_REGISTRIES.add(POTIONS);
        ALL_REGISTRIES.add(TILE_ENTITY_TYPES);
        ALL_REGISTRIES.add(SOUND_EVENTS);
        ALL_REGISTRIES.add(POINT_OF_INTEREST_TYPES);
        ALL_REGISTRIES.add(BIOMES);
        ALL_REGISTRIES.add(BIOME_PROVIDER_TYPES);
        ALL_REGISTRIES.add(MOD_DIMENSIONS);
        ALL_REGISTRIES.add(WORLD_CARVERS);
        ALL_REGISTRIES.add(FEATURES);
        ALL_REGISTRIES.add(PLACEMENTS);
        ALL_REGISTRIES.add(SURFACE_BUILDERS);
        ALL_REGISTRIES.add(DATA_SERIALIZERS);
    }

    public void registerBlock(Block block, String name, ItemGroup group) {
        this.registerBlock(block, name, group, true);
    }

    public void registerBlock(Block block, String name, ItemGroup group, boolean useBlockItem) {
        BLOCKS.register(name, () -> block);
        if (useBlockItem) {
            ITEMS.register(name, () -> new BlockItem(block, new Item.Properties().func_200916_a(group)));
        }
    }

    public void registerBlock(Block block, String name, BlockItem itemBlock) {
        BLOCKS.register(name, () -> block);
        ITEMS.register(name, () -> itemBlock);
    }

    public void registerEnchantment(Enchantment enchantment, String name) {
        ENCHANTMENTS.register(name, () -> enchantment);
    }

    public void registerEntityType(EntityType.IFactory<Entity> entity, EntityClassification classifi, String name) {
        this.registerEntityType(entity, classifi, name, EntityTrackerType.NORMAL);
    }

    public void registerEntityType(EntityType.IFactory<Entity> entity, EntityClassification classifi, String name, EntityTrackerType type) {
        this.registerEntityType(entity, classifi, name, type.getTrackingRange(), type.getUpdateFrequency(), type.sendsVelocityUpdates());
    }

    public void registerEntityType(EntityType.IFactory<Entity> entity, EntityClassification classifi, String name, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ENTITY_TYPES.register(name, () -> EntityType.Builder.func_220322_a((EntityType.IFactory)entity, (EntityClassification)classifi).setTrackingRange(trackingRange).setUpdateInterval(updateFrequency).setShouldReceiveVelocityUpdates(sendsVelocityUpdates).func_206830_a(name));
    }

    public void registerEntityPlacement(EntityType<MobEntity> entity, EntitySpawnPlacementRegistry.PlacementType placementType, Heightmap.Type heightMapType, EntitySpawnPlacementRegistry.IPlacementPredicate<MobEntity> predicate) {
        EntitySpawnPlacementRegistry.func_209343_a(entity, (EntitySpawnPlacementRegistry.PlacementType)placementType, (Heightmap.Type)heightMapType, predicate);
    }

    public void registerMemoryModuleType(MemoryModuleType<?> memoryModule, String name) {
        MEMORY_MODULE_TYPES.register(name, () -> memoryModule);
    }

    public void registerEntityActivity(Activity activity, String name) {
        ACTIVITIES.register(name, () -> activity);
    }

    public void registerEntitySchedule(Schedule schedule, String name) {
        SCHEDULES.register(name, () -> schedule);
    }

    public void registerEntitySensorType(SensorType<?> sensorType, String name) {
        SENSOR_TYPES.register(name, () -> sensorType);
    }

    public void registerVillagerProfession(VillagerProfession profession, String name) {
        VILLAGER_PROFESSIONS.register(name, () -> profession);
    }

    public void registerFluid(Fluid fluid, String name) {
        FLUIDS.register(name, () -> fluid);
    }

    public void registerContainerType(ContainerType<?> type, String name) {
        CONTAINER_TYPES.register(name, () -> type);
    }

    public void registerItem(Item item, String name) {
        ITEMS.register(name, () -> item);
    }

    public void registerRecipeSerializer(IRecipeSerializer<?> recipe, String name) {
        RECIPE_SERIALIZERS.register(name, () -> recipe);
    }

    public void registerParticleType(ParticleType<?> type, String name) {
        PARTICLE_TYPES.register(name, () -> type);
    }

    public void registerEffect(Effect effect, String name) {
        EFFECTS.register(name, () -> effect);
    }

    public void registerPotion(Potion potion, String name) {
        POTIONS.register(name, () -> potion);
    }

    public void registerTileEntityType(TileEntityType<?> type, String name) {
        TILE_ENTITY_TYPES.register(name, () -> type);
    }

    public void registerSound(SoundEvent event, String name) {
        SOUND_EVENTS.register(name, () -> event);
    }

    public SoundEvent createSound(String name) {
        return new SoundEvent(new ResourceLocation(this.modId, name));
    }

    public void registerMusicDisc(SoundEvent event, String name) {
        this.registerSound(event, "music_disc." + name);
    }

    public void registerPointOfInterestType(PointOfInterestType type, String name) {
        POINT_OF_INTEREST_TYPES.register(name, () -> type);
    }

    public void registerBiome(Biome biome, String name) {
        BIOMES.register(name, () -> biome);
    }

    public void registerBiomeProviderType(BiomeProviderType<?, ?> type, String name) {
        BIOME_PROVIDER_TYPES.register(name, () -> type);
    }

    public void registerBiomeType(Biome biome, BiomeDictionary.Type ... biomeType) {
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])biomeType);
        if (biome.func_185363_b()) {
            Biome.field_185373_j.func_148746_a((Object)biome, Registry.field_212624_m.func_148757_b(Registry.field_212624_m.func_82594_a(new ResourceLocation(biome.func_205402_s()))));
        }
    }

    public void registerDimension(ModDimension dimension, String name) {
        MOD_DIMENSIONS.register(name, () -> dimension);
    }

    public void registerWorldCarver(WorldCarver worldCarver, String name) {
        WORLD_CARVERS.register(name, () -> worldCarver);
    }

    public void registerWorldFeature(Feature<?> feature, String name) {
        FEATURES.register(name, () -> feature);
    }

    public void registerWorldPlacement(Placement<?> placement, String name) {
        PLACEMENTS.register(name, () -> placement);
    }

    public void registerSurfaceBuilder(SurfaceBuilder<?> builder, String name) {
        SURFACE_BUILDERS.register(name, () -> builder);
    }

    public void registerDataSerializer(DataSerializerEntry data, String name) {
        DATA_SERIALIZERS.register(name, () -> data);
    }

    public void registerProjectileDispense(Item item, IDispenseItemBehavior projectile) {
        DispenserBlock.func_199774_a((IItemProvider)item, (IDispenseItemBehavior)projectile);
    }

    public void registerAll() {
        for (DeferredRegister<?> registry : ALL_REGISTRIES) {
            registry.register(CommonUtils.getModEventBus());
        }
    }
}

