/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.stevekungslib.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class JsonUtils {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static StringTextComponent create(String text) {
        return new StringTextComponent(text);
    }

    public static ClickEvent click(ClickEvent.Action action, String url) {
        return new ClickEvent(action, url);
    }

    public static HoverEvent hover(HoverEvent.Action action, ITextComponent text) {
        return new HoverEvent(action, text);
    }

    public static void toJson(Object src, Appendable writer) {
        if (src != null) {
            JsonUtils.toJson(src, src.getClass(), writer);
        } else {
            JsonUtils.toJson(JsonNull.INSTANCE, writer);
        }
    }

    private static void toJson(Object src, Type typeOfSrc, Appendable writer) {
        try {
            JsonWriter jsonWriter = JsonUtils.newJsonWriter(Streams.writerForAppendable((Appendable)writer));
            GSON.toJson(src, typeOfSrc, jsonWriter);
        }
        catch (JsonIOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    private static JsonWriter newJsonWriter(Writer writer) {
        JsonWriter jsonWriter = new JsonWriter(writer);
        jsonWriter.setIndent("    ");
        jsonWriter.setSerializeNulls(GSON.serializeNulls());
        return jsonWriter;
    }
}

