/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.stevekungslib.world.gen;

import java.util.BitSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;

public class CaveWorldCarverBase
extends WorldCarver<ProbabilityConfig> {
    private final Set<Block> surfaceBlocks;
    private final Set<Block> subSurfaceBlocks;
    private final IFluidState lava;

    public CaveWorldCarverBase(Set<Block> terrainBlocks, Set<Fluid> terrainFluids, Set<Block> surfaceBlocks, Set<Block> subSurfaceBlocks, IFluidState lava) {
        super(ProbabilityConfig::func_214645_a, 256);
        this.field_222718_j = terrainBlocks;
        this.field_222719_k = terrainFluids;
        this.surfaceBlocks = surfaceBlocks;
        this.subSurfaceBlocks = subSurfaceBlocks;
        this.lava = lava;
    }

    public boolean shouldCarve(Random rand, int chunkX, int chunkZ, ProbabilityConfig config) {
        return rand.nextFloat() <= config.field_203622_a;
    }

    public boolean carve(IChunk chunk, Random rand, int seaLevel, int chunkX, int chunkZ, int originalX, int originalZ, BitSet carvingMask, ProbabilityConfig config) {
        int i = (this.func_222704_c() * 2 - 1) * 16;
        int j = rand.nextInt(rand.nextInt(rand.nextInt(15) + 1) + 1);
        for (int k = 0; k < j; ++k) {
            double d0 = chunkX * 16 + rand.nextInt(16);
            double d1 = rand.nextInt(rand.nextInt(120) + 8);
            double d2 = chunkZ * 16 + rand.nextInt(16);
            int l = 1;
            if (rand.nextInt(4) == 0) {
                float f1 = 1.0f + rand.nextFloat() * 6.0f;
                this.addRoom(chunk, rand.nextLong(), seaLevel, originalX, originalZ, d0, d1, d2, f1, 0.5, carvingMask);
                l += rand.nextInt(4);
            }
            for (int k1 = 0; k1 < l; ++k1) {
                float f = rand.nextFloat() * ((float)Math.PI * 2);
                float f3 = (rand.nextFloat() - 0.5f) / 4.0f;
                float f2 = this.generateCaveRadius(rand);
                int i1 = i - rand.nextInt(i / 4);
                this.carveTunnel(chunk, rand.nextLong(), seaLevel, originalX, originalZ, d0, d1, d2, f2, f, f3, 0, i1, 1.0, carvingMask);
            }
        }
        return true;
    }

    protected boolean func_222708_a(double p_222708_1_, double p_222708_3_, double p_222708_5_, int p_222708_7_) {
        return p_222708_3_ <= -0.7 || p_222708_1_ * p_222708_1_ + p_222708_3_ * p_222708_3_ + p_222708_5_ * p_222708_5_ >= 1.0;
    }

    protected boolean func_222703_a(IChunk chunk, BitSet carvingMask, Random rand, BlockPos.MutableBlockPos mutablePos1, BlockPos.MutableBlockPos mutablePos2, BlockPos.MutableBlockPos mutablePos3, int p_222703_7_, int p_222703_8_, int p_222703_9_, int x, int z, int p_222703_12_, int y, int p_222703_14_, AtomicBoolean atomicboolean) {
        int i = p_222703_12_ | p_222703_14_ << 4 | y << 8;
        if (carvingMask.get(i)) {
            return false;
        }
        carvingMask.set(i);
        mutablePos1.func_181079_c(x, y, z);
        BlockState blockstate = chunk.func_180495_p((BlockPos)mutablePos1);
        BlockState blockstate1 = chunk.func_180495_p((BlockPos)mutablePos2.func_189533_g((Vec3i)mutablePos1).func_189536_c(Direction.UP));
        if (this.surfaceBlocks.stream().anyMatch(block -> blockstate.func_177230_c() == block.getBlock())) {
            atomicboolean.set(true);
        }
        if (!this.func_222707_a(blockstate, blockstate1)) {
            return false;
        }
        if (y < 11) {
            chunk.func_177436_a((BlockPos)mutablePos1, this.lava.func_206883_i(), false);
        } else {
            chunk.func_177436_a((BlockPos)mutablePos1, field_222715_g, false);
            if (atomicboolean.get()) {
                mutablePos3.func_189533_g((Vec3i)mutablePos1).func_189536_c(Direction.DOWN);
                if (this.subSurfaceBlocks.stream().anyMatch(block -> chunk.func_180495_p((BlockPos)mutablePos3).func_177230_c() == block.getBlock())) {
                    chunk.func_177436_a((BlockPos)mutablePos3, chunk.func_217309_c((BlockPos)mutablePos1).func_203944_q().func_204108_a(), false);
                }
            }
        }
        return true;
    }

    private float generateCaveRadius(Random rand) {
        float f = rand.nextFloat() * 2.0f + rand.nextFloat();
        if (rand.nextInt(10) == 0) {
            f *= rand.nextFloat() * rand.nextFloat() * 3.0f + 1.0f;
        }
        return f;
    }

    private void addRoom(IChunk world, long seed, int height, int originalX, int originalZ, double x, double y, double z, float p_222723_13_, double p_222723_14_, BitSet bitSet) {
        double d0 = 1.5 + (double)(MathHelper.func_76126_a((float)1.5707964f) * p_222723_13_);
        double d1 = d0 * p_222723_14_;
        this.func_222705_a(world, seed, height, originalX, originalZ, x + 1.0, y, z, d0, d1, bitSet);
    }

    private void carveTunnel(IChunk chunk, long seed, int height, int originalX, int originalZ, double x, double y, double z, float radius, float p_222727_14_, float p_222727_15_, int p_222727_16_, int p_222727_17_, double p_222727_18_, BitSet bitSet) {
        Random rand = new Random(seed);
        int i = rand.nextInt(p_222727_17_ / 2) + p_222727_17_ / 4;
        boolean flag = rand.nextInt(6) == 0;
        float f = 0.0f;
        float f1 = 0.0f;
        for (int j = 0; j < p_222727_17_; ++j) {
            double d0 = 1.5 + (double)(MathHelper.func_76126_a((float)((float)Math.PI * (float)j / (float)p_222727_17_)) * radius);
            double d1 = d0 * p_222727_18_;
            float f2 = MathHelper.func_76134_b((float)p_222727_15_);
            x += (double)(MathHelper.func_76134_b((float)p_222727_14_) * f2);
            y += (double)MathHelper.func_76126_a((float)p_222727_15_);
            z += (double)(MathHelper.func_76126_a((float)p_222727_14_) * f2);
            p_222727_15_ *= flag ? 0.92f : 0.7f;
            p_222727_15_ += f1 * 0.1f;
            p_222727_14_ += f * 0.1f;
            f1 *= 0.9f;
            f *= 0.75f;
            f1 += (rand.nextFloat() - rand.nextFloat()) * rand.nextFloat() * 2.0f;
            f += (rand.nextFloat() - rand.nextFloat()) * rand.nextFloat() * 4.0f;
            if (j == i && radius > 1.0f) {
                this.carveTunnel(chunk, rand.nextLong(), height, originalX, originalZ, x, y, z, rand.nextFloat() * 0.5f + 0.5f, p_222727_14_ - 1.5707964f, p_222727_15_ / 3.0f, j, p_222727_17_, 1.0, bitSet);
                this.carveTunnel(chunk, rand.nextLong(), height, originalX, originalZ, x, y, z, rand.nextFloat() * 0.5f + 0.5f, p_222727_14_ + 1.5707964f, p_222727_15_ / 3.0f, j, p_222727_17_, 1.0, bitSet);
                return;
            }
            if (rand.nextInt(4) == 0) continue;
            if (!this.func_222702_a(originalX, originalZ, x, z, j, p_222727_17_, radius)) {
                return;
            }
            this.func_222705_a(chunk, seed, height, originalX, originalZ, x, y, z, d0, d1, bitSet);
        }
    }
}

