/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.config;

import com.stevekung.indicatia.config.Equipments;
import com.stevekung.indicatia.config.PingMode;
import com.stevekung.indicatia.config.StatusEffects;
import com.stevekung.indicatia.core.IndicatiaMod;
import com.stevekung.indicatia.gui.exconfig.BooleanConfigOption;
import com.stevekung.indicatia.gui.exconfig.DoubleConfigOption;
import com.stevekung.indicatia.gui.exconfig.StringConfigOption;
import com.stevekung.indicatia.gui.exconfig.TextFieldConfigOption;
import com.stevekung.stevekungslib.utils.GameProfileUtils;
import com.stevekung.stevekungslib.utils.LangUtils;
import com.stevekung.stevekungslib.utils.client.ClientUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;

public class ExtendedConfig {
    public static ExtendedConfig INSTANCE = new ExtendedConfig();
    private static final String WHITE = "255,255,255";
    public static final File INDICATIA_DIR = new File(Minecraft.func_71410_x().field_71412_D, "indicatia");
    public static final File USER_DIR = new File(INDICATIA_DIR, GameProfileUtils.getUUID().toString());
    public static final File DEFAULT_CONFIG_FILE = new File(USER_DIR, "default.dat");
    public static String CURRENT_PROFILE = "";
    private static File PROFILE_FILE;
    public boolean fps = true;
    public boolean xyz = true;
    public boolean direction = true;
    public boolean biome = true;
    public boolean ping = true;
    public boolean pingToSecond = false;
    public boolean serverIP = false;
    public boolean serverIPMCVersion = false;
    public boolean equipmentHUD = false;
    public boolean equipmentArmorItems = true;
    public boolean equipmentHandItems = true;
    public boolean potionHUD = false;
    public boolean slimeChunkFinder = false;
    public boolean realTime = true;
    public boolean gameTime = true;
    public boolean gameWeather = true;
    public boolean moonPhase = true;
    public boolean potionHUDIcon = false;
    public boolean tps = false;
    public boolean tpsAllDims = false;
    public boolean alternatePotionHUDTextColor = false;
    public boolean swapRenderInfo = false;
    public Equipments.Direction equipmentDirection = Equipments.Direction.VERTICAL;
    public Equipments.Status equipmentStatus = Equipments.Status.DAMAGE_AND_MAX_DAMAGE;
    public Equipments.Position equipmentPosition = Equipments.Position.HOTBAR;
    public StatusEffects.Style potionHUDStyle = StatusEffects.Style.DEFAULT;
    public StatusEffects.Position potionHUDPosition = StatusEffects.Position.LEFT;
    public PingMode pingMode = PingMode.PING;
    public int armorHUDYOffset = 0;
    public int potionHUDYOffset = 0;
    public int maximumPotionDisplay = 2;
    public int potionLengthYOffset = 23;
    public int potionLengthYOffsetOverlap = 45;
    public String fpsColor = "255,255,255";
    public String xyzColor = "255,255,255";
    public String biomeColor = "255,255,255";
    public String directionColor = "255,255,255";
    public String pingColor = "255,255,255";
    public String pingToSecondColor = "255,255,255";
    public String serverIPColor = "255,255,255";
    public String equipmentStatusColor = "255,255,255";
    public String arrowCountColor = "255,255,255";
    public String slimeChunkColor = "255,255,255";
    public String topDonatorNameColor = "255,255,255";
    public String recentDonatorNameColor = "255,255,255";
    public String tpsColor = "255,255,255";
    public String realTimeColor = "255,255,255";
    public String gameTimeColor = "255,255,255";
    public String gameWeatherColor = "255,255,255";
    public String moonPhaseColor = "255,255,255";
    public String fpsValueColor = "85,255,85";
    public String fps26And49Color = "255,255,85";
    public String fpsLow25Color = "255,85,85";
    public String xyzValueColor = "255,255,255";
    public String directionValueColor = "255,255,255";
    public String biomeValueColor = "255,255,255";
    public String pingValueColor = "85,255,85";
    public String ping200And300Color = "255,255,85";
    public String ping300And500Color = "255,85,85";
    public String pingMax500Color = "170,0,0";
    public String serverIPValueColor = "255,255,255";
    public String slimeChunkValueColor = "255,255,255";
    public String topDonatorValueColor = "255,255,255";
    public String recentDonatorValueColor = "255,255,255";
    public String tpsValueColor = "255,255,255";
    public String realTimeValueColor = "255,255,255";
    public String gameTimeValueColor = "255,255,255";
    public String gameWeatherValueColor = "255,255,255";
    public String moonPhaseValueColor = "255,255,255";
    public boolean showCustomCape = false;
    public long slimeChunkSeed = 0L;
    public boolean rightClickToAddParty = false;
    public int selectedHypixelMinigame = 0;
    public int hypixelMinigameScrollPos = 0;
    public int chatMode = 0;
    public static final DoubleConfigOption ARMOR_HUD_Y;
    public static final DoubleConfigOption POTION_HUD_Y;
    public static final DoubleConfigOption MAXIMUM_POTION_DISPLAY;
    public static final DoubleConfigOption POTION_LENGTH_Y_OFFSET;
    public static final DoubleConfigOption POTION_LENGTH_Y_OFFSET_OVERLAP;
    public static final BooleanConfigOption SWAP_INFO_POS;
    public static final BooleanConfigOption FPS;
    public static final BooleanConfigOption XYZ;
    public static final BooleanConfigOption DIRECTION;
    public static final BooleanConfigOption BIOME;
    public static final BooleanConfigOption PING;
    public static final BooleanConfigOption PING_TO_SECOND;
    public static final BooleanConfigOption SERVER_IP;
    public static final BooleanConfigOption SERVER_IP_MC;
    public static final BooleanConfigOption EQUIPMENT_HUD;
    public static final BooleanConfigOption EQUIPMENT_ARMOR_ITEMS;
    public static final BooleanConfigOption EQUIPMENT_HAND_ITEMS;
    public static final BooleanConfigOption POTION_HUD;
    public static final BooleanConfigOption SLIME_CHUNK;
    public static final BooleanConfigOption REAL_TIME;
    public static final BooleanConfigOption GAME_TIME;
    public static final BooleanConfigOption GAME_WEATHER;
    public static final BooleanConfigOption MOON_PHASE;
    public static final BooleanConfigOption POTION_ICON;
    public static final BooleanConfigOption TPS;
    public static final BooleanConfigOption TPS_ALL_DIMS;
    public static final BooleanConfigOption ALTERNATE_POTION_COLOR;
    public static final BooleanConfigOption RIGHT_CLICK_ADD_PARTY;
    public static final StringConfigOption EQUIPMENT_DIRECTION;
    public static final StringConfigOption EQUIPMENT_STATUS;
    public static final StringConfigOption EQUIPMENT_POSITION;
    public static final StringConfigOption POTION_HUD_STYLE;
    public static final StringConfigOption POTION_HUD_POSITION;
    public static final StringConfigOption PING_MODE;
    public static final TextFieldConfigOption FPS_COLOR;
    public static final TextFieldConfigOption XYZ_COLOR;
    public static final TextFieldConfigOption BIOME_COLOR;
    public static final TextFieldConfigOption DIRECTION_COLOR;
    public static final TextFieldConfigOption PING_COLOR;
    public static final TextFieldConfigOption PING_TO_SECOND_COLOR;
    public static final TextFieldConfigOption SERVER_IP_COLOR;
    public static final TextFieldConfigOption EQUIPMENT_STATUS_COLOR;
    public static final TextFieldConfigOption ARROW_COUNT_COLOR;
    public static final TextFieldConfigOption SLIME_CHUNK_COLOR;
    public static final TextFieldConfigOption TPS_COLOR;
    public static final TextFieldConfigOption REAL_TIME_COLOR;
    public static final TextFieldConfigOption GAME_TIME_COLOR;
    public static final TextFieldConfigOption GAME_WEATHER_COLOR;
    public static final TextFieldConfigOption MOON_PHASE_COLOR;
    public static final TextFieldConfigOption FPS_VALUE_COLOR;
    public static final TextFieldConfigOption FPS_26_AND_40_COLOR;
    public static final TextFieldConfigOption FPS_LOW_25_COLOR;
    public static final TextFieldConfigOption XYZ_VALUE_COLOR;
    public static final TextFieldConfigOption DIRECTION_VALUE_COLOR;
    public static final TextFieldConfigOption BIOME_VALUE_COLOR;
    public static final TextFieldConfigOption PING_VALUE_COLOR;
    public static final TextFieldConfigOption PING_200_AND_300_COLOR;
    public static final TextFieldConfigOption PING_300_AND_500_COLOR;
    public static final TextFieldConfigOption PING_MAX_500_COLOR;
    public static final TextFieldConfigOption SERVER_IP_VALUE_COLOR;
    public static final TextFieldConfigOption SLIME_CHUNK_VALUE_COLOR;
    public static final TextFieldConfigOption TPS_VALUE_COLOR;
    public static final TextFieldConfigOption REAL_TIME_VALUE_COLOR;
    public static final TextFieldConfigOption GAME_TIME_VALUE_COLOR;
    public static final TextFieldConfigOption GAME_WEATHER_VALUE_COLOR;
    public static final TextFieldConfigOption MOON_PHASE_VALUE_COLOR;

    private ExtendedConfig() {
    }

    public static void setCurrentProfile(String profileName) {
        PROFILE_FILE = new File(USER_DIR, profileName + ".dat");
        CURRENT_PROFILE = profileName;
    }

    public void load() {
        try {
            CompoundNBT nbt = CompressedStreamTools.func_74797_a((File)PROFILE_FILE);
            if (nbt == null) {
                return;
            }
            this.fps = this.getBoolean(nbt, "FPS", this.fps);
            this.xyz = this.getBoolean(nbt, "XYZ", this.xyz);
            this.direction = this.getBoolean(nbt, "Direction", this.direction);
            this.biome = this.getBoolean(nbt, "Biome", this.biome);
            this.ping = this.getBoolean(nbt, "Ping", this.ping);
            this.pingToSecond = this.getBoolean(nbt, "PingToSecond", this.pingToSecond);
            this.serverIP = this.getBoolean(nbt, "ServerIP", this.serverIP);
            this.serverIPMCVersion = this.getBoolean(nbt, "ServerIPMCVersion", this.serverIPMCVersion);
            this.equipmentHUD = this.getBoolean(nbt, "EquipmentHUD", this.equipmentHUD);
            this.equipmentArmorItems = this.getBoolean(nbt, "EquipmentArmorItems", this.equipmentArmorItems);
            this.equipmentHandItems = this.getBoolean(nbt, "EquipmentHandItems", this.equipmentHandItems);
            this.potionHUD = this.getBoolean(nbt, "PotionHUD", this.potionHUD);
            this.slimeChunkFinder = this.getBoolean(nbt, "SlimeChunkFinder", this.slimeChunkFinder);
            this.realTime = this.getBoolean(nbt, "RealTime", this.realTime);
            this.gameTime = this.getBoolean(nbt, "GameTime", this.gameTime);
            this.gameWeather = this.getBoolean(nbt, "GameWeather", this.gameWeather);
            this.moonPhase = this.getBoolean(nbt, "MoonPhase", this.moonPhase);
            this.potionHUDIcon = this.getBoolean(nbt, "PotionHUDIcon", this.potionHUDIcon);
            this.tps = this.getBoolean(nbt, "TPS", this.tps);
            this.tpsAllDims = this.getBoolean(nbt, "TPSAllDimensions", this.tpsAllDims);
            this.alternatePotionHUDTextColor = this.getBoolean(nbt, "AlternatePotionHUDTextColor", this.alternatePotionHUDTextColor);
            this.swapRenderInfo = this.getBoolean(nbt, "SwapRenderInfo", this.swapRenderInfo);
            this.showCustomCape = this.getBoolean(nbt, "ShowCustomCape", this.showCustomCape);
            this.equipmentDirection = Equipments.Direction.byId(this.getInteger(nbt, "EquipmentDirection", this.equipmentDirection.getId()));
            this.equipmentStatus = Equipments.Status.byId(this.getInteger(nbt, "EquipmentStatus", this.equipmentStatus.getId()));
            this.equipmentPosition = Equipments.Position.byId(this.getInteger(nbt, "EquipmentPosition", this.equipmentPosition.getId()));
            this.potionHUDStyle = StatusEffects.Style.byId(this.getInteger(nbt, "PotionHUDStyle", this.potionHUDStyle.getId()));
            this.potionHUDPosition = StatusEffects.Position.byId(this.getInteger(nbt, "PotionHUDPosition", this.potionHUDPosition.getId()));
            this.pingMode = PingMode.byId(this.getInteger(nbt, "PingMode", this.pingMode.getId()));
            this.armorHUDYOffset = this.getInteger(nbt, "ArmorHUDYOffset", this.armorHUDYOffset);
            this.potionHUDYOffset = this.getInteger(nbt, "PotionHUDYOffset", this.potionHUDYOffset);
            this.maximumPotionDisplay = this.getInteger(nbt, "MaximumPotionDisplay", this.maximumPotionDisplay);
            this.potionLengthYOffset = this.getInteger(nbt, "PotionLengthYOffset", this.potionLengthYOffset);
            this.potionLengthYOffsetOverlap = this.getInteger(nbt, "PotionLengthYOffsetOverlap", this.potionLengthYOffsetOverlap);
            this.fpsColor = this.getString(nbt, "FPSColor", this.fpsColor);
            this.xyzColor = this.getString(nbt, "XYZColor", this.xyzColor);
            this.biomeColor = this.getString(nbt, "BiomeColor", this.biomeColor);
            this.directionColor = this.getString(nbt, "DirectionColor", this.directionColor);
            this.pingColor = this.getString(nbt, "PingColor", this.pingColor);
            this.pingToSecondColor = this.getString(nbt, "PingToSecondColor", this.pingToSecondColor);
            this.serverIPColor = this.getString(nbt, "ServerIPColor", this.serverIPColor);
            this.equipmentStatusColor = this.getString(nbt, "EquipmentStatusColor", this.equipmentStatusColor);
            this.arrowCountColor = this.getString(nbt, "ArrowCountColor", this.arrowCountColor);
            this.slimeChunkColor = this.getString(nbt, "SlimeChunkColor", this.slimeChunkColor);
            this.topDonatorNameColor = this.getString(nbt, "TopDonatorNameColor", this.topDonatorNameColor);
            this.recentDonatorNameColor = this.getString(nbt, "RecentDonatorNameColor", this.recentDonatorNameColor);
            this.tpsColor = this.getString(nbt, "TPSColor", this.tpsColor);
            this.realTimeColor = this.getString(nbt, "RealTimeColor", this.realTimeColor);
            this.gameTimeColor = this.getString(nbt, "GameTimeColor", this.gameTimeColor);
            this.gameWeatherColor = this.getString(nbt, "GameWeatherColor", this.gameWeatherColor);
            this.moonPhaseColor = this.getString(nbt, "MoonPhaseColor", this.moonPhaseColor);
            this.fpsValueColor = this.getString(nbt, "FPSValueColor", this.fpsValueColor);
            this.fps26And49Color = this.getString(nbt, "FPS26And49Color", this.fps26And49Color);
            this.fpsLow25Color = this.getString(nbt, "FPSLow25Color", this.fpsLow25Color);
            this.xyzValueColor = this.getString(nbt, "XYZValueColor", this.xyzValueColor);
            this.biomeValueColor = this.getString(nbt, "BiomeValueColor", this.biomeValueColor);
            this.directionValueColor = this.getString(nbt, "DirectionValueColor", this.directionValueColor);
            this.pingValueColor = this.getString(nbt, "PingValueColor", this.pingValueColor);
            this.ping200And300Color = this.getString(nbt, "Ping200And300Color", this.ping200And300Color);
            this.ping300And500Color = this.getString(nbt, "Ping300And500Color", this.ping300And500Color);
            this.pingMax500Color = this.getString(nbt, "PingMax500Color", this.pingMax500Color);
            this.serverIPValueColor = this.getString(nbt, "ServerIPValueColor", this.serverIPValueColor);
            this.slimeChunkValueColor = this.getString(nbt, "SlimeChunkValueColor", this.slimeChunkValueColor);
            this.topDonatorValueColor = this.getString(nbt, "TopDonatorValueColor", this.topDonatorValueColor);
            this.recentDonatorValueColor = this.getString(nbt, "RecentDonatorValueColor", this.recentDonatorValueColor);
            this.tpsValueColor = this.getString(nbt, "TPSValueColor", this.tpsValueColor);
            this.realTimeValueColor = this.getString(nbt, "RealTimeValueColor", this.realTimeValueColor);
            this.gameTimeValueColor = this.getString(nbt, "GameTimeValueColor", this.gameTimeValueColor);
            this.gameWeatherValueColor = this.getString(nbt, "GameWeatherValueColor", this.gameWeatherValueColor);
            this.moonPhaseValueColor = this.getString(nbt, "MoonPhaseValueColor", this.moonPhaseValueColor);
            this.slimeChunkSeed = this.getLong(nbt, "SlimeChunkSeed", this.slimeChunkSeed);
            this.rightClickToAddParty = this.getBoolean(nbt, "RightClickToAddParty", this.rightClickToAddParty);
            this.selectedHypixelMinigame = this.getInteger(nbt, "SelectedHypixelMinigame", this.selectedHypixelMinigame);
            this.hypixelMinigameScrollPos = this.getInteger(nbt, "HypixelMinigameScrollPos", this.hypixelMinigameScrollPos);
            this.chatMode = this.getInteger(nbt, "ChatMode", this.chatMode);
            IndicatiaMod.LOGGER.info("Loading extended config {}", new Object[]{PROFILE_FILE.getPath()});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save() {
        this.save(!CURRENT_PROFILE.isEmpty() ? CURRENT_PROFILE : "default");
    }

    public void save(String profileName) {
        try {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74757_a("FPS", this.fps);
            nbt.func_74757_a("XYZ", this.xyz);
            nbt.func_74757_a("Direction", this.direction);
            nbt.func_74757_a("Biome", this.biome);
            nbt.func_74757_a("Ping", this.ping);
            nbt.func_74757_a("PingToSecond", this.pingToSecond);
            nbt.func_74757_a("ServerIP", this.serverIP);
            nbt.func_74757_a("ServerIPMCVersion", this.serverIPMCVersion);
            nbt.func_74757_a("EquipmentHUD", this.equipmentHUD);
            nbt.func_74757_a("EquipmentArmorItems", this.equipmentArmorItems);
            nbt.func_74757_a("EquipmentHandItems", this.equipmentHandItems);
            nbt.func_74757_a("PotionHUD", this.potionHUD);
            nbt.func_74757_a("SlimeChunkFinder", this.slimeChunkFinder);
            nbt.func_74757_a("RealTime", this.realTime);
            nbt.func_74757_a("GameTime", this.gameTime);
            nbt.func_74757_a("GameWeather", this.gameWeather);
            nbt.func_74757_a("MoonPhase", this.moonPhase);
            nbt.func_74757_a("PotionHUDIcon", this.potionHUDIcon);
            nbt.func_74757_a("TPS", this.tps);
            nbt.func_74757_a("TPSAllDimensions", this.tpsAllDims);
            nbt.func_74757_a("AlternatePotionHUDTextColor", this.alternatePotionHUDTextColor);
            nbt.func_74757_a("ShowCustomCape", this.showCustomCape);
            nbt.func_74757_a("SwapRenderInfo", this.swapRenderInfo);
            nbt.func_74768_a("EquipmentDirection", this.equipmentDirection.getId());
            nbt.func_74768_a("EquipmentStatus", this.equipmentStatus.getId());
            nbt.func_74768_a("EquipmentPosition", this.equipmentPosition.getId());
            nbt.func_74768_a("PotionHUDStyle", this.potionHUDStyle.getId());
            nbt.func_74768_a("PotionHUDPosition", this.potionHUDPosition.getId());
            nbt.func_74768_a("PingMode", this.pingMode.getId());
            nbt.func_74768_a("ArmorHUDYOffset", this.armorHUDYOffset);
            nbt.func_74768_a("PotionHUDYOffset", this.potionHUDYOffset);
            nbt.func_74768_a("MaximumPotionDisplay", this.maximumPotionDisplay);
            nbt.func_74768_a("PotionLengthYOffset", this.potionLengthYOffset);
            nbt.func_74768_a("PotionLengthYOffsetOverlap", this.potionLengthYOffsetOverlap);
            nbt.func_74778_a("FPSColor", this.fpsColor);
            nbt.func_74778_a("XYZColor", this.xyzColor);
            nbt.func_74778_a("BiomeColor", this.biomeColor);
            nbt.func_74778_a("DirectionColor", this.directionColor);
            nbt.func_74778_a("PingColor", this.pingColor);
            nbt.func_74778_a("PingToSecondColor", this.pingToSecondColor);
            nbt.func_74778_a("ServerIPColor", this.serverIPColor);
            nbt.func_74778_a("EquipmentStatusColor", this.equipmentStatusColor);
            nbt.func_74778_a("ArrowCountColor", this.arrowCountColor);
            nbt.func_74778_a("SlimeChunkColor", this.slimeChunkColor);
            nbt.func_74778_a("TopDonatorNameColor", this.topDonatorNameColor);
            nbt.func_74778_a("RecentDonatorNameColor", this.recentDonatorNameColor);
            nbt.func_74778_a("TPSColor", this.tpsColor);
            nbt.func_74778_a("RealTimeColor", this.realTimeColor);
            nbt.func_74778_a("GameTimeColor", this.gameTimeColor);
            nbt.func_74778_a("GameWeatherColor", this.gameWeatherColor);
            nbt.func_74778_a("MoonPhaseColor", this.moonPhaseColor);
            nbt.func_74778_a("FPSValueColor", this.fpsValueColor);
            nbt.func_74778_a("FPS26And49Color", this.fps26And49Color);
            nbt.func_74778_a("FPSLow25Color", this.fpsLow25Color);
            nbt.func_74778_a("XYZValueColor", this.xyzValueColor);
            nbt.func_74778_a("BiomeValueColor", this.biomeValueColor);
            nbt.func_74778_a("DirectionValueColor", this.directionValueColor);
            nbt.func_74778_a("PingValueColor", this.pingValueColor);
            nbt.func_74778_a("Ping200And300Color", this.ping200And300Color);
            nbt.func_74778_a("Ping300And500Color", this.ping300And500Color);
            nbt.func_74778_a("PingMax500Color", this.pingMax500Color);
            nbt.func_74778_a("ServerIPValueColor", this.serverIPValueColor);
            nbt.func_74778_a("SlimeChunkValueColor", this.slimeChunkValueColor);
            nbt.func_74778_a("TopDonatorValueColor", this.topDonatorValueColor);
            nbt.func_74778_a("RecentDonatorValueColor", this.recentDonatorValueColor);
            nbt.func_74778_a("TPSValueColor", this.tpsValueColor);
            nbt.func_74778_a("RealTimeValueColor", this.realTimeValueColor);
            nbt.func_74778_a("GameTimeValueColor", this.gameTimeValueColor);
            nbt.func_74778_a("GameWeatherValueColor", this.gameWeatherValueColor);
            nbt.func_74778_a("MoonPhaseValueColor", this.moonPhaseValueColor);
            nbt.func_74772_a("SlimeChunkSeed", this.slimeChunkSeed);
            nbt.func_74757_a("RightClickToAddParty", this.rightClickToAddParty);
            nbt.func_74768_a("SelectedHypixelMinigame", this.selectedHypixelMinigame);
            nbt.func_74768_a("HypixelMinigameScrollPos", this.hypixelMinigameScrollPos);
            nbt.func_74768_a("ChatMode", this.chatMode);
            CompressedStreamTools.func_74795_b((CompoundNBT)nbt, (File)(!profileName.equalsIgnoreCase("default") ? new File(USER_DIR, profileName + ".dat") : PROFILE_FILE));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveProfileFile(String profileName) {
        File profile = new File(USER_DIR, "profile.txt");
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(profile), StandardCharsets.UTF_8));){
            writer.println("profile:" + profileName);
            IndicatiaMod.LOGGER.info("Saving profile name!");
        }
        catch (IOException e) {
            IndicatiaMod.LOGGER.error("Failed to save profile", new Object[]{e});
        }
    }

    public static void resetConfig() {
        INSTANCE = new ExtendedConfig();
        INSTANCE.save(CURRENT_PROFILE);
        ClientUtils.printClientMessage((String)LangUtils.translate((String)"misc.extended_config.reset_config", (Object[])new Object[]{CURRENT_PROFILE}));
    }

    private boolean getBoolean(CompoundNBT nbt, String key, boolean defaultValue) {
        if (nbt.func_150297_b(key, 99)) {
            return nbt.func_74767_n(key);
        }
        return defaultValue;
    }

    private int getInteger(CompoundNBT nbt, String key, int defaultValue) {
        if (nbt.func_150297_b(key, 99)) {
            return nbt.func_74762_e(key);
        }
        return defaultValue;
    }

    private String getString(CompoundNBT nbt, String key, String defaultValue) {
        if (nbt.func_150297_b(key, 8)) {
            return nbt.func_74779_i(key);
        }
        return defaultValue;
    }

    private long getLong(CompoundNBT nbt, String key, long defaultValue) {
        if (nbt.func_150297_b(key, 99)) {
            return nbt.func_74763_f(key);
        }
        return defaultValue;
    }

    static {
        ARMOR_HUD_Y = new DoubleConfigOption("armor_hud_y", -512.0, 512.0, 1.0f, config -> config.armorHUDYOffset, (config, value) -> {
            config.armorHUDYOffset = value.intValue();
        }, (config, doubleOpt) -> doubleOpt.getDisplayPrefix() + (int)doubleOpt.get());
        POTION_HUD_Y = new DoubleConfigOption("potion_hud_y", -512.0, 512.0, 1.0f, config -> config.potionHUDYOffset, (config, value) -> {
            config.potionHUDYOffset = value.intValue();
        }, (config, doubleOpt) -> doubleOpt.getDisplayPrefix() + (int)doubleOpt.get());
        MAXIMUM_POTION_DISPLAY = new DoubleConfigOption("maximum_potion_display", 2.0, 8.0, 0.0f, config -> config.maximumPotionDisplay, (config, value) -> {
            config.maximumPotionDisplay = value.intValue();
        }, (config, doubleOpt) -> doubleOpt.getDisplayPrefix() + (int)doubleOpt.get());
        POTION_LENGTH_Y_OFFSET = new DoubleConfigOption("potion_length_y_offset", 1.0, 256.0, 1.0f, config -> config.potionLengthYOffset, (config, value) -> {
            config.potionLengthYOffset = value.intValue();
        }, (config, doubleOpt) -> doubleOpt.getDisplayPrefix() + (int)doubleOpt.get());
        POTION_LENGTH_Y_OFFSET_OVERLAP = new DoubleConfigOption("potion_length_y_offset_overlap", 1.0, 256.0, 1.0f, config -> config.potionLengthYOffsetOverlap, (config, value) -> {
            config.potionLengthYOffsetOverlap = value.intValue();
        }, (config, doubleOpt) -> doubleOpt.getDisplayPrefix() + (int)doubleOpt.get());
        SWAP_INFO_POS = new BooleanConfigOption("swap_info_pos", config -> config.swapRenderInfo, (config, value) -> {
            config.swapRenderInfo = value;
        }, true);
        FPS = new BooleanConfigOption("fps", config -> config.fps, (config, value) -> {
            config.fps = value;
        });
        XYZ = new BooleanConfigOption("xyz", config -> config.xyz, (config, value) -> {
            config.xyz = value;
        });
        DIRECTION = new BooleanConfigOption("direction", config -> config.direction, (config, value) -> {
            config.direction = value;
        });
        BIOME = new BooleanConfigOption("biome", config -> config.biome, (config, value) -> {
            config.biome = value;
        });
        PING = new BooleanConfigOption("ping", config -> config.ping, (config, value) -> {
            config.ping = value;
        });
        PING_TO_SECOND = new BooleanConfigOption("ping_to_second", config -> config.pingToSecond, (config, value) -> {
            config.pingToSecond = value;
        });
        SERVER_IP = new BooleanConfigOption("server_ip", config -> config.serverIP, (config, value) -> {
            config.serverIP = value;
        });
        SERVER_IP_MC = new BooleanConfigOption("server_ip_mc", config -> config.serverIPMCVersion, (config, value) -> {
            config.serverIPMCVersion = value;
        });
        EQUIPMENT_HUD = new BooleanConfigOption("equipment_hud", config -> config.equipmentHUD, (config, value) -> {
            config.equipmentHUD = value;
        });
        EQUIPMENT_ARMOR_ITEMS = new BooleanConfigOption("equipment_armor_items", config -> config.equipmentArmorItems, (config, value) -> {
            config.equipmentArmorItems = value;
        });
        EQUIPMENT_HAND_ITEMS = new BooleanConfigOption("equipment_hand_items", config -> config.equipmentHandItems, (config, value) -> {
            config.equipmentHandItems = value;
        });
        POTION_HUD = new BooleanConfigOption("potion_hud", config -> config.potionHUD, (config, value) -> {
            config.potionHUD = value;
        });
        SLIME_CHUNK = new BooleanConfigOption("slime_chunk", config -> config.slimeChunkFinder, (config, value) -> {
            config.slimeChunkFinder = value;
        });
        REAL_TIME = new BooleanConfigOption("real_time", config -> config.realTime, (config, value) -> {
            config.realTime = value;
        });
        GAME_TIME = new BooleanConfigOption("game_time", config -> config.gameTime, (config, value) -> {
            config.gameTime = value;
        });
        GAME_WEATHER = new BooleanConfigOption("game_weather", config -> config.gameWeather, (config, value) -> {
            config.gameWeather = value;
        });
        MOON_PHASE = new BooleanConfigOption("moon_phase", config -> config.moonPhase, (config, value) -> {
            config.moonPhase = value;
        });
        POTION_ICON = new BooleanConfigOption("potion_icon", config -> config.potionHUDIcon, (config, value) -> {
            config.potionHUDIcon = value;
        });
        TPS = new BooleanConfigOption("tps", config -> config.tps, (config, value) -> {
            config.tps = value;
        });
        TPS_ALL_DIMS = new BooleanConfigOption("tps_all_dims", config -> config.tpsAllDims, (config, value) -> {
            config.tpsAllDims = value;
        });
        ALTERNATE_POTION_COLOR = new BooleanConfigOption("alternate_potion_color", config -> config.alternatePotionHUDTextColor, (config, value) -> {
            config.alternatePotionHUDTextColor = value;
        });
        RIGHT_CLICK_ADD_PARTY = new BooleanConfigOption("right_click_add_party", config -> config.rightClickToAddParty, (config, value) -> {
            config.rightClickToAddParty = value;
        });
        EQUIPMENT_DIRECTION = new StringConfigOption("equipment_direction", (config, value) -> {
            config.equipmentDirection = Equipments.Direction.byId(config.equipmentDirection.getId() + value);
        }, (config, stringOpt) -> stringOpt.getDisplayPrefix() + LangUtils.translate((String)config.equipmentDirection.getTranslationKey()));
        EQUIPMENT_STATUS = new StringConfigOption("equipment_status", (config, value) -> {
            config.equipmentStatus = Equipments.Status.byId(config.equipmentStatus.getId() + value);
        }, (config, stringOpt) -> stringOpt.getDisplayPrefix() + LangUtils.translate((String)config.equipmentStatus.getTranslationKey()));
        EQUIPMENT_POSITION = new StringConfigOption("equipment_position", (config, value) -> {
            config.equipmentPosition = Equipments.Position.byId(config.equipmentPosition.getId() + value);
        }, (config, stringOpt) -> stringOpt.getDisplayPrefix() + LangUtils.translate((String)config.equipmentPosition.getTranslationKey()));
        POTION_HUD_STYLE = new StringConfigOption("potion_hud_style", (config, value) -> {
            config.potionHUDStyle = StatusEffects.Style.byId(config.potionHUDStyle.getId() + value);
        }, (config, stringOpt) -> stringOpt.getDisplayPrefix() + LangUtils.translate((String)config.potionHUDStyle.getTranslationKey()));
        POTION_HUD_POSITION = new StringConfigOption("potion_hud_position", (config, value) -> {
            config.potionHUDPosition = StatusEffects.Position.byId(config.potionHUDPosition.getId() + value);
        }, (config, stringOpt) -> stringOpt.getDisplayPrefix() + LangUtils.translate((String)config.potionHUDPosition.getTranslationKey()));
        PING_MODE = new StringConfigOption("ping_mode", (config, value) -> {
            config.pingMode = PingMode.byId(config.pingMode.getId() + value);
        }, (config, stringOpt) -> stringOpt.getDisplayPrefix() + LangUtils.translate((String)config.pingMode.getTranslationKey()));
        FPS_COLOR = new TextFieldConfigOption("fps_color", config -> config.fpsColor, (config, value) -> {
            config.fpsColor = value;
        });
        XYZ_COLOR = new TextFieldConfigOption("xyz_color", config -> config.xyzColor, (config, value) -> {
            config.xyzColor = value;
        });
        BIOME_COLOR = new TextFieldConfigOption("biome_color", config -> config.biomeColor, (config, value) -> {
            config.biomeColor = value;
        });
        DIRECTION_COLOR = new TextFieldConfigOption("direction_color", config -> config.directionColor, (config, value) -> {
            config.directionColor = value;
        });
        PING_COLOR = new TextFieldConfigOption("ping_color", config -> config.pingColor, (config, value) -> {
            config.pingColor = value;
        });
        PING_TO_SECOND_COLOR = new TextFieldConfigOption("ping_to_second_color", config -> config.pingToSecondColor, (config, value) -> {
            config.pingToSecondColor = value;
        });
        SERVER_IP_COLOR = new TextFieldConfigOption("server_ip_color", config -> config.serverIPColor, (config, value) -> {
            config.serverIPColor = value;
        });
        EQUIPMENT_STATUS_COLOR = new TextFieldConfigOption("equipment_status_color", config -> config.equipmentStatusColor, (config, value) -> {
            config.equipmentStatusColor = value;
        });
        ARROW_COUNT_COLOR = new TextFieldConfigOption("arrow_count_color", config -> config.arrowCountColor, (config, value) -> {
            config.arrowCountColor = value;
        });
        SLIME_CHUNK_COLOR = new TextFieldConfigOption("slime_chunk_color", config -> config.slimeChunkColor, (config, value) -> {
            config.slimeChunkColor = value;
        });
        TPS_COLOR = new TextFieldConfigOption("tps_color", config -> config.tpsColor, (config, value) -> {
            config.tpsColor = value;
        });
        REAL_TIME_COLOR = new TextFieldConfigOption("real_time_color", config -> config.realTimeColor, (config, value) -> {
            config.realTimeColor = value;
        });
        GAME_TIME_COLOR = new TextFieldConfigOption("game_time_color", config -> config.gameTimeColor, (config, value) -> {
            config.gameTimeColor = value;
        });
        GAME_WEATHER_COLOR = new TextFieldConfigOption("game_weather_color", config -> config.gameWeatherColor, (config, value) -> {
            config.gameWeatherColor = value;
        });
        MOON_PHASE_COLOR = new TextFieldConfigOption("moon_phase_color", config -> config.moonPhaseColor, (config, value) -> {
            config.moonPhaseColor = value;
        });
        FPS_VALUE_COLOR = new TextFieldConfigOption("fps_value_color", config -> config.fpsValueColor, (config, value) -> {
            config.fpsValueColor = value;
        });
        FPS_26_AND_40_COLOR = new TextFieldConfigOption("fps_26_and_40_color", config -> config.fps26And49Color, (config, value) -> {
            config.fps26And49Color = value;
        });
        FPS_LOW_25_COLOR = new TextFieldConfigOption("fps_low_25_color", config -> config.fpsLow25Color, (config, value) -> {
            config.fpsLow25Color = value;
        });
        XYZ_VALUE_COLOR = new TextFieldConfigOption("xyz_value_color", config -> config.xyzValueColor, (config, value) -> {
            config.xyzValueColor = value;
        });
        DIRECTION_VALUE_COLOR = new TextFieldConfigOption("direction_value_color", config -> config.directionValueColor, (config, value) -> {
            config.directionValueColor = value;
        });
        BIOME_VALUE_COLOR = new TextFieldConfigOption("biome_value_color", config -> config.biomeValueColor, (config, value) -> {
            config.biomeValueColor = value;
        });
        PING_VALUE_COLOR = new TextFieldConfigOption("ping_value_color", config -> config.pingValueColor, (config, value) -> {
            config.pingValueColor = value;
        });
        PING_200_AND_300_COLOR = new TextFieldConfigOption("ping_200_and_300_color", config -> config.ping200And300Color, (config, value) -> {
            config.ping200And300Color = value;
        });
        PING_300_AND_500_COLOR = new TextFieldConfigOption("ping_300_and_500_color", config -> config.ping300And500Color, (config, value) -> {
            config.ping300And500Color = value;
        });
        PING_MAX_500_COLOR = new TextFieldConfigOption("ping_max_500_color", config -> config.pingMax500Color, (config, value) -> {
            config.pingMax500Color = value;
        });
        SERVER_IP_VALUE_COLOR = new TextFieldConfigOption("server_ip_value_color", config -> config.serverIPValueColor, (config, value) -> {
            config.serverIPValueColor = value;
        });
        SLIME_CHUNK_VALUE_COLOR = new TextFieldConfigOption("slime_chunk_value_color", config -> config.slimeChunkValueColor, (config, value) -> {
            config.slimeChunkValueColor = value;
        });
        TPS_VALUE_COLOR = new TextFieldConfigOption("tps_value_color", config -> config.tpsValueColor, (config, value) -> {
            config.tpsValueColor = value;
        });
        REAL_TIME_VALUE_COLOR = new TextFieldConfigOption("real_time_value_color", config -> config.realTimeValueColor, (config, value) -> {
            config.realTimeValueColor = value;
        });
        GAME_TIME_VALUE_COLOR = new TextFieldConfigOption("game_time_value_color", config -> config.gameTimeValueColor, (config, value) -> {
            config.gameTimeValueColor = value;
        });
        GAME_WEATHER_VALUE_COLOR = new TextFieldConfigOption("game_weather_value_color", config -> config.gameWeatherValueColor, (config, value) -> {
            config.gameWeatherValueColor = value;
        });
        MOON_PHASE_VALUE_COLOR = new TextFieldConfigOption("moon_phase_value_color", config -> config.moonPhaseValueColor, (config, value) -> {
            config.moonPhaseValueColor = value;
        });
    }
}

