/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.stevekung.indicatia.config.Equipments;
import com.stevekung.indicatia.config.ExtendedConfig;
import com.stevekung.indicatia.config.IndicatiaConfig;
import com.stevekung.indicatia.gui.exconfig.screen.OffsetRenderPreviewScreen;
import com.stevekung.indicatia.hud.EffectOverlays;
import com.stevekung.indicatia.hud.EquipmentOverlays;
import com.stevekung.indicatia.hud.InfoOverlay;
import com.stevekung.indicatia.hud.InfoOverlays;
import com.stevekung.indicatia.hud.InfoUtils;
import com.stevekung.stevekungslib.utils.LangUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.versions.mcp.MCPVersion;

public class HUDRenderEventHandler {
    private final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        MinecraftServer server;
        if (event.phase == TickEvent.Phase.START && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            InfoOverlays.getTPS(server);
        }
    }

    @SubscribeEvent
    public void onPreInfoRender(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.BOSSHEALTH) {
            event.setCanceled((Boolean)IndicatiaConfig.GENERAL.enableRenderBossHealthStatus.get() == false);
            RenderSystem.enableDepthTest();
            RenderSystem.defaultBlendFunc();
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS && !((Boolean)IndicatiaConfig.GENERAL.enableVanillaPotionHUD.get()).booleanValue()) {
            event.setCanceled(true);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            if (!this.mc.field_71474_y.field_74330_P) {
                if (((Boolean)IndicatiaConfig.GENERAL.enableRenderInfo.get()).booleanValue() && this.mc.field_71439_g != null && this.mc.field_71441_e != null && !(this.mc.field_71462_r instanceof OffsetRenderPreviewScreen)) {
                    int iLeft = 0;
                    int iRight = 0;
                    for (InfoOverlay info : HUDRenderEventHandler.getInfoOverlays(this.mc)) {
                        if (info.isEmpty()) continue;
                        String value = info.toString();
                        InfoOverlay.Position pos = info.getPos();
                        float defaultPos = 3.0625f;
                        this.mc.field_71466_p.getClass();
                        float fontHeight = 9 + 1;
                        float yOffset = 3.0f + fontHeight * (float)(pos == InfoOverlay.Position.LEFT ? iLeft : iRight);
                        float xOffset = this.mc.func_228018_at_().func_198107_o() - 2 - this.mc.field_71466_p.func_78256_a(value);
                        this.mc.field_71466_p.func_175063_a(value, pos == InfoOverlay.Position.LEFT ? (!ExtendedConfig.INSTANCE.swapRenderInfo ? defaultPos : xOffset) : (pos == InfoOverlay.Position.RIGHT ? (!ExtendedConfig.INSTANCE.swapRenderInfo ? xOffset : defaultPos) : defaultPos), yOffset, 0xFFFFFF);
                        if (pos == InfoOverlay.Position.LEFT) {
                            ++iLeft;
                            continue;
                        }
                        ++iRight;
                    }
                }
                if (!this.mc.field_71439_g.func_175149_v() && ExtendedConfig.INSTANCE.equipmentHUD) {
                    if (ExtendedConfig.INSTANCE.equipmentPosition == Equipments.Position.HOTBAR) {
                        EquipmentOverlays.renderHotbarEquippedItems(this.mc);
                    } else if (ExtendedConfig.INSTANCE.equipmentDirection == Equipments.Direction.VERTICAL) {
                        EquipmentOverlays.renderVerticalEquippedItems(this.mc);
                    } else {
                        EquipmentOverlays.renderHorizontalEquippedItems(this.mc);
                    }
                }
                if (ExtendedConfig.INSTANCE.potionHUD) {
                    EffectOverlays.renderPotionHUD(this.mc);
                }
            }
        } else if (this.mc.field_71462_r instanceof OffsetRenderPreviewScreen) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        InfoOverlays.OVERALL_TPS = InfoOverlay.empty();
        InfoOverlays.OVERWORLD_TPS = InfoOverlay.empty();
        InfoOverlays.TPS = InfoOverlay.empty();
        InfoOverlays.ALL_TPS.clear();
    }

    public static List<InfoOverlay> getInfoOverlays(Minecraft mc) {
        ArrayList<InfoOverlay> infos = new ArrayList<InfoOverlay>();
        BlockPos playerPos = new BlockPos(mc.func_175606_aa().func_226277_ct_(), mc.func_175606_aa().func_174813_aQ().field_72338_b, mc.func_175606_aa().func_226281_cx_());
        if (ExtendedConfig.INSTANCE.fps) {
            int fps = Minecraft.field_71470_ab;
            infos.add(new InfoOverlay("hud.fps", String.valueOf(fps), ExtendedConfig.INSTANCE.fpsColor, fps <= 25 ? ExtendedConfig.INSTANCE.fpsLow25Color : (fps >= 26 && fps <= 49 ? ExtendedConfig.INSTANCE.fps26And49Color : ExtendedConfig.INSTANCE.fpsValueColor), InfoOverlay.Position.LEFT));
        }
        if (!mc.func_71356_B()) {
            if (ExtendedConfig.INSTANCE.ping) {
                int responseTime = InfoUtils.INSTANCE.getPing();
                infos.add(new InfoOverlay("hud.ping", responseTime + "ms", ExtendedConfig.INSTANCE.pingColor, InfoUtils.INSTANCE.getResponseTimeColor(responseTime), InfoOverlay.Position.RIGHT));
                if (ExtendedConfig.INSTANCE.pingToSecond) {
                    double responseTimeSecond = (double)InfoUtils.INSTANCE.getPing() / 1000.0;
                    infos.add(new InfoOverlay("hud.ping.delay", responseTimeSecond + "s", ExtendedConfig.INSTANCE.pingToSecondColor, InfoUtils.INSTANCE.getResponseTimeColor((int)(responseTimeSecond * 1000.0)), InfoOverlay.Position.RIGHT));
                }
            }
            if (ExtendedConfig.INSTANCE.serverIP && mc.func_147104_D() != null) {
                infos.add(new InfoOverlay("IP", (mc.func_181540_al() ? "Realms Server" : mc.func_147104_D().field_78845_b) + (ExtendedConfig.INSTANCE.serverIPMCVersion ? "/" + MCPVersion.getMCVersion() : ""), ExtendedConfig.INSTANCE.serverIPColor, ExtendedConfig.INSTANCE.serverIPValueColor, InfoOverlay.Position.RIGHT));
            }
        }
        if (ExtendedConfig.INSTANCE.xyz) {
            String stringPos = playerPos.func_177958_n() + " " + playerPos.func_177956_o() + " " + playerPos.func_177952_p();
            String nether = mc.field_71439_g.field_71093_bK == DimensionType.field_223228_b_ ? "Nether " : "";
            infos.add(new InfoOverlay(nether + "XYZ", stringPos, ExtendedConfig.INSTANCE.xyzColor, ExtendedConfig.INSTANCE.xyzValueColor, InfoOverlay.Position.LEFT));
            if (mc.field_71439_g.field_71093_bK == DimensionType.field_223228_b_) {
                String stringNetherPos = playerPos.func_177958_n() * 8 + " " + playerPos.func_177956_o() + " " + playerPos.func_177952_p() * 8;
                infos.add(new InfoOverlay("Overworld XYZ", stringNetherPos, ExtendedConfig.INSTANCE.xyzColor, ExtendedConfig.INSTANCE.xyzValueColor, InfoOverlay.Position.LEFT));
            }
        }
        if (ExtendedConfig.INSTANCE.direction) {
            infos.add(InfoOverlays.getDirection(mc));
        }
        if (ExtendedConfig.INSTANCE.biome) {
            ChunkPos chunkPos = new ChunkPos(playerPos);
            Chunk worldChunk = mc.field_71441_e.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b);
            String biomeName = mc.field_71441_e.func_226691_t_(playerPos).func_205403_k().func_150254_d();
            infos.add(new InfoOverlay("hud.biome", !worldChunk.func_76621_g() ? biomeName : LangUtils.translate((String)"hud.biome.waiting_for_chunk"), ExtendedConfig.INSTANCE.biomeColor, ExtendedConfig.INSTANCE.biomeValueColor, InfoOverlay.Position.LEFT));
        }
        if (ExtendedConfig.INSTANCE.slimeChunkFinder && mc.field_71439_g.field_71093_bK == DimensionType.field_223227_a_) {
            infos.add(new InfoOverlay("hud.slime_chunk", InfoUtils.INSTANCE.isSlimeChunk(mc.field_71439_g.func_180425_c()) ? "gui.yes" : "gui.no", ExtendedConfig.INSTANCE.slimeChunkColor, ExtendedConfig.INSTANCE.slimeChunkValueColor, InfoOverlay.Position.LEFT));
        }
        if (ExtendedConfig.INSTANCE.tps) {
            infos.add(InfoOverlays.OVERALL_TPS);
            infos.add(InfoOverlays.OVERWORLD_TPS);
            infos.addAll(InfoOverlays.ALL_TPS);
            infos.add(InfoOverlays.TPS);
        }
        if (ExtendedConfig.INSTANCE.realTime) {
            infos.add(InfoOverlays.getRealWorldTime());
        }
        if (ExtendedConfig.INSTANCE.gameTime) {
            infos.add(InfoOverlays.getGameTime(mc));
        }
        if (ExtendedConfig.INSTANCE.gameWeather && mc.field_71441_e.func_72896_J()) {
            String weather = !mc.field_71441_e.func_72911_I() ? "hud.weather.raining" : "hud.weather.thundering";
            infos.add(new InfoOverlay("hud.weather", weather, ExtendedConfig.INSTANCE.gameWeatherColor, ExtendedConfig.INSTANCE.gameWeatherValueColor, InfoOverlay.Position.RIGHT));
        }
        if (ExtendedConfig.INSTANCE.moonPhase) {
            infos.add(new InfoOverlay("hud.moon_phase", InfoUtils.INSTANCE.getMoonPhase(mc), ExtendedConfig.INSTANCE.moonPhaseColor, ExtendedConfig.INSTANCE.moonPhaseValueColor, InfoOverlay.Position.RIGHT));
        }
        return infos;
    }

    public static void renderInfo(Minecraft mc) {
        if (!mc.field_71474_y.field_74330_P) {
            if (((Boolean)IndicatiaConfig.GENERAL.enableRenderInfo.get()).booleanValue() && mc.field_71439_g != null && mc.field_71441_e != null && !(mc.field_71462_r instanceof OffsetRenderPreviewScreen)) {
                int iLeft = 0;
                int iRight = 0;
                for (InfoOverlay info : HUDRenderEventHandler.getInfoOverlays(mc)) {
                    if (info.isEmpty()) continue;
                    String value = info.toString();
                    InfoOverlay.Position pos = info.getPos();
                    float defaultPos = 3.0625f;
                    mc.field_71466_p.getClass();
                    float fontHeight = 9 + 1;
                    float yOffset = 3.0f + fontHeight * (float)(pos == InfoOverlay.Position.LEFT ? iLeft : iRight);
                    float xOffset = mc.func_228018_at_().func_198107_o() - 2 - mc.field_71466_p.func_78256_a(value);
                    mc.field_71466_p.func_175063_a(value, pos == InfoOverlay.Position.LEFT ? (!ExtendedConfig.INSTANCE.swapRenderInfo ? defaultPos : xOffset) : (pos == InfoOverlay.Position.RIGHT ? (!ExtendedConfig.INSTANCE.swapRenderInfo ? xOffset : defaultPos) : defaultPos), yOffset, 0xFFFFFF);
                    if (pos == InfoOverlay.Position.LEFT) {
                        ++iLeft;
                        continue;
                    }
                    ++iRight;
                }
            }
            if (!mc.field_71439_g.func_175149_v() && ExtendedConfig.INSTANCE.equipmentHUD) {
                if (ExtendedConfig.INSTANCE.equipmentPosition == Equipments.Position.HOTBAR) {
                    EquipmentOverlays.renderHotbarEquippedItems(mc);
                } else if (ExtendedConfig.INSTANCE.equipmentDirection == Equipments.Direction.VERTICAL) {
                    EquipmentOverlays.renderVerticalEquippedItems(mc);
                } else {
                    EquipmentOverlays.renderHorizontalEquippedItems(mc);
                }
            }
            if (ExtendedConfig.INSTANCE.potionHUD) {
                EffectOverlays.renderPotionHUD(mc);
            }
        }
    }
}

