/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.event;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.stevekung.indicatia.config.IndicatiaConfig;
import com.stevekung.indicatia.core.IndicatiaMod;
import com.stevekung.indicatia.gui.exconfig.screen.ExtendedConfigScreen;
import com.stevekung.indicatia.gui.exconfig.screen.OffsetRenderPreviewScreen;
import com.stevekung.indicatia.gui.screen.ConfirmDisconnectScreen;
import com.stevekung.indicatia.gui.screen.MojangStatusScreen;
import com.stevekung.indicatia.gui.widget.MojangStatusButton;
import com.stevekung.indicatia.handler.KeyBindingHandler;
import com.stevekung.indicatia.utils.AFKMode;
import com.stevekung.stevekungslib.utils.JsonUtils;
import com.stevekung.stevekungslib.utils.LangUtils;
import java.net.InetAddress;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.multiplayer.ServerAddress;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.status.IClientStatusNetHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.handshake.client.CHandshakePacket;
import net.minecraft.network.status.client.CPingPacket;
import net.minecraft.network.status.client.CServerQueryPacket;
import net.minecraft.network.status.server.SPongPacket;
import net.minecraft.network.status.server.SServerInfoPacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.MovementInput;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class IndicatiaEventHandler {
    private final Minecraft mc = Minecraft.func_71410_x();
    public static int currentServerPing;
    private static final ThreadPoolExecutor REALTIME_PINGER;
    private long lastPinger = -1L;
    private boolean initVersionCheck;
    public static boolean START_AFK;
    public static AFKMode AFK_MODE;
    public static String AFK_REASON;
    public static int afkMoveTicks;
    public static int afkTicks;
    public static boolean START_AUTO_FISH;
    private static int autoFishTick;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.field_71439_g != null) {
            if (!this.initVersionCheck) {
                IndicatiaMod.CHECKER.startCheckIfFailed();
                if (((Boolean)IndicatiaConfig.GENERAL.enableVersionChecker.get()).booleanValue()) {
                    IndicatiaMod.CHECKER.printInfo(this.mc.field_71439_g);
                }
                this.initVersionCheck = true;
            }
            if (event.phase == TickEvent.Phase.START) {
                IndicatiaEventHandler.afkTick(this.mc.field_71439_g);
                IndicatiaEventHandler.autoFishTick(this.mc);
                if (this.mc.func_147104_D() != null) {
                    long now = Util.func_211177_b();
                    if (this.lastPinger == -1L || now - this.lastPinger > 5000L) {
                        this.lastPinger = now;
                        IndicatiaEventHandler.getRealTimeServerPing(this.mc.func_147104_D());
                    }
                }
                for (UseAction action : UseAction.values()) {
                    if (action == UseAction.NONE || !((Boolean)IndicatiaConfig.GENERAL.enableBlockhitAnimation.get()).booleanValue() || !this.mc.field_71474_y.field_74312_F.func_151470_d() || this.mc.field_71476_x == null || this.mc.field_71476_x.func_216346_c() != RayTraceResult.Type.BLOCK || this.mc.field_71439_g.func_184614_ca().func_190926_b() || this.mc.field_71439_g.func_184614_ca().func_77975_n() != action) continue;
                    this.mc.field_71439_g.func_184609_a(Hand.MAIN_HAND);
                }
            }
        }
        ForgeIngameGui.renderObjective = (Boolean)IndicatiaConfig.GENERAL.enableSidebarScoreboardRender.get();
    }

    @SubscribeEvent
    public void onInputUpdate(InputUpdateEvent event) {
        MovementInput movement = event.getMovementInput();
        if (AFK_MODE == AFKMode.RANDOM_MOVE_360) {
            int afkMoveTick = afkMoveTicks;
            if (afkMoveTick > 0 && afkMoveTick < 2) {
                movement.field_192832_b = (float)((double)movement.field_192832_b + Math.random());
                movement.field_187255_c = true;
            } else if (afkMoveTick > 2 && afkMoveTick < 4) {
                movement.field_78902_a = (float)((double)movement.field_78902_a + Math.random());
                movement.field_187257_e = true;
            } else if (afkMoveTick > 4 && afkMoveTick < 6) {
                movement.field_192832_b = (float)((double)movement.field_192832_b - Math.random());
                movement.field_187256_d = true;
            } else if (afkMoveTick > 6 && afkMoveTick < 8) {
                movement.field_78902_a = (float)((double)movement.field_78902_a - Math.random());
                movement.field_187258_f = true;
            }
        }
    }

    @SubscribeEvent
    public void onLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        IndicatiaEventHandler.stopCommandTicks();
    }

    @SubscribeEvent
    public void onPressKey(InputEvent.KeyInputEvent event) {
        if (KeyBindingHandler.KEY_QUICK_CONFIG.func_151470_d()) {
            ExtendedConfigScreen config = new ExtendedConfigScreen();
            this.mc.func_147108_a((Screen)config);
        }
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        Screen screen = event.getGui();
        if (screen instanceof MainMenuScreen) {
            int height = screen.height / 4 + 48;
            event.addWidget((Widget)new MojangStatusButton(screen.width / 2 + 104, height + 63, button -> this.mc.func_147108_a((Screen)new MojangStatusScreen(screen))));
        }
    }

    @SubscribeEvent
    public void onScreenMouseClicked(GuiScreenEvent.MouseClickedEvent.Pre event) {
        Button button;
        IGuiEventListener listener;
        Screen screen = event.getGui();
        if (((Boolean)IndicatiaConfig.GENERAL.enableConfirmToDisconnect.get()).booleanValue() && screen instanceof IngameMenuScreen && !this.mc.func_71356_B() && (listener = (IGuiEventListener)screen.children().get(7)) instanceof Button && listener.isMouseOver(event.getMouseX(), event.getMouseY()) && (button = (Button)listener).getMessage().equals(LangUtils.translate((String)"menu.disconnect"))) {
            button.playDownSound(this.mc.func_147118_V());
            this.mc.func_147108_a((Screen)new ConfirmDisconnectScreen(screen));
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        if (this.mc.field_71462_r instanceof OffsetRenderPreviewScreen) {
            event.setCanceled(true);
            return;
        }
    }

    private static void getRealTimeServerPing(ServerData server) {
        REALTIME_PINGER.submit(() -> {
            try {
                ServerAddress address = ServerAddress.func_78860_a((String)server.field_78845_b);
                final NetworkManager manager = NetworkManager.func_181124_a((InetAddress)InetAddress.getByName(address.func_78861_a()), (int)address.func_78864_b(), (boolean)false);
                manager.func_150719_a((INetHandler)new IClientStatusNetHandler(){
                    private long currentSystemTime = 0L;

                    public void func_147397_a(@Nonnull SServerInfoPacket packet) {
                        this.currentSystemTime = Util.func_211177_b();
                        manager.func_179290_a((IPacket)new CPingPacket(this.currentSystemTime));
                    }

                    public void func_147398_a(@Nonnull SPongPacket packet) {
                        long i = this.currentSystemTime;
                        long j = Util.func_211177_b();
                        currentServerPing = (int)(j - i);
                    }

                    public void func_147231_a(@Nonnull ITextComponent component) {
                    }

                    public NetworkManager func_147298_b() {
                        return manager;
                    }
                });
                manager.func_179290_a((IPacket)new CHandshakePacket(address.func_78861_a(), address.func_78864_b(), ProtocolType.STATUS));
                manager.func_179290_a((IPacket)new CServerQueryPacket());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private static void afkTick(ClientPlayerEntity player) {
        if (START_AFK) {
            float angle;
            int tick = ++afkTicks;
            int messageMin = 1200 * (Integer)IndicatiaConfig.GENERAL.afkMessageTime.get();
            float f = angle = tick % 2 == 0 ? 1.0E-4f : -1.0E-4f;
            if (((Boolean)IndicatiaConfig.GENERAL.enableAFKMessage.get()).booleanValue() && tick % messageMin == 0) {
                String reason = AFK_REASON;
                reason = StringUtils.func_151246_b((String)reason) ? "" : ", " + LangUtils.translate((String)"commands.afk.reason") + ": " + reason;
                player.func_71165_d("AFK : " + StringUtils.func_76337_a((int)tick) + " minute" + (tick == 0 ? "" : "s") + reason);
            }
            switch (AFK_MODE) {
                case IDLE: {
                    player.func_195049_a((double)angle, (double)angle);
                    break;
                }
                case RANDOM_MOVE: {
                    player.func_195049_a((double)angle, (double)angle);
                    ++afkMoveTicks;
                    afkMoveTicks %= 8;
                    break;
                }
                case RANDOM_360: {
                    player.func_195049_a((double)((float)(Math.random() + 1.0)), 0.0);
                    break;
                }
                case RANDOM_MOVE_360: {
                    player.func_195049_a((double)((float)(Math.random() + 1.0)), 0.0);
                    ++afkMoveTicks;
                    afkMoveTicks %= 8;
                }
            }
        } else {
            afkTicks = 0;
        }
    }

    private static void stopCommandTicks() {
        if (START_AFK) {
            START_AFK = false;
            AFK_REASON = "";
            afkTicks = 0;
            afkMoveTicks = 0;
            AFK_MODE = AFKMode.IDLE;
            IndicatiaMod.LOGGER.info("Stopping AFK Command");
        }
        if (START_AUTO_FISH) {
            START_AUTO_FISH = false;
            autoFishTick = 0;
            IndicatiaMod.LOGGER.info("Stopping Autofish Command");
        }
    }

    private static void autoFishTick(Minecraft mc) {
        if (START_AUTO_FISH) {
            if (mc.field_71476_x != null && mc.field_71441_e != null && ++autoFishTick % 4 == 0) {
                for (Hand hand : Hand.values()) {
                    ActionResultType result;
                    ItemStack itemStack = mc.field_71439_g.func_184586_b(hand);
                    boolean mainHand = mc.field_71439_g.func_184614_ca().func_77973_b() instanceof FishingRodItem;
                    boolean offHand = mc.field_71439_g.func_184592_cb().func_77973_b() instanceof FishingRodItem;
                    if (mc.field_71439_g.func_184614_ca().func_77973_b() instanceof FishingRodItem) {
                        offHand = false;
                    }
                    if (mainHand || offHand) {
                        if (mc.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK) {
                            BlockRayTraceResult blockRayTrace = (BlockRayTraceResult)mc.field_71476_x;
                            ActionResultType result2 = mc.field_71442_b.func_217292_a(mc.field_71439_g, mc.field_71441_e, hand, blockRayTrace);
                            if (result2.func_226246_a_()) {
                                if (result2.func_226247_b_()) {
                                    mc.field_71439_g.func_184609_a(hand);
                                }
                                return;
                            }
                            if (result2 == ActionResultType.FAIL) {
                                return;
                            }
                        }
                    } else {
                        START_AUTO_FISH = false;
                        autoFishTick = 0;
                        mc.field_71439_g.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"commands.auto_fish.not_equipped_fishing_rod")).func_211708_a(TextFormatting.RED));
                        return;
                    }
                    if (itemStack.func_190926_b() || !(result = mc.field_71442_b.func_187101_a((PlayerEntity)mc.field_71439_g, (World)mc.field_71441_e, hand)).func_226246_a_()) continue;
                    if (result.func_226247_b_()) {
                        mc.field_71439_g.func_184609_a(hand);
                    }
                    mc.field_71460_t.field_78516_c.func_187460_a(hand);
                    return;
                }
            }
        } else {
            autoFishTick = 0;
        }
    }

    static {
        REALTIME_PINGER = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Real Time Server Pinger #%d").setDaemon(true).build());
        AFK_MODE = AFKMode.IDLE;
    }
}

