/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.gui.screen;

import com.stevekung.indicatia.config.ExtendedConfig;
import com.stevekung.indicatia.config.IndicatiaConfig;
import com.stevekung.indicatia.gui.widget.DropdownMinigamesButton;
import com.stevekung.indicatia.gui.widget.MinigameButton;
import com.stevekung.indicatia.hud.InfoUtils;
import com.stevekung.indicatia.utils.MinigameData;
import com.stevekung.stevekungslib.client.event.ChatScreenEvent;
import com.stevekung.stevekungslib.utils.ColorUtils;
import com.stevekung.stevekungslib.utils.JsonUtils;
import com.stevekung.stevekungslib.utils.LangUtils;
import com.stevekung.stevekungslib.utils.client.ClientUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class IndicatiaChatScreen
implements DropdownMinigamesButton.IDropboxCallback {
    private DropdownMinigamesButton dropdown;
    private int prevSelect = -1;
    private ChatMode mode = ChatMode.ALL;

    @SubscribeEvent
    public void onChatInit(ChatScreenEvent.Init event) {
        this.updateButton(event.getButtons(), event.getChildren(), event.getWidth(), event.getHeight());
        if (ExtendedConfig.INSTANCE.chatMode < ChatMode.values().length) {
            this.mode = ChatMode.values()[ExtendedConfig.INSTANCE.chatMode];
        }
    }

    @SubscribeEvent
    public void onChatRenderPre(ChatScreenEvent.RenderPre event) {
        if (((Boolean)IndicatiaConfig.GENERAL.enableHypixelChatMode.get()).booleanValue() && InfoUtils.INSTANCE.isHypixel()) {
            Minecraft mc = Minecraft.func_71410_x();
            String chatMode = LangUtils.translate((String)"menu.chat_mode") + ": " + JsonUtils.create((String)LangUtils.translate((String)this.mode.desc)).func_211709_a(new TextFormatting[]{this.mode.color, TextFormatting.BOLD}).func_150254_d();
            int x = 4;
            int y = mc.field_71462_r.height - 30;
            AbstractGui.fill((int)(x - 2), (int)(y - 3), (int)(x + mc.field_71466_p.func_78256_a(chatMode) + 2), (int)(y + 10), (int)ColorUtils.to32BitColor((int)128, (int)0, (int)0, (int)0));
            mc.field_71466_p.func_175063_a(chatMode, (float)x, (float)y, ColorUtils.rgbToDecimal((int)255, (int)255, (int)255));
        }
    }

    @SubscribeEvent
    public void onChatRenderPost(ChatScreenEvent.RenderPost event) {
        if (((Boolean)IndicatiaConfig.GENERAL.enableHypixelDropdownShortcutGame.get()).booleanValue()) {
            for (Widget button : event.getButtons()) {
                if (!(button instanceof MinigameButton)) continue;
                MinigameButton customButton = (MinigameButton)button;
                customButton.render(event.getMouseX(), event.getMouseY());
            }
        }
    }

    @SubscribeEvent
    public void onChatTick(ChatScreenEvent.Tick event) {
        if (InfoUtils.INSTANCE.isHypixel() && ((Boolean)IndicatiaConfig.GENERAL.enableHypixelDropdownShortcutGame.get()).booleanValue()) {
            if (this.prevSelect != ExtendedConfig.INSTANCE.selectedHypixelMinigame) {
                this.updateButton(event.getButtons(), event.getChildren(), event.getWidth(), event.getHeight());
                this.prevSelect = ExtendedConfig.INSTANCE.selectedHypixelMinigame;
            }
            boolean clicked = !this.dropdown.dropdownClicked;
            for (Widget button : event.getButtons()) {
                if (!(button instanceof MinigameButton)) continue;
                MinigameButton buttonCustom = (MinigameButton)button;
                buttonCustom.visible = clicked;
            }
        }
    }

    @SubscribeEvent
    public void onChatClose(ChatScreenEvent.Close event) {
        ExtendedConfig.INSTANCE.save();
    }

    @SubscribeEvent
    public void onChatMouseScrolled(ChatScreenEvent.MouseScroll event) {
        double delta = event.getScrollDelta();
        if (((Boolean)IndicatiaConfig.GENERAL.enableHypixelDropdownShortcutGame.get()).booleanValue() && this.dropdown != null && this.dropdown.dropdownClicked && this.dropdown.isHoverDropdown(event.getMouseX(), event.getMouseY())) {
            if (delta > 1.0) {
                delta = 1.0;
            }
            if (delta < -1.0) {
                delta = -1.0;
            }
            if (ClientUtils.isControlKeyDown()) {
                delta *= 7.0;
            }
            this.dropdown.scroll(delta);
            event.setCanceled(true);
        }
    }

    @Override
    public void onSelectionChanged(DropdownMinigamesButton dropdown, int selection) {
        ExtendedConfig.INSTANCE.selectedHypixelMinigame = selection;
        ExtendedConfig.INSTANCE.save();
    }

    @Override
    public int getInitialSelection(DropdownMinigamesButton dropdown) {
        return ExtendedConfig.INSTANCE.selectedHypixelMinigame;
    }

    private void updateButton(List<Widget> buttons, List<IGuiEventListener> children, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        buttons.clear();
        children.clear();
        if (player == null || !(mc.field_71462_r instanceof ChatScreen)) {
            return;
        }
        if (InfoUtils.INSTANCE.isHypixel()) {
            ArrayList<String> list = new ArrayList<String>();
            for (MinigameData data : MinigameData.getMinigames()) {
                list.add(data.getName());
            }
            String max = Collections.max(list, Comparator.comparing(String::length));
            int length = mc.field_71466_p.func_78256_a(max) + 32;
            if (((Boolean)IndicatiaConfig.GENERAL.enableHypixelChatMode.get()).booleanValue()) {
                for (ChatMode mode : ChatMode.values()) {
                    buttons.add((Widget)new Button(width - mode.x, height - mode.y, mode.width, mode.height, mode.message, button -> {
                        this.mode = mode;
                        player.func_71165_d(mode.command);
                        ExtendedConfig.INSTANCE.chatMode = mode.ordinal();
                    }));
                }
            }
            if (((Boolean)IndicatiaConfig.GENERAL.enableHypixelDropdownShortcutGame.get()).booleanValue()) {
                this.dropdown = new DropdownMinigamesButton(this, width - length, 2, list);
                buttons.add((Widget)this.dropdown);
                this.dropdown.setWidth(length);
                this.prevSelect = ExtendedConfig.INSTANCE.selectedHypixelMinigame;
                ArrayList<MinigameButton> gameBtn = new ArrayList<MinigameButton>();
                int xPos2 = width - 99;
                if (this.prevSelect > list.size()) {
                    this.prevSelect = 0;
                    ExtendedConfig.INSTANCE.hypixelMinigameScrollPos = 0;
                    ExtendedConfig.INSTANCE.selectedHypixelMinigame = 0;
                }
                for (MinigameData data : MinigameData.getMinigames()) {
                    for (MinigameData.Command command : data.getCommands()) {
                        if (!data.getName().equals(list.get(this.prevSelect))) continue;
                        ItemStack skull = ItemStack.field_190927_a;
                        if (!StringUtils.func_151246_b((String)command.getUUID())) {
                            skull = this.getSkullItemStack(command.getUUID(), command.getTexture());
                        }
                        gameBtn.add(new MinigameButton(width, command.getName(), command.isMinigame(), button -> player.func_71165_d(command.getCommand().startsWith("/") ? command.getCommand() : (command.isMinigame() ? "/play " + command.getCommand() : "/lobby " + command.getCommand())), skull));
                    }
                }
                for (int i = 0; i < gameBtn.size(); ++i) {
                    MinigameButton button2 = (MinigameButton)((Object)gameBtn.get(i));
                    if (i >= 6 && i <= 10) {
                        button2.x = xPos2 - 136;
                        button2.y = 41;
                    } else if (i >= 11 && i <= 15) {
                        button2.x = xPos2 - 241;
                        button2.y = 62;
                    } else if (i >= 16 && i <= 20) {
                        button2.x = xPos2 - 346;
                        button2.y = 83;
                    } else if (i >= 21) {
                        button2.x = xPos2 - 451;
                        button2.y = 104;
                    }
                    button2.x += 21 * i;
                    buttons.add((Widget)button2);
                }
            }
            for (Widget button3 : buttons) {
                if (!(button3 instanceof MinigameButton)) continue;
                button3.visible = false;
            }
            children.addAll(buttons);
        }
    }

    private ItemStack getSkullItemStack(String skullId, String skullValue) {
        ItemStack itemStack = new ItemStack((IItemProvider)Items.field_196184_dx);
        CompoundNBT compound = new CompoundNBT();
        CompoundNBT properties = new CompoundNBT();
        properties.func_74778_a("Id", skullId);
        CompoundNBT texture = new CompoundNBT();
        ListNBT list = new ListNBT();
        CompoundNBT value = new CompoundNBT();
        value.func_74778_a("Value", skullValue);
        list.add((Object)value);
        texture.func_218657_a("textures", (INBT)list);
        properties.func_218657_a("Properties", (INBT)texture);
        compound.func_218657_a("SkullOwner", (INBT)properties);
        itemStack.func_77982_d(compound);
        return itemStack;
    }

    public static enum ChatMode implements IExtensibleEnum
    {
        ALL("menu.chat_mode.all_chat", TextFormatting.GRAY, 23, 35, 20, 20, "A", "/chat a"),
        PARTY("menu.chat_mode.party_chat", TextFormatting.BLUE, 23, 56, 20, 20, "P", "/chat p"),
        GUILD("menu.chat_mode.guild_chat", TextFormatting.DARK_GREEN, 23, 77, 20, 20, "G", "/chat g");

        protected final String desc;
        protected final TextFormatting color;
        protected final int x;
        protected final int y;
        protected final int width;
        protected final int height;
        protected final String message;
        protected final String command;

        private ChatMode(String desc, TextFormatting color, int x, int y, int width, int height, String message, String command) {
            this.desc = desc;
            this.color = color;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.message = message;
            this.command = command;
        }

        public static ChatMode create(String name, String desc, TextFormatting color, int x, int y, int width, int height, String message, String command) {
            throw new IllegalStateException("Enum not extended");
        }
    }
}

