/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.stevekung.indicatia.config.ExtendedConfig;
import com.stevekung.stevekungslib.utils.ColorUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;

public class DropdownMinigamesButton
extends Button {
    private static final ResourceLocation TEXTURE = new ResourceLocation("indicatia:textures/gui/dropdown.png");
    public boolean dropdownClicked;
    private int selectedMinigame = -1;
    private final List<String> minigameLists;
    private final IDropboxCallback parentClass;
    private final int displayLength;

    public DropdownMinigamesButton(IDropboxCallback parentClass, int x, int y, List<String> minigameLists) {
        super(x, y, 15, 15, "Minigame Dropdown Button", null);
        this.parentClass = parentClass;
        this.minigameLists = minigameLists;
        this.displayLength = this.minigameLists.size() <= 6 ? this.minigameLists.size() : 6;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        int hoverColor = 150;
        int hoverPos = (mouseY - this.y) / this.height;
        boolean bl = this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
        if (!this.dropdownClicked && this.isHovered) {
            hoverColor = 180;
        }
        if (this.selectedMinigame == -1) {
            int size;
            int initSelect = this.parentClass.getInitialSelection(this);
            if (initSelect > (size = this.minigameLists.size() + ExtendedConfig.INSTANCE.hypixelMinigameScrollPos) || ExtendedConfig.INSTANCE.selectedHypixelMinigame > size || size == 1) {
                initSelect = 0;
                ExtendedConfig.INSTANCE.hypixelMinigameScrollPos = 0;
                ExtendedConfig.INSTANCE.selectedHypixelMinigame = 0;
            }
            this.selectedMinigame = initSelect;
        }
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AbstractGui.fill((int)this.x, (int)this.y, (int)(this.x + this.width - 15), (int)(this.y + (this.dropdownClicked ? this.height * this.displayLength + 15 : this.height)), (int)ColorUtils.to32BitColor((int)255, (int)0, (int)0, (int)0));
        AbstractGui.fill((int)(this.x + 1), (int)(this.y + 1), (int)(this.x + this.width - 16), (int)(this.y + (this.dropdownClicked ? this.height * this.displayLength + 15 : this.height) - 1), (int)ColorUtils.to32BitColor((int)255, (int)hoverColor, (int)hoverColor, (int)hoverColor));
        if (this.dropdownClicked) {
            AbstractGui.fill((int)(this.x + 1), (int)(this.y + 1), (int)(this.x + this.width - 16), (int)(this.y - 1 + this.height), (int)ColorUtils.to32BitColor((int)255, (int)120, (int)120, (int)120));
        }
        AbstractGui.fill((int)(this.x + this.width - 15), (int)this.y, (int)(this.x + this.width - 1), (int)(this.y + this.height), (int)ColorUtils.to32BitColor((int)255, (int)0, (int)0, (int)0));
        AbstractGui.fill((int)(this.x + this.width - 15), (int)(this.y + 1), (int)(this.x + this.width - 2), (int)(this.y + this.height - 1), (int)ColorUtils.to32BitColor((int)255, (int)150, (int)150, (int)150));
        if (this.displayLength > 1 && this.dropdownClicked) {
            if (this.isHoverDropdown(mouseX, mouseY)) {
                AbstractGui.fill((int)(this.x + 1), (int)(this.y + 2 + this.height * hoverPos - 1), (int)(this.x + this.width - 16), (int)(this.y + this.height * (hoverPos + 1) - 1), (int)ColorUtils.to32BitColor((int)255, (int)180, (int)180, (int)180));
            }
            if (mouseX >= this.x && mouseY >= this.y + 16 && mouseX < this.x + this.width - 16 && mouseY < this.y + this.height * this.displayLength + 15) {
                AbstractGui.fill((int)(this.x + 1), (int)(this.y + this.height * hoverPos - 1), (int)(this.x + this.width - 16), (int)(this.y + this.height * (hoverPos + 1) - 2), (int)ColorUtils.to32BitColor((int)255, (int)180, (int)180, (int)180));
            }
        }
        for (int i = 0; i + ExtendedConfig.INSTANCE.hypixelMinigameScrollPos < this.minigameLists.size() && i < this.displayLength; ++i) {
            String minigames = this.minigameLists.get(i + ExtendedConfig.INSTANCE.hypixelMinigameScrollPos);
            if (minigames == null) continue;
            if (this.dropdownClicked) {
                mc.field_71466_p.func_175063_a(minigames, (float)(this.x + this.width / 2 - 7 - mc.field_71466_p.func_78256_a(minigames) / 2), (float)(this.y + (this.height + 22) / 2 + this.height * i), ColorUtils.to32BitColor((int)255, (int)255, (int)255, (int)255));
                mc.field_71466_p.func_175063_a(this.minigameLists.get(this.selectedMinigame), (float)(this.x + this.width / 2 - 7 - mc.field_71466_p.func_78256_a(this.minigameLists.get(this.selectedMinigame)) / 2), (float)(this.y + (this.height - 6) / 2), ColorUtils.to32BitColor((int)255, (int)255, (int)255, (int)255));
                continue;
            }
            mc.field_71466_p.func_175063_a(this.minigameLists.get(this.selectedMinigame), (float)(this.x + this.width / 2 - 7 - mc.field_71466_p.func_78256_a(this.minigameLists.get(this.selectedMinigame)) / 2), (float)(this.y + (this.height - 6) / 2), ColorUtils.to32BitColor((int)255, (int)255, (int)255, (int)255));
        }
        mc.func_110434_K().func_110577_a(TEXTURE);
        AbstractGui.blit((int)(this.x + this.width - 12), (int)(this.y + 5), (float)0.0f, (float)0.0f, (int)7, (int)4, (int)7, (int)4);
        RenderSystem.popMatrix();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseEvent) {
        if (this.displayLength == 1) {
            return false;
        }
        if (!this.dropdownClicked) {
            if (this.isHovered) {
                this.dropdownClicked = true;
                this.playDownSound(Minecraft.func_71410_x().func_147118_V());
                return true;
            }
        } else {
            if (mouseX >= (double)this.x && mouseY >= (double)(this.y + 15) && mouseX < (double)(this.x + this.width - 16) && mouseY < (double)(this.y + 15 + this.height * this.displayLength)) {
                double optionClicked = (mouseY - (double)this.y - 16.0) / (double)this.height + (double)ExtendedConfig.INSTANCE.hypixelMinigameScrollPos;
                this.selectedMinigame = (int)optionClicked % this.minigameLists.size();
                this.dropdownClicked = false;
                this.parentClass.onSelectionChanged(this, this.selectedMinigame);
                this.playDownSound(Minecraft.func_71410_x().func_147118_V());
                return true;
            }
            this.dropdownClicked = false;
            return false;
        }
        return false;
    }

    public void scroll(double amount) {
        ExtendedConfig.INSTANCE.hypixelMinigameScrollPos = (int)((double)ExtendedConfig.INSTANCE.hypixelMinigameScrollPos - amount);
        int i = this.minigameLists.size();
        if (ExtendedConfig.INSTANCE.hypixelMinigameScrollPos > i - this.displayLength) {
            ExtendedConfig.INSTANCE.hypixelMinigameScrollPos = i - this.displayLength;
        }
        if (ExtendedConfig.INSTANCE.hypixelMinigameScrollPos <= 0) {
            ExtendedConfig.INSTANCE.hypixelMinigameScrollPos = 0;
        }
    }

    public boolean isHoverDropdown(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width - 16) && mouseY < (double)(this.y + this.height * this.displayLength + 15);
    }

    public static interface IDropboxCallback {
        public void onSelectionChanged(DropdownMinigamesButton var1, int var2);

        public int getInitialSelection(DropdownMinigamesButton var1);
    }
}

