/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.hud;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.systems.RenderSystem;
import com.stevekung.indicatia.config.ExtendedConfig;
import com.stevekung.indicatia.config.StatusEffects;
import com.stevekung.stevekungslib.utils.LangUtils;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.util.math.MathHelper;

public class EffectOverlays {
    public static void renderPotionHUD(Minecraft mc) {
        int yPotion;
        int xPotion;
        boolean iconAndTime = ExtendedConfig.INSTANCE.potionHUDStyle == StatusEffects.Style.ICON_AND_TIME;
        boolean right = ExtendedConfig.INSTANCE.potionHUDPosition == StatusEffects.Position.RIGHT;
        boolean showIcon = ExtendedConfig.INSTANCE.potionHUDIcon;
        int size = ExtendedConfig.INSTANCE.maximumPotionDisplay;
        int length = ExtendedConfig.INSTANCE.potionLengthYOffset;
        int lengthOverlap = ExtendedConfig.INSTANCE.potionLengthYOffsetOverlap;
        Collection collection = mc.field_71439_g.func_70651_bq();
        PotionSpriteUploader uploader = mc.func_213248_ap();
        if (ExtendedConfig.INSTANCE.potionHUDPosition == StatusEffects.Position.HOTBAR_LEFT) {
            xPotion = mc.func_228018_at_().func_198107_o() / 2 - 91 - 35;
            yPotion = mc.func_228018_at_().func_198087_p() - 46;
        } else if (ExtendedConfig.INSTANCE.potionHUDPosition == StatusEffects.Position.HOTBAR_RIGHT) {
            xPotion = mc.func_228018_at_().func_198107_o() / 2 + 91 - 20;
            yPotion = mc.func_228018_at_().func_198087_p() - 42;
        } else {
            xPotion = right ? mc.func_228018_at_().func_198107_o() - 32 : -24;
            yPotion = mc.func_228018_at_().func_198087_p() - 220 + ExtendedConfig.INSTANCE.potionHUDYOffset + 90;
        }
        if (!collection.isEmpty()) {
            if (collection.size() > size) {
                length = lengthOverlap / (collection.size() - 1);
            }
            for (EffectInstance effectIns : Ordering.natural().sortedCopy((Iterable)collection)) {
                int xOffset;
                int textColor;
                float alpha = 1.0f;
                int duration = effectIns.func_76459_b();
                TextureAtlasSprite sprite = uploader.func_215288_a(effectIns.func_188419_a());
                if (!effectIns.func_82720_e() && duration <= 200) {
                    int j1 = 10 - duration / 20;
                    alpha = MathHelper.func_76131_a((float)((float)duration / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + MathHelper.func_76134_b((float)((float)duration * (float)Math.PI / 5.0f)) * MathHelper.func_76131_a((float)((float)j1 / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
                }
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                RenderSystem.disableLighting();
                mc.func_110434_K().func_110577_a(sprite.func_229241_m_().func_229223_g_());
                Effect effect = effectIns.func_188419_a();
                int amplifier = effectIns.func_76458_c();
                String name = LangUtils.translate((String)effect.func_76393_a());
                String durationTxt = EffectUtils.func_188410_a((EffectInstance)effectIns, (float)1.0f);
                int stringwidth1 = mc.field_71466_p.func_78256_a(name);
                int stringwidth2 = mc.field_71466_p.func_78256_a(durationTxt);
                int yOffset = iconAndTime ? 11 : 16;
                int alphaRGB = (int)(alpha *= 255.0f) << 24 & 0xFF000000;
                int n = textColor = ExtendedConfig.INSTANCE.alternatePotionHUDTextColor ? effect.func_76401_j() | alphaRGB : 0xFFFFFF | alphaRGB;
                if (amplifier >= 1 && amplifier <= 9) {
                    name = name + ' ' + LangUtils.translate((String)("enchantment.level." + (amplifier + 1)));
                }
                if (duration <= 16) continue;
                if (showIcon) {
                    AbstractGui.blit((int)(right ? xPotion + 12 : xPotion + 28), (int)(yPotion + 6), (int)mc.field_71456_v.blitOffset, (int)18, (int)18, (TextureAtlasSprite)mc.func_213248_ap().func_215288_a(effect));
                }
                if (ExtendedConfig.INSTANCE.potionHUDPosition == StatusEffects.Position.HOTBAR_LEFT) {
                    int n2 = xOffset = showIcon ? 8 : 28;
                    if (!iconAndTime) {
                        mc.field_71466_p.func_175063_a(name, (float)(xPotion + xOffset - stringwidth2), (float)(yPotion + 6), textColor);
                    }
                    mc.field_71466_p.func_175063_a(durationTxt, (float)(xPotion + xOffset - stringwidth1), (float)(yPotion + yOffset), textColor);
                } else if (ExtendedConfig.INSTANCE.potionHUDPosition == StatusEffects.Position.HOTBAR_RIGHT) {
                    int n3 = xOffset = showIcon ? 46 : 28;
                    if (!iconAndTime) {
                        mc.field_71466_p.func_175063_a(name, (float)(xPotion + xOffset), (float)(yPotion + 6), textColor);
                    }
                    mc.field_71466_p.func_175063_a(durationTxt, (float)(xPotion + xOffset), (float)(yPotion + yOffset), textColor);
                } else {
                    int rightXOffset;
                    int leftXOffset = showIcon ? 50 : 28;
                    int n4 = rightXOffset = showIcon ? 8 : 28;
                    if (!iconAndTime) {
                        mc.field_71466_p.func_175063_a(name, right ? (float)(xPotion + rightXOffset - stringwidth2) : (float)(xPotion + leftXOffset), (float)(yPotion + 6), textColor);
                    }
                    mc.field_71466_p.func_175063_a(durationTxt, right ? (float)(xPotion + rightXOffset - stringwidth1) : (float)(xPotion + leftXOffset), (float)(yPotion + yOffset), textColor);
                }
                yPotion -= length;
            }
        }
    }
}

