/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.hud;

import com.stevekung.indicatia.config.Equipments;
import com.stevekung.indicatia.config.ExtendedConfig;
import com.stevekung.stevekungslib.utils.ModDecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;

public class EquipmentOverlay {
    private static final ModDecimalFormat STACK = new ModDecimalFormat("#.##");
    protected final ItemStack itemStack;
    protected final Minecraft mc;

    public EquipmentOverlay(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.mc = Minecraft.func_71410_x();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public String renderInfo() {
        Equipments.Status status = ExtendedConfig.INSTANCE.equipmentStatus;
        if (status == Equipments.Status.NONE || this.itemStack.func_77984_f() && (status == Equipments.Status.AMOUNT || status == Equipments.Status.AMOUNT_AND_STACK)) {
            return "";
        }
        int itemCount = EquipmentOverlay.getInventoryItemCount(this.mc.field_71439_g.field_71071_by, this.itemStack);
        if (this.itemStack.func_77984_f()) {
            return EquipmentOverlay.getArmorDurabilityStatus(this.itemStack);
        }
        return EquipmentOverlay.getItemStackCount(this.itemStack, itemCount);
    }

    public String renderArrowInfo() {
        int arrowCount = EquipmentOverlay.getInventoryArrowCount(this.mc.field_71439_g.field_71071_by);
        if (this.itemStack.func_77973_b() instanceof BowItem && arrowCount > 0) {
            return String.valueOf(arrowCount);
        }
        return "";
    }

    public static void renderItem(ItemStack itemStack, int x, int y) {
        ItemRenderer itemRender = Minecraft.func_71410_x().func_175599_af();
        itemRender.field_77023_b = -200.0f;
        itemRender.func_180450_b(itemStack, x, y);
        itemRender.field_77023_b = 0.0f;
    }

    private static String getArmorDurabilityStatus(ItemStack itemStack) {
        switch (ExtendedConfig.INSTANCE.equipmentStatus) {
            default: {
                return itemStack.func_77958_k() - itemStack.func_77952_i() + "/" + itemStack.func_77958_k();
            }
            case PERCENT: {
                return EquipmentOverlay.calculateItemDurabilityPercent(itemStack) + "%";
            }
            case DAMAGE: {
                return String.valueOf(itemStack.func_77958_k() - itemStack.func_77952_i());
            }
            case NONE: 
            case AMOUNT: 
            case AMOUNT_AND_STACK: 
        }
        return "";
    }

    private static int calculateItemDurabilityPercent(ItemStack itemStack) {
        return itemStack.func_77958_k() <= 0 ? 0 : 100 - itemStack.func_77952_i() * 100 / itemStack.func_77958_k();
    }

    private static String getItemStackCount(ItemStack itemStack, int count) {
        Equipments.Status status = ExtendedConfig.INSTANCE.equipmentStatus;
        double stack = (double)count / (double)itemStack.func_77976_d();
        return count == 1 || itemStack.func_77942_o() && itemStack.func_77978_p().func_74767_n("Unbreakable") ? "" : String.valueOf(status == Equipments.Status.AMOUNT_AND_STACK ? count + "/" + STACK.format(stack) : Integer.valueOf(count));
    }

    private static int getInventoryItemCount(PlayerInventory inventory, ItemStack other) {
        int count = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack playerItems = inventory.func_70301_a(i);
            if (playerItems.func_190926_b() || playerItems.func_77973_b() != other.func_77973_b() || !ItemStack.func_77970_a((ItemStack)playerItems, (ItemStack)other)) continue;
            count += playerItems.func_190916_E();
        }
        return count;
    }

    private static int getInventoryArrowCount(PlayerInventory inventory) {
        int arrowCount = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof ArrowItem)) continue;
            arrowCount += itemStack.func_190916_E();
        }
        return arrowCount;
    }
}

