/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.mixin;

import com.google.common.collect.Ordering;
import com.stevekung.indicatia.config.ExtendedConfig;
import com.stevekung.indicatia.config.IndicatiaConfig;
import com.stevekung.indicatia.config.PingMode;
import com.stevekung.stevekungslib.utils.client.ClientUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.overlay.PlayerTabOverlayGui;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerTabOverlayGui.class})
public abstract class MixinPlayerTabOverlayGui
extends AbstractGui {
    @Shadow
    @Final
    @Mutable
    private Minecraft field_175250_f;
    @Shadow
    @Final
    @Mutable
    private static Ordering<NetworkPlayerInfo> field_175252_a;

    @Redirect(method={"render(ILnet/minecraft/scoreboard/Scoreboard;Lnet/minecraft/scoreboard/ScoreObjective;)V"}, at=@At(value="INVOKE", target="net/minecraft/client/gui/FontRenderer.getStringWidth(Ljava/lang/String;)I", ordinal=0))
    private int addStringWidth(FontRenderer fontRenderer, String text, int width, Scoreboard scoreboard, @Nullable ScoreObjective scoreObjective) {
        boolean pingDelay = ExtendedConfig.INSTANCE.pingMode == PingMode.PING_AND_DELAY;
        int pingWidth = 0;
        for (NetworkPlayerInfo info : field_175252_a.sortedCopy((Iterable)this.field_175250_f.field_71439_g.field_71174_a.func_175106_d())) {
            int ping = info.func_178853_c();
            String pingText = String.valueOf(ping);
            if (pingDelay) {
                pingText = pingText + "/" + String.format("%.2f", Float.valueOf((float)ping / 1000.0f)) + "s";
            }
            pingWidth = ((Boolean)IndicatiaConfig.GENERAL.enableCustomPlayerList.get()).booleanValue() ? (pingDelay ? ClientUtils.unicodeFontRenderer.func_78256_a(pingText) : this.field_175250_f.field_71466_p.func_78256_a(pingText)) : 0;
        }
        return fontRenderer.func_78256_a(text) + (scoreObjective != null && scoreObjective.func_199865_f() == ScoreCriteria.RenderType.HEARTS ? 0 : pingWidth);
    }

    @Inject(method={"drawPing(IIILnet/minecraft/client/network/play/NetworkPlayerInfo;)V"}, cancellable=true, at={@At(value="HEAD")})
    private void drawPing(int x1, int x2, int y, NetworkPlayerInfo playerInfo, CallbackInfo info) {
        boolean pingDelay = ExtendedConfig.INSTANCE.pingMode == PingMode.PING_AND_DELAY;
        FontRenderer fontRenderer = this.field_175250_f.field_71466_p;
        int ping = playerInfo.func_178853_c();
        if (((Boolean)IndicatiaConfig.GENERAL.enableCustomPlayerList.get()).booleanValue()) {
            TextFormatting color = TextFormatting.GREEN;
            String pingText = String.valueOf(ping);
            if (ping >= 200 && ping < 300) {
                color = TextFormatting.YELLOW;
            } else if (ping >= 300 && ping < 500) {
                color = TextFormatting.RED;
            } else if (ping >= 500) {
                color = TextFormatting.DARK_RED;
            }
            if (pingDelay) {
                pingText = String.valueOf(ping) + "/" + String.format("%.2f", Float.valueOf((float)ping / 1000.0f)) + "s";
                fontRenderer = ClientUtils.unicodeFontRenderer;
            }
            fontRenderer.func_175063_a(color + pingText, (float)(x1 + x2 - fontRenderer.func_78256_a(pingText)), (float)y + 0.625f, 0);
            info.cancel();
        }
    }
}

