/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.stevekungslib.utils;

import com.stevekung.stevekungslib.client.event.ClientEventHandler;
import com.stevekung.stevekungslib.core.SteveKunGLib;
import com.stevekung.stevekungslib.utils.client.ClientUtils;
import net.minecraft.util.text.TextFormatting;

public class ColorUtils {
    public static final int CUSTOM_COLOR_MARKER = 60160;

    public static int rgbToDecimal(int r, int g, int b) {
        return b + 256 * g + 65536 * r;
    }

    public static int hexToDecimal(String color) {
        return ColorUtils.rgbToDecimal(Integer.valueOf(color.substring(1, 3), 16), Integer.valueOf(color.substring(3, 5), 16), Integer.valueOf(color.substring(5, 7), 16));
    }

    public static RGB hexToRGB(String color) {
        return new RGB(Integer.valueOf(color.substring(1, 3), 16).intValue(), Integer.valueOf(color.substring(3, 5), 16).intValue(), Integer.valueOf(color.substring(5, 7), 16).intValue(), 255.0f);
    }

    public static float[] rgbToFloatArray(int r, int g, int b) {
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }

    public static int to32BitColor(int a, int r, int g, int b) {
        return (a <<= 24) | (r <<= 16) | (g <<= 8) | b;
    }

    public static RGB stringToRGB(String color) {
        return ColorUtils.stringToRGB(color, false, null);
    }

    public static RGB stringToRGBA(String color) {
        return ColorUtils.stringToRGBA(color, false, null);
    }

    public static RGB colorToRGB(int red, int green, int blue, int alpha) {
        return new RGB(red, green, blue, alpha);
    }

    public static RGB stringToRGB(String color, boolean printException, String optionName) {
        try {
            String[] colorArray = color.split(",");
            float red = Float.parseFloat(colorArray[0]);
            float green = Float.parseFloat(colorArray[1]);
            float blue = Float.parseFloat(colorArray[2]);
            return new RGB(red, green, blue, 255.0f);
        }
        catch (Exception e) {
            if (printException) {
                SteveKunGLib.LOGGER.error("Invalid RGB Color format at option {}!", optionName);
                ClientUtils.printClientMessage("Invalid RGB Color format at option " + optionName + "!", TextFormatting.RED);
                e.printStackTrace();
            }
            return new RGB(true);
        }
    }

    public static RGB stringToRGBA(String color, boolean printException, String optionName) {
        try {
            String[] colorArray = color.split(",");
            float red = Float.parseFloat(colorArray[0]);
            float green = Float.parseFloat(colorArray[1]);
            float blue = Float.parseFloat(colorArray[2]);
            float alpha = Float.parseFloat(colorArray[3]);
            return new RGB(red, green, blue, alpha);
        }
        catch (Exception e) {
            if (printException) {
                SteveKunGLib.LOGGER.error("Invalid RGB Color format at option {}!", optionName);
                ClientUtils.printClientMessage("Invalid RGB Color format at option " + optionName + "!", TextFormatting.RED);
                e.printStackTrace();
            }
            return new RGB(true);
        }
    }

    public static RGB toRGB(int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        return new RGB(red, green, blue, alpha);
    }

    public static boolean isMarker(char charac) {
        return charac >= '\ueb00' && charac <= '\uebff';
    }

    public static class RGB {
        float red;
        float green;
        float blue;
        float alpha;
        boolean error;

        public RGB(float red, float green, float blue, float alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        private RGB(boolean error) {
            this.error = error;
        }

        public int packedRed() {
            return (int)(this.red * 255.0f);
        }

        public int packedGreen() {
            return (int)(this.green * 255.0f);
        }

        public int packedBlue() {
            return (int)(this.blue * 255.0f);
        }

        public int packedAlpha() {
            return (int)(this.alpha * 255.0f);
        }

        public float floatRed() {
            return this.red / 255.0f;
        }

        public float floatGreen() {
            return this.green / 255.0f;
        }

        public float floatBlue() {
            return this.blue / 255.0f;
        }

        public float floatAlpha() {
            return this.alpha / 255.0f;
        }

        public int red() {
            return (int)this.red;
        }

        public int green() {
            return (int)this.green;
        }

        public int blue() {
            return (int)this.blue;
        }

        public int alpha() {
            return (int)this.alpha;
        }

        public String toColoredFont() {
            if (this.error) {
                if (ClientEventHandler.ticks % 16 >= 0 && ClientEventHandler.ticks % 16 <= 8) {
                    return this.formatColored(255, 85, 85);
                }
                return this.formatColored(255, 255, 255);
            }
            return this.formatColored(this.red(), this.green(), this.blue());
        }

        public int to32Bit() {
            return ColorUtils.to32BitColor(255, this.red(), this.green(), this.blue());
        }

        private String formatColored(int r, int g, int b) {
            return String.format("%c%c%c", Character.valueOf((char)(60160 + (r & 0xFF))), Character.valueOf((char)(60160 + (g & 0xFF))), Character.valueOf((char)(60160 + (b & 0xFF))));
        }
    }
}

