/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.stevekungslib.utils;

import com.stevekung.stevekungslib.utils.JsonUtils;
import java.util.Map;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.versions.mcp.MCPVersion;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class VersionChecker {
    private final Object mod;
    private final String modName;
    private final String url;
    private String latestVersion;
    private boolean failed;

    public VersionChecker(Object mod, String modName, String url) {
        this.mod = mod;
        this.modName = modName;
        this.url = url;
    }

    public void startCheck() {
        if (ModList.get().getModContainerByObject(this.mod).isPresent()) {
            return;
        }
        VersionChecker.CheckResult result = net.minecraftforge.fml.VersionChecker.getResult((IModInfo)((ModContainer)ModList.get().getModContainerByObject(this.mod).get()).getModInfo());
        for (Map.Entry entry : result.changes.entrySet()) {
            ComparableVersion version = (ComparableVersion)entry.getKey();
            if (result.status != VersionChecker.Status.OUTDATED) continue;
            this.latestVersion = version.toString();
        }
    }

    public void startCheckIfFailed() {
        if (ModList.get().getModContainerByObject(this.mod).isPresent()) {
            return;
        }
        VersionChecker.CheckResult result = net.minecraftforge.fml.VersionChecker.getResult((IModInfo)((ModContainer)ModList.get().getModContainerByObject(this.mod).get()).getModInfo());
        this.failed = result.status == VersionChecker.Status.FAILED || result.status == VersionChecker.Status.PENDING;
    }

    public void printInfo(ClientPlayerEntity player) {
        if (this.failed) {
            player.func_145747_a(JsonUtils.create("Unable to check latest version of " + this.formatText(TextFormatting.DARK_RED, this.modName) + "!, Please check your internet connection.").func_211709_a(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD}));
            return;
        }
        if (this.latestVersion != null) {
            String text = String.format("New version of %s is available %s for %s", this.formatText(TextFormatting.AQUA, this.modName), this.formatText(TextFormatting.GREEN, "v" + this.latestVersion), this.formatText(TextFormatting.BLUE, "Minecraft " + MCPVersion.getMCVersion()));
            player.func_145747_a((ITextComponent)JsonUtils.create(text));
            player.func_145747_a(JsonUtils.create("Download Link ").func_211708_a(TextFormatting.YELLOW).func_150257_a(JsonUtils.create("[CLICK HERE]").func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150209_a(JsonUtils.hover(HoverEvent.Action.SHOW_TEXT, JsonUtils.create("Click Here!").func_211708_a(TextFormatting.DARK_GREEN))).func_150241_a(JsonUtils.click(ClickEvent.Action.OPEN_URL, this.url)))));
        }
    }

    private String formatText(TextFormatting color, String text) {
        return color + text + TextFormatting.WHITE;
    }
}

