/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.stevekungslib.world.gen;

import java.util.BitSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;

public class CanyonWorldCarverBase
extends WorldCarver<ProbabilityConfig> {
    private final float[] field_202536_i = new float[1024];
    private final Set<Block> surfaceBlocks;
    private final Set<Block> subSurfaceBlocks;
    private final IFluidState lava;

    public CanyonWorldCarverBase(Set<Block> terrainBlocks, Set<Fluid> terrainFluids, Set<Block> surfaceBlocks, Set<Block> subSurfaceBlocks, IFluidState lava) {
        super(ProbabilityConfig::func_214645_a, 256);
        this.field_222718_j = terrainBlocks;
        this.field_222719_k = terrainFluids;
        this.surfaceBlocks = surfaceBlocks;
        this.subSurfaceBlocks = subSurfaceBlocks;
        this.lava = lava;
    }

    public boolean shouldCarve(Random rand, int chunkX, int chunkZ, ProbabilityConfig config) {
        return rand.nextFloat() <= config.field_203622_a;
    }

    public boolean carveRegion(IChunk chunk, Function<BlockPos, Biome> biomeGetter, Random rand, int seaLevel, int chunkX, int chunkZ, int originalX, int originalZ, BitSet carvingMask, ProbabilityConfig config) {
        int i = (this.func_222704_c() * 2 - 1) * 16;
        double d0 = chunkX * 16 + rand.nextInt(16);
        double d1 = rand.nextInt(rand.nextInt(40) + 8) + 20;
        double d2 = chunkZ * 16 + rand.nextInt(16);
        float f = rand.nextFloat() * ((float)Math.PI * 2);
        float f1 = (rand.nextFloat() - 0.5f) * 2.0f / 8.0f;
        float f2 = (rand.nextFloat() * 2.0f + rand.nextFloat()) * 2.0f;
        int j = i - rand.nextInt(i / 4);
        this.carveTunnel(chunk, biomeGetter, rand.nextLong(), seaLevel, originalX, originalZ, d0, d1, d2, f2, f, f1, 0, j, 3.0, carvingMask);
        return true;
    }

    protected boolean func_222708_a(double p_222708_1_, double p_222708_3_, double p_222708_5_, int p_222708_7_) {
        return (p_222708_1_ * p_222708_1_ + p_222708_5_ * p_222708_5_) * (double)this.field_202536_i[p_222708_7_ - 1] + p_222708_3_ * p_222708_3_ / 6.0 >= 1.0;
    }

    protected boolean func_225556_a_(IChunk chunk, Function<BlockPos, Biome> biomeGetter, BitSet carvingMask, Random rand, BlockPos.Mutable mutablePos1, BlockPos.Mutable mutablePos2, BlockPos.Mutable mutablePos3, int p_222703_7_, int p_222703_8_, int p_222703_9_, int x, int z, int p_222703_12_, int y, int p_222703_14_, AtomicBoolean atomicboolean) {
        int i = p_222703_12_ | p_222703_14_ << 4 | y << 8;
        if (carvingMask.get(i)) {
            return false;
        }
        carvingMask.set(i);
        mutablePos1.func_181079_c(x, y, z);
        BlockState blockstate = chunk.func_180495_p((BlockPos)mutablePos1);
        BlockState blockstate1 = chunk.func_180495_p((BlockPos)mutablePos2.func_189533_g((Vec3i)mutablePos1).func_189536_c(Direction.UP));
        if (this.surfaceBlocks.stream().anyMatch(block -> blockstate.func_177230_c() == block.getBlock())) {
            atomicboolean.set(true);
        }
        if (!this.func_222707_a(blockstate, blockstate1)) {
            return false;
        }
        if (y < 11) {
            chunk.func_177436_a((BlockPos)mutablePos1, this.lava.func_206883_i(), false);
        } else {
            chunk.func_177436_a((BlockPos)mutablePos1, field_222715_g, false);
            if (atomicboolean.get()) {
                mutablePos3.func_189533_g((Vec3i)mutablePos1).func_189536_c(Direction.DOWN);
                if (this.subSurfaceBlocks.stream().anyMatch(block -> chunk.func_180495_p((BlockPos)mutablePos3).func_177230_c() == block.getBlock())) {
                    chunk.func_177436_a((BlockPos)mutablePos3, biomeGetter.apply((BlockPos)mutablePos1).func_203944_q().func_204108_a(), false);
                }
            }
        }
        return true;
    }

    private void carveTunnel(IChunk chunk, Function<BlockPos, Biome> biomeGetter, long seed, int seaLevel, int originalX, int originalZ, double x, double y, double z, float radius, float p_222729_14_, float p_222729_15_, int p_222729_16_, int p_222729_17_, double p_222729_18_, BitSet bitSet) {
        Random rand = new Random(seed);
        float f = 1.0f;
        for (int i = 0; i < 256; ++i) {
            if (i == 0 || rand.nextInt(3) == 0) {
                f = 1.0f + rand.nextFloat() * rand.nextFloat();
            }
            this.field_202536_i[i] = f * f;
        }
        float f4 = 0.0f;
        float f1 = 0.0f;
        for (int j = p_222729_16_; j < p_222729_17_; ++j) {
            double d0 = 1.5 + (double)(MathHelper.func_76126_a((float)((float)j * (float)Math.PI / (float)p_222729_17_)) * radius);
            double d1 = d0 * p_222729_18_;
            d0 *= (double)rand.nextFloat() * 0.25 + 0.75;
            d1 *= (double)rand.nextFloat() * 0.25 + 0.75;
            float f2 = MathHelper.func_76134_b((float)p_222729_15_);
            float f3 = MathHelper.func_76126_a((float)p_222729_15_);
            x += (double)(MathHelper.func_76134_b((float)p_222729_14_) * f2);
            y += (double)f3;
            z += (double)(MathHelper.func_76126_a((float)p_222729_14_) * f2);
            p_222729_15_ *= 0.7f;
            p_222729_15_ += f1 * 0.05f;
            p_222729_14_ += f4 * 0.05f;
            f1 *= 0.8f;
            f4 *= 0.5f;
            f1 += (rand.nextFloat() - rand.nextFloat()) * rand.nextFloat() * 2.0f;
            f4 += (rand.nextFloat() - rand.nextFloat()) * rand.nextFloat() * 4.0f;
            if (rand.nextInt(4) == 0) continue;
            if (!this.func_222702_a(originalX, originalZ, x, z, j, p_222729_17_, radius)) {
                return;
            }
            this.func_227208_a_(chunk, biomeGetter, seed, seaLevel, originalX, originalZ, x, y, z, d0, d1, bitSet);
        }
    }
}

