/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile;

import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IGuiAddon;
import com.hrznstudio.titanium.api.client.IGuiAddonProvider;
import com.hrznstudio.titanium.api.filter.IFilter;
import com.hrznstudio.titanium.block.BlockRotation;
import com.hrznstudio.titanium.block.BlockTileBase;
import com.hrznstudio.titanium.block.tile.TileBase;
import com.hrznstudio.titanium.block.tile.button.MultiButtonHandler;
import com.hrznstudio.titanium.block.tile.button.PosButton;
import com.hrznstudio.titanium.block.tile.filter.MultiFilterHandler;
import com.hrznstudio.titanium.block.tile.fluid.MultiTankHandler;
import com.hrznstudio.titanium.block.tile.fluid.PosFluidTank;
import com.hrznstudio.titanium.block.tile.inventory.MultiInventoryHandler;
import com.hrznstudio.titanium.block.tile.inventory.PosInvHandler;
import com.hrznstudio.titanium.block.tile.progress.MultiProgressBarHandler;
import com.hrznstudio.titanium.block.tile.progress.PosProgressBar;
import com.hrznstudio.titanium.block.tile.sideness.IFacingHandler;
import com.hrznstudio.titanium.client.gui.asset.IAssetProvider;
import com.hrznstudio.titanium.container.impl.ContainerTileBase;
import com.hrznstudio.titanium.network.IButtonHandler;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileActive
extends TileBase
implements IGuiAddonProvider,
ITickableTileEntity,
INamedContainerProvider,
IButtonHandler {
    private MultiInventoryHandler multiInventoryHandler;
    private MultiProgressBarHandler multiProgressBarHandler;
    private MultiTankHandler multiTankHandler;
    private MultiButtonHandler multiButtonHandler;
    private MultiFilterHandler multiFilterHandler;
    private List<IFactory<? extends IGuiAddon>> guiAddons = new ArrayList<IFactory<? extends IGuiAddon>>();

    public TileActive(BlockTileBase base) {
        super(base);
    }

    @Override
    public boolean onActivated(PlayerEntity playerIn, Hand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (this.multiTankHandler != null) {
            return FluidUtil.interactWithFluidHandler((PlayerEntity)playerIn, (Hand)hand, (IFluidHandler)((IFluidHandler)this.multiTankHandler.getCapabilityForSide(null).orElse((Object)new MultiTankHandler.MultiTankCapabilityHandler(new ArrayList<PosFluidTank>()))));
        }
        return false;
    }

    @Override
    public void onNeighborChanged(Block blockIn, BlockPos fromPos) {
    }

    public void openGui(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            Titanium.openGui(this, (ServerPlayerEntity)player);
        }
    }

    @Nullable
    public Container createMenu(int menu, PlayerInventory inventoryPlayer, PlayerEntity entityPlayer) {
        return new ContainerTileBase(this, inventoryPlayer, menu);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getBlockTileBase().func_149739_a(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY));
    }

    public void addInventory(PosInvHandler handler) {
        if (this.multiInventoryHandler == null) {
            this.multiInventoryHandler = new MultiInventoryHandler();
        }
        this.multiInventoryHandler.add(handler.setTile(this));
    }

    public void addProgressBar(PosProgressBar posProgressBar) {
        if (this.multiProgressBarHandler == null) {
            this.multiProgressBarHandler = new MultiProgressBarHandler();
        }
        this.multiProgressBarHandler.addBar(posProgressBar.setTile(this));
    }

    public void addTank(PosFluidTank tank) {
        if (this.multiTankHandler == null) {
            this.multiTankHandler = new MultiTankHandler();
        }
        this.multiTankHandler.add(tank.setTile(this));
    }

    public void addButton(PosButton button) {
        if (this.multiButtonHandler == null) {
            this.multiButtonHandler = new MultiButtonHandler();
        }
        this.multiButtonHandler.addButton(button);
    }

    public void addFilter(IFilter filter) {
        if (this.multiFilterHandler == null) {
            this.multiFilterHandler = new MultiFilterHandler();
        }
        this.multiFilterHandler.add(filter);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.multiInventoryHandler != null) {
            return this.multiInventoryHandler.getCapabilityForSide(FacingUtil.getFacingRelative(this.getFacingDirection(), side)).cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.multiTankHandler != null) {
            return this.multiTankHandler.getCapabilityForSide(FacingUtil.getFacingRelative(this.getFacingDirection(), side)).cast();
        }
        return LazyOptional.empty();
    }

    public MultiInventoryHandler getMultiInventoryHandler() {
        return this.multiInventoryHandler;
    }

    public void addGuiAddonFactory(IFactory<? extends IGuiAddon> factory) {
        this.guiAddons.add(factory);
    }

    @Override
    public List<IFactory<? extends IGuiAddon>> getGuiAddons() {
        ArrayList<IFactory<? extends IGuiAddon>> addons = new ArrayList<IFactory<? extends IGuiAddon>>(this.guiAddons);
        if (this.multiInventoryHandler != null) {
            addons.addAll(this.multiInventoryHandler.getGuiAddons());
        }
        if (this.multiProgressBarHandler != null) {
            addons.addAll(this.multiProgressBarHandler.getGuiAddons());
        }
        if (this.multiTankHandler != null) {
            addons.addAll(this.multiTankHandler.getGuiAddons());
        }
        if (this.multiButtonHandler != null) {
            addons.addAll(this.multiButtonHandler.getGuiAddons());
        }
        if (this.multiFilterHandler != null) {
            addons.addAll(this.multiFilterHandler.getGuiAddons());
        }
        return addons;
    }

    public IAssetProvider getAssetProvider() {
        return IAssetProvider.DEFAULT_PROVIDER;
    }

    public void func_73660_a() {
        block6: {
            if (this.field_145850_b.field_72995_K) break block6;
            if (this.multiProgressBarHandler != null) {
                this.multiProgressBarHandler.update();
            }
            if (this.field_145850_b.func_82737_E() % (long)this.getFacingHandlerWorkTime() == 0L) {
                Iterator<IGuiAddonProvider> iterator;
                if (this.multiInventoryHandler != null) {
                    PosInvHandler inventoryHandler;
                    iterator = this.multiInventoryHandler.getInventoryHandlers().iterator();
                    while (!(!iterator.hasNext() || (inventoryHandler = (PosInvHandler)iterator.next()) instanceof IFacingHandler && ((IFacingHandler)((Object)inventoryHandler)).work(this.field_145850_b, this.field_174879_c, this.getFacingDirection(), this.getFacingHandlerWorkAmount()))) {
                    }
                }
                if (this.multiTankHandler != null) {
                    PosFluidTank tank;
                    iterator = this.multiTankHandler.getTanks().iterator();
                    while (!(!iterator.hasNext() || (tank = (PosFluidTank)iterator.next()) instanceof IFacingHandler && ((IFacingHandler)((Object)tank)).work(this.field_145850_b, this.field_174879_c, this.getFacingDirection(), this.getFacingHandlerWorkAmount()))) {
                    }
                }
            }
        }
    }

    public int getFacingHandlerWorkTime() {
        return 10;
    }

    public int getFacingHandlerWorkAmount() {
        return 4;
    }

    public MultiButtonHandler getMultiButtonHandler() {
        return this.multiButtonHandler;
    }

    public Direction getFacingDirection() {
        return this.field_145850_b.func_180495_p(this.field_174879_c).func_196959_b((IProperty)BlockRotation.FACING) ? (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockRotation.FACING) : Direction.NORTH;
    }

    public IFacingHandler getHandlerFromName(String string) {
        for (PosInvHandler handler : this.multiInventoryHandler.getInventoryHandlers()) {
            if (!(handler instanceof IFacingHandler) || !handler.getName().equalsIgnoreCase(string)) continue;
            return (IFacingHandler)((Object)handler);
        }
        for (PosFluidTank posFluidTank : this.multiTankHandler.getTanks()) {
            if (!(posFluidTank instanceof IFacingHandler) || !posFluidTank.getName().equalsIgnoreCase(string)) continue;
            return (IFacingHandler)((Object)posFluidTank);
        }
        return null;
    }

    @Override
    public void handleButtonMessage(int id, PlayerEntity playerEntity, CompoundNBT compound) {
        String name;
        if (id == -2) {
            name = compound.func_74779_i("Name");
            if (this.multiFilterHandler != null) {
                for (IFilter filter : this.multiFilterHandler.getFilters()) {
                    if (!filter.getName().equals(name)) continue;
                    int slot = compound.func_74762_e("Slot");
                    filter.setFilter(slot, ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Filter")));
                    this.markForUpdate();
                    break;
                }
            }
        }
        if (id == -1) {
            name = compound.func_74779_i("Name");
            FacingUtil.Sideness facing = FacingUtil.Sideness.valueOf(compound.func_74779_i("Facing"));
            IFacingHandler.FaceMode faceMode = IFacingHandler.FaceMode.values()[compound.func_74762_e("Next")];
            if (this.multiInventoryHandler != null && this.multiInventoryHandler.handleFacingChange(name, facing, faceMode)) {
                this.markForUpdate();
            } else if (this.multiTankHandler != null && this.multiTankHandler.handleFacingChange(name, facing, faceMode)) {
                this.markForUpdate();
            }
        } else if (this.multiButtonHandler != null) {
            this.multiButtonHandler.clickButton(id, playerEntity, compound);
        }
    }
}

