/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile.inventory;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IGuiAddon;
import com.hrznstudio.titanium.block.tile.inventory.PosInvHandler;
import com.hrznstudio.titanium.block.tile.sideness.IFacingHandler;
import com.hrznstudio.titanium.block.tile.sideness.SidedHandlerManager;
import com.hrznstudio.titanium.client.gui.addon.FacingHandlerGuiAddon;
import com.hrznstudio.titanium.util.FacingUtil;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class SidedInvHandler
extends PosInvHandler
implements IFacingHandler {
    private int color = DyeColor.WHITE.func_196060_f();
    private int facingHandlerX = 8;
    private int facingHandlerY = 84;
    private HashMap<FacingUtil.Sideness, IFacingHandler.FaceMode> facingModes = new HashMap();
    private HashMap<FacingUtil.Sideness, Integer> slotCache = new HashMap();
    private int position;
    private boolean colorGuiEnabled;
    private boolean hasFacingAddon;

    public SidedInvHandler(String name, int xPos, int yPos, int size, int position) {
        super(name, xPos, yPos, size);
        for (FacingUtil.Sideness value : FacingUtil.Sideness.values()) {
            this.facingModes.put(value, IFacingHandler.FaceMode.ENABLED);
        }
        this.position = position;
        this.colorGuiEnabled = true;
        this.hasFacingAddon = true;
    }

    public SidedInvHandler disableFacingAddon() {
        this.hasFacingAddon = false;
        return this;
    }

    @Override
    public HashMap<FacingUtil.Sideness, IFacingHandler.FaceMode> getFacingModes() {
        return this.facingModes;
    }

    @Override
    public int getColor() {
        return new Color(this.color).getRGB();
    }

    public SidedInvHandler setColor(int color) {
        this.color = color;
        return this;
    }

    public SidedInvHandler setColor(DyeColor color) {
        this.color = color.func_196060_f();
        return this;
    }

    public boolean isColorGuiEnabled() {
        return this.colorGuiEnabled;
    }

    public SidedInvHandler setColorGuiEnabled(boolean colorGuiEnabled) {
        this.colorGuiEnabled = colorGuiEnabled;
        return this;
    }

    @Override
    public Rectangle getRectangle(IAsset asset) {
        int renderingOffset = 1;
        Rectangle rectangle = new Rectangle((Integer)this.getSlotPosition().apply(0).getLeft() - 1, (Integer)this.getSlotPosition().apply(0).getRight() - 1, (int)asset.getArea().getWidth() + (Integer)this.getSlotPosition().apply(0).getLeft(), (int)asset.getArea().getHeight() + (Integer)this.getSlotPosition().apply(0).getRight());
        for (int i = 0; i < this.getSlots(); ++i) {
            if ((double)((Integer)this.getSlotPosition().apply(i).getLeft()).intValue() < rectangle.getX()) {
                rectangle.setLocation((Integer)this.getSlotPosition().apply(i).getLeft(), rectangle.y);
            }
            if ((double)((Integer)this.getSlotPosition().apply(i).getRight()).intValue() < rectangle.getY()) {
                rectangle.setLocation(rectangle.x, (Integer)this.getSlotPosition().apply(i).getRight());
            }
            if ((double)((Integer)this.getSlotPosition().apply(i).getLeft()).intValue() + asset.getArea().getWidth() > (double)rectangle.width) {
                rectangle.setSize((Integer)this.getSlotPosition().apply(i).getLeft() + asset.getArea().width, rectangle.height);
            }
            if (!((double)((Integer)this.getSlotPosition().apply(i).getRight()).intValue() + asset.getArea().getHeight() > (double)rectangle.height)) continue;
            rectangle.setSize(rectangle.width, (Integer)this.getSlotPosition().apply(i).getRight() + asset.getArea().height);
        }
        return new Rectangle(this.getXPos() - renderingOffset - 2 + rectangle.x, this.getYPos() - renderingOffset - 2 + rectangle.y, rectangle.width + renderingOffset * 2 + 3, rectangle.height + renderingOffset * 2 + 3);
    }

    @Override
    public int getFacingHandlerX() {
        return this.facingHandlerX;
    }

    @Override
    public int getFacingHandlerY() {
        return this.facingHandlerY;
    }

    @Override
    public boolean work(World world, BlockPos pos, Direction blockFacing, int workAmount) {
        AtomicBoolean hasWorked;
        TileEntity entity;
        Direction real;
        for (FacingUtil.Sideness sideness : this.facingModes.keySet()) {
            if (!this.facingModes.get((Object)sideness).equals((Object)IFacingHandler.FaceMode.PUSH)) continue;
            real = FacingUtil.getFacingFromSide(blockFacing, sideness);
            entity = world.func_175625_s(pos.func_177972_a(real));
            hasWorked = new AtomicBoolean(false);
            if (entity == null) continue;
            entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, real.func_176734_d()).ifPresent(iItemHandler -> hasWorked.set(this.transfer(sideness, (IItemHandler)this, (IItemHandler)iItemHandler, workAmount)));
            if (!hasWorked.get()) continue;
            return true;
        }
        for (FacingUtil.Sideness sideness : this.facingModes.keySet()) {
            if (!this.facingModes.get((Object)sideness).equals((Object)IFacingHandler.FaceMode.PULL)) continue;
            real = FacingUtil.getFacingFromSide(blockFacing, sideness);
            entity = world.func_175625_s(pos.func_177972_a(real));
            hasWorked = new AtomicBoolean(false);
            if (entity == null) continue;
            entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, real.func_176734_d()).ifPresent(iItemHandler -> hasWorked.set(this.transfer(sideness, (IItemHandler)iItemHandler, (IItemHandler)this, workAmount)));
            if (!hasWorked.get()) continue;
            return true;
        }
        return false;
    }

    @Override
    public SidedInvHandler setFacingHandlerPos(int x, int y) {
        this.facingHandlerX = x;
        this.facingHandlerY = y;
        return this;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        CompoundNBT compound = new CompoundNBT();
        for (FacingUtil.Sideness facing : this.facingModes.keySet()) {
            compound.func_74778_a(facing.name(), this.facingModes.get((Object)facing).name());
        }
        nbt.func_218657_a("FacingModes", (INBT)compound);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        if (nbt.func_74764_b("FacingModes")) {
            CompoundNBT compound = nbt.func_74775_l("FacingModes");
            for (String face : compound.func_150296_c()) {
                this.facingModes.put(FacingUtil.Sideness.valueOf(face), IFacingHandler.FaceMode.valueOf(compound.func_74779_i(face)));
            }
        }
    }

    @Override
    public List<IFactory<? extends IGuiAddon>> getGuiAddons() {
        List<IFactory<? extends IGuiAddon>> addons = super.getGuiAddons();
        if (this.hasFacingAddon) {
            addons.add(() -> new FacingHandlerGuiAddon(SidedHandlerManager.ofRight(this.getFacingHandlerX(), this.getFacingHandlerY(), this.position, AssetTypes.BUTTON_SIDENESS_MANAGER, 4), this, AssetTypes.SLOT));
        }
        return addons;
    }

    private int getNextSlot(IItemHandler handler, int currentSlot) {
        for (int i = currentSlot; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        return 0;
    }

    private boolean transfer(FacingUtil.Sideness sideness, IItemHandler from, IItemHandler to, int workAmount) {
        ItemStack extracted;
        if (from.getSlots() < 0) {
            return false;
        }
        int slot = this.slotCache.getOrDefault((Object)sideness, this.getNextSlot(from, 0));
        if (slot >= from.getSlots()) {
            slot = 0;
        }
        if (!(extracted = from.extractItem(slot, workAmount, true)).func_190926_b()) {
            ItemStack returned = ItemHandlerHelper.insertItemStacked((IItemHandler)to, (ItemStack)extracted, (boolean)false);
            return !from.extractItem(slot, extracted.func_190916_E() - returned.func_190916_E(), false).func_190926_b();
        }
        this.slotCache.put(sideness, this.getNextSlot(from, slot));
        return false;
    }
}

