/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile.progress;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IGuiAddon;
import com.hrznstudio.titanium.api.client.IGuiAddonProvider;
import com.hrznstudio.titanium.block.tile.TileBase;
import com.hrznstudio.titanium.client.gui.addon.ProgressBarGuiAddon;
import com.hrznstudio.titanium.client.gui.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;

public class PosProgressBar
implements INBTSerializable<CompoundNBT>,
IGuiAddonProvider {
    private int posX;
    private int posY;
    private int progress;
    private int maxProgress;
    private int progressIncrease;
    private Predicate<TileEntity> canIncrease;
    private Predicate<TileEntity> canReset;
    private int tickingTime;
    private Runnable onFinishWork;
    private Runnable onTickWork;
    private Runnable onStart;
    private TileBase tileBase;
    private BarDirection barDirection;
    private DyeColor color;
    private boolean increaseType;

    public PosProgressBar(int posX, int posY, int maxProgress) {
        this.posX = posX;
        this.posY = posY;
        this.progress = 0;
        this.maxProgress = maxProgress;
        this.progressIncrease = 1;
        this.canIncrease = tileEntity -> false;
        this.canReset = tileEntity -> true;
        this.tickingTime = 1;
        this.onFinishWork = () -> {};
        this.onTickWork = () -> {};
        this.onStart = () -> {};
        this.barDirection = BarDirection.VERTICAL_UP;
        this.color = DyeColor.WHITE;
        this.increaseType = true;
    }

    public PosProgressBar(int posX, int posY, int progress, int maxProgress) {
        this(posX, posY, maxProgress);
        this.progress = progress;
    }

    public PosProgressBar setOnFinishWork(Runnable runnable) {
        this.onFinishWork = runnable;
        return this;
    }

    public PosProgressBar setOnTickWork(Runnable runnable) {
        this.onTickWork = runnable;
        return this;
    }

    public PosProgressBar setOnStart(Runnable runnable) {
        this.onStart = runnable;
        return this;
    }

    public PosProgressBar setTile(TileBase tileBase) {
        this.tileBase = tileBase;
        return this;
    }

    public TileBase getTileBase() {
        return this.tileBase;
    }

    public Predicate<TileEntity> getCanReset() {
        return this.canReset;
    }

    public PosProgressBar setCanReset(Predicate<TileEntity> canReset) {
        this.canReset = canReset;
        return this;
    }

    public boolean getIncreaseType() {
        return this.increaseType;
    }

    public PosProgressBar setIncreaseType(boolean increaseType) {
        this.increaseType = increaseType;
        return this;
    }

    public void tickBar() {
        if (this.tileBase != null && this.tileBase.func_145831_w().func_82737_E() % (long)this.tickingTime == 0L) {
            if (this.increaseType && this.progress < this.maxProgress) {
                this.setProgress(this.progress + this.progressIncrease);
                this.onTickWork.run();
            }
            if (!this.increaseType && this.progress > 0) {
                this.setProgress(this.progress - this.progressIncrease);
                this.onTickWork.run();
            }
        }
        if (this.increaseType && this.progress >= this.maxProgress && this.canReset.test(this.tileBase)) {
            this.setProgress(0);
            this.onFinishWork.run();
        }
        if (!this.increaseType && this.progress <= 0 && this.canReset.test(this.tileBase)) {
            this.setProgress(this.maxProgress);
            this.onFinishWork.run();
        }
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public Predicate<TileEntity> getCanIncrease() {
        return this.canIncrease;
    }

    public PosProgressBar setCanIncrease(Predicate<TileEntity> canIncrease) {
        this.canIncrease = canIncrease;
        return this;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        if (this.tileBase != null) {
            this.tileBase.markForUpdate();
        }
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public PosProgressBar setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
        return this;
    }

    public int getTickingTime() {
        return this.tickingTime;
    }

    public PosProgressBar setTickingTime(int tickingTime) {
        this.tickingTime = tickingTime;
        return this;
    }

    public int getProgressIncrease() {
        return this.progressIncrease;
    }

    public PosProgressBar setProgressIncrease(int progressIncrease) {
        this.progressIncrease = progressIncrease;
        return this;
    }

    public BarDirection getBarDirection() {
        return this.barDirection;
    }

    public PosProgressBar setBarDirection(BarDirection direction) {
        this.barDirection = direction;
        return this;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public PosProgressBar setColor(DyeColor color) {
        this.color = color;
        return this;
    }

    @Override
    public List<IFactory<? extends IGuiAddon>> getGuiAddons() {
        return Collections.singletonList(() -> new ProgressBarGuiAddon(this.posX, this.posY, this));
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("Tick", this.progress);
        compound.func_74768_a("MaxProgress", this.maxProgress);
        return compound;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.progress = nbt.func_74762_e("Tick");
        this.maxProgress = nbt.func_74762_e("MaxProgress");
    }

    public void onStart() {
        this.onStart.run();
    }

    public static enum BarDirection {
        VERTICAL_UP{

            @Override
            public void render(Screen screen, int guiX, int guiY, IAssetProvider provider, ProgressBarGuiAddon addon) {
                IAsset assetBorder = IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_BORDER_VERTICAL);
                Point offset = assetBorder.getOffset();
                Rectangle area = assetBorder.getArea();
                screen.getMinecraft().func_110434_K().func_110577_a(assetBorder.getResourceLocation());
                screen.blit(guiX + addon.getPosX() + offset.x, guiY + addon.getPosY() + offset.y, area.x, area.y, area.width, area.height);
                GlStateManager.color4f((float)addon.getProgressBar().getColor().func_193349_f()[0], (float)addon.getProgressBar().getColor().func_193349_f()[1], (float)addon.getProgressBar().getColor().func_193349_f()[2], (float)1.0f);
                IAsset assetBar = IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_BACKGROUND_VERTICAL);
                offset = assetBar.getOffset();
                area = assetBar.getArea();
                screen.getMinecraft().func_110434_K().func_110577_a(assetBar.getResourceLocation());
                screen.blit(guiX + addon.getPosX() + offset.x, guiY + addon.getPosY() + offset.y, area.x, area.y, area.width, area.height);
                IAsset asset = IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_VERTICAL);
                offset = asset.getOffset();
                area = asset.getArea();
                screen.getMinecraft().func_110434_K().func_110577_a(asset.getResourceLocation());
                int progress = addon.getProgressBar().getProgress();
                int maxProgress = addon.getProgressBar().getMaxProgress();
                int progressOffset = progress * area.height / maxProgress;
                screen.blit(addon.getPosX() + offset.x + guiX, addon.getPosY() + offset.y + area.height - progressOffset + guiY, area.x, area.y + (area.height - progressOffset), area.width, progressOffset);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }

            @Override
            public int getXSize(IAssetProvider provider) {
                return (int)IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_BORDER_VERTICAL).getArea().getWidth();
            }

            @Override
            public int getYSize(IAssetProvider provider) {
                return (int)IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_BORDER_VERTICAL).getArea().getHeight();
            }
        }
        ,
        HORIZONTAL_RIGHT{

            @Override
            public void render(Screen screen, int guiX, int guiY, IAssetProvider provider, ProgressBarGuiAddon addon) {
                AssetUtil.drawAsset(screen, IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_BACKGROUND_HORIZONTAL), addon.getPosX() + guiX, addon.getPosY() + guiY);
                IAsset asset = IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_HORIZONTAL);
                Point offset = asset.getOffset();
                Rectangle area = asset.getArea();
                screen.getMinecraft().func_110434_K().func_110577_a(asset.getResourceLocation());
                int progress = addon.getProgressBar().getProgress();
                int maxProgress = addon.getProgressBar().getMaxProgress();
                int progressOffset = progress * area.width / maxProgress;
                GlStateManager.color4f((float)addon.getProgressBar().getColor().func_193349_f()[0], (float)addon.getProgressBar().getColor().func_193349_f()[1], (float)addon.getProgressBar().getColor().func_193349_f()[2], (float)1.0f);
                screen.blit(addon.getPosX() + offset.x + guiX, addon.getPosY() + offset.y + guiY, area.x, area.y, progressOffset, area.height);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }

            @Override
            public int getXSize(IAssetProvider provider) {
                return (int)IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_BACKGROUND_HORIZONTAL).getArea().getWidth();
            }

            @Override
            public int getYSize(IAssetProvider provider) {
                return (int)IAssetProvider.getAsset(provider, AssetTypes.PROGRESS_BAR_BACKGROUND_HORIZONTAL).getArea().getHeight();
            }
        };


        @OnlyIn(value=Dist.CLIENT)
        public abstract void render(Screen var1, int var2, int var3, IAssetProvider var4, ProgressBarGuiAddon var5);

        @OnlyIn(value=Dist.CLIENT)
        public abstract int getXSize(IAssetProvider var1);

        @OnlyIn(value=Dist.CLIENT)
        public abstract int getYSize(IAssetProvider var1);
    }
}

