/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.gui.addon;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.block.tile.button.ArrowButton;
import com.hrznstudio.titanium.client.gui.addon.BasicButtonAddon;
import com.hrznstudio.titanium.client.gui.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.hrznstudio.titanium.util.FacingUtil;
import net.minecraft.client.gui.screen.Screen;

public class ArrowButtonGuiAddon
extends BasicButtonAddon {
    private ArrowButton button;
    private IAsset asset;

    public ArrowButtonGuiAddon(ArrowButton button) {
        super(button);
        this.button = button;
    }

    @Override
    public int getXSize() {
        return this.asset != null ? this.asset.getArea().width : 0;
    }

    @Override
    public int getYSize() {
        return this.asset != null ? this.asset.getArea().height : 0;
    }

    @Override
    public void drawGuiContainerBackgroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.asset = provider.getAsset(this.getAssetFromSideness(this.button.getDirection()));
        AssetUtil.drawAsset(screen, this.asset, guiX + this.getPosX(), guiY + this.getPosY());
    }

    @Override
    public void drawGuiContainerForegroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
    }

    public IAssetType getAssetFromSideness(FacingUtil.Sideness sideness) {
        switch (sideness) {
            case LEFT: {
                return AssetTypes.BUTTON_ARROW_LEFT;
            }
            case RIGHT: {
                return AssetTypes.BUTTON_ARROW_RIGHT;
            }
            case BOTTOM: {
                return AssetTypes.BUTTON_ARROW_DOWN;
            }
        }
        return AssetTypes.BUTTON_ARROW_UP;
    }
}

