/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.gui.addon;

import com.hrznstudio.titanium.block.tile.progress.PosProgressBar;
import com.hrznstudio.titanium.client.gui.addon.BasicGuiAddon;
import com.hrznstudio.titanium.client.gui.asset.IAssetProvider;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.TextFormatting;

public class ProgressBarGuiAddon
extends BasicGuiAddon {
    private PosProgressBar progressBar;
    private IAssetProvider provider;

    public ProgressBarGuiAddon(int posX, int posY, PosProgressBar posProgressBar) {
        super(posX, posY);
        this.progressBar = posProgressBar;
    }

    @Override
    public int getXSize() {
        return this.provider != null ? this.progressBar.getBarDirection().getXSize(this.provider) : 0;
    }

    @Override
    public int getYSize() {
        return this.provider != null ? this.progressBar.getBarDirection().getYSize(this.provider) : 0;
    }

    @Override
    public void drawGuiContainerBackgroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.provider = provider;
        this.progressBar.getBarDirection().render(screen, guiX, guiY, provider, this);
    }

    @Override
    public void drawGuiContainerForegroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
    }

    public PosProgressBar getProgressBar() {
        return this.progressBar;
    }

    @Override
    public List<String> getTooltipLines() {
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add(TextFormatting.GOLD + "Progress: " + TextFormatting.WHITE + new DecimalFormat().format(this.progressBar.getProgress()) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + new DecimalFormat().format(this.progressBar.getMaxProgress()));
        int progress = (this.progressBar.getMaxProgress() - this.progressBar.getProgress()) / this.progressBar.getProgressIncrease();
        if (!this.progressBar.getIncreaseType()) {
            progress = this.progressBar.getMaxProgress() - progress;
        }
        tooltip.add(TextFormatting.GOLD + "ETA: " + TextFormatting.WHITE + new DecimalFormat().format(Math.ceil((double)(progress * this.progressBar.getTickingTime()) / 20.0)) + TextFormatting.DARK_AQUA + "s");
        return tooltip;
    }
}

