/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.container.impl;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.block.tile.TileActive;
import com.hrznstudio.titanium.block.tile.inventory.PosInvHandler;
import com.hrznstudio.titanium.client.gui.asset.IAssetProvider;
import com.hrznstudio.titanium.container.impl.ContainerInventoryBase;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.TileEntityLocatorInstance;
import java.awt.Point;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.registries.ObjectHolder;

public class ContainerTileBase
extends ContainerInventoryBase
implements ILocatable {
    @ObjectHolder(value="titanium:tile_container")
    public static ContainerType<ContainerTileBase> TYPE;
    private TileActive tile;
    private boolean hasPlayerInventory;

    public ContainerTileBase(int id, PlayerInventory player, PacketBuffer buffer) {
        this((TileActive)player.field_70458_d.func_130014_f_().func_175625_s(buffer.func_179259_c()), player, id);
    }

    public ContainerTileBase(TileActive tile, PlayerInventory inventory, int id) {
        super(TYPE, inventory, id, tile.getAssetProvider());
        this.tile = tile;
        this.addTileSlots();
        this.addHotbarSlots(IAssetProvider.getAsset(tile.getAssetProvider(), AssetTypes.BACKGROUND).getHotbarPosition());
    }

    public void addHotbarSlots(Point hotbarPos) {
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)this.getPlayerInventory(), k, hotbarPos.x + k * 18, hotbarPos.y));
        }
    }

    public void addTileSlots() {
        if (this.tile.getMultiInventoryHandler() != null) {
            for (PosInvHandler handler : this.tile.getMultiInventoryHandler().getInventoryHandlers()) {
                int i = 0;
                for (int y = 0; y < handler.getYSize(); ++y) {
                    for (int x = 0; x < handler.getXSize(); ++x) {
                        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)handler, i, handler.getXPos() + (Integer)handler.getSlotPosition().apply(i).getLeft(), handler.getYPos() + (Integer)handler.getSlotPosition().apply(i).getRight()));
                        ++i;
                    }
                }
            }
        }
    }

    public void updateSlotPosition() {
        if (this.tile.getMultiInventoryHandler() != null) {
            for (PosInvHandler handler : this.tile.getMultiInventoryHandler().getInventoryHandlers()) {
                int i = 0;
                for (int y = 0; y < handler.getYSize(); ++y) {
                    for (int x = 0; x < handler.getXSize(); ++x) {
                        for (Slot inventorySlot : this.field_75151_b) {
                            if (!(inventorySlot instanceof SlotItemHandler) || !((SlotItemHandler)inventorySlot).getItemHandler().equals(handler) || i != inventorySlot.getSlotIndex()) continue;
                            inventorySlot.field_75223_e = handler.getXPos() + (Integer)handler.getSlotPosition().apply(i).getLeft();
                            inventorySlot.field_75221_f = handler.getYPos() + (Integer)handler.getSlotPosition().apply(i).getRight();
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    @Override
    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public TileActive getTile() {
        return this.tile;
    }

    @Override
    public LocatorInstance getLocatorInstance() {
        return new TileEntityLocatorInstance(this.tile.func_174877_v());
    }
}

