/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.material;

import com.google.common.collect.HashMultimap;
import com.hrznstudio.titanium.annotation.MaterialReference;
import com.hrznstudio.titanium.api.material.IHasColor;
import com.hrznstudio.titanium.api.material.IResourceType;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.material.ResourceMaterial;
import com.hrznstudio.titanium.material.ResourceType;
import com.hrznstudio.titanium.material.ResourceTypeProperties;
import com.hrznstudio.titanium.module.ModuleController;
import com.hrznstudio.titanium.tab.AdvancedTitaniumTab;
import com.hrznstudio.titanium.util.AnnotationUtil;
import com.hrznstudio.titanium.util.SidedHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceRegistry {
    public static AdvancedTitaniumTab RESOURCES = new AdvancedTitaniumTab("resources", true);
    public static Logger LOGGER = LogManager.getLogger((String)"titanium-ResourceRegistry");
    private static HashMap<String, ResourceMaterial> MATERIALS = new HashMap();
    private static HashMap<String, HashMultimap<String, Field>> ANNOTATED_FIELDS = new HashMap();
    private static Field modifiersField;

    public static void onPreInit() {
        ResourceRegistry.scanForReferences();
        ResourceTypeProperties.DEFAULTS.put(Block.class, new ResourceTypeProperties<Block.Properties>(Block.Properties.func_200950_a((Block)Blocks.field_150366_p)));
        ResourceTypeProperties.DEFAULTS.put(Item.class, new ResourceTypeProperties<Item.Properties>(new Item.Properties().func_200916_a((ItemGroup)RESOURCES)));
        ResourceRegistry.getOrCreate("iron").setColor(0xD8D8D8).withOverride(ResourceType.ORE, (ForgeRegistryEntry)Blocks.field_150366_p).withOverride(ResourceType.METAL_BLOCK, (ForgeRegistryEntry)Blocks.field_150339_S).withOverride(ResourceType.INGOT, (ForgeRegistryEntry)Items.field_151042_j).withOverride(ResourceType.NUGGET, (ForgeRegistryEntry)Items.field_191525_da);
        ResourceRegistry.getOrCreate("gold").setColor(16438858).withOverride(ResourceType.ORE, (ForgeRegistryEntry)Blocks.field_150352_o).withOverride(ResourceType.METAL_BLOCK, (ForgeRegistryEntry)Blocks.field_150340_R).withOverride(ResourceType.INGOT, (ForgeRegistryEntry)Items.field_151043_k).withOverride(ResourceType.NUGGET, (ForgeRegistryEntry)Items.field_151074_bl);
        ResourceRegistry.getOrCreate("coal").setColor(0x363636).withOverride(ResourceType.ORE, (ForgeRegistryEntry)Blocks.field_150365_q).withOverride(ResourceType.GEM_BLOCK, (ForgeRegistryEntry)Blocks.field_150402_ci).withOverride(ResourceType.GEM, (ForgeRegistryEntry)Items.field_151044_h);
        ResourceRegistry.getOrCreate("lapis_lazuli").setColor(3432131).withOverride(ResourceType.ORE, (ForgeRegistryEntry)Blocks.field_150369_x).withOverride(ResourceType.GEM_BLOCK, (ForgeRegistryEntry)Blocks.field_150368_y).withOverride(ResourceType.GEM, (ForgeRegistryEntry)Items.field_196128_bn);
        ResourceRegistry.getOrCreate("diamond").setColor(4910553).withOverride(ResourceType.ORE, (ForgeRegistryEntry)Blocks.field_150482_ag).withOverride(ResourceType.GEM_BLOCK, (ForgeRegistryEntry)Blocks.field_150484_ah).withOverride(ResourceType.GEM, (ForgeRegistryEntry)Items.field_151045_i);
        ResourceRegistry.getOrCreate("redstone").setColor(11144961).withOverride(ResourceType.ORE, (ForgeRegistryEntry)Blocks.field_150450_ax).withOverride(ResourceType.GEM_BLOCK, (ForgeRegistryEntry)Blocks.field_150451_bX).withOverride(ResourceType.DUST, (ForgeRegistryEntry)Items.field_151137_ax);
        ResourceRegistry.getOrCreate("emerald").setColor(1564002).withOverride(ResourceType.ORE, (ForgeRegistryEntry)Blocks.field_150412_bA).withOverride(ResourceType.GEM_BLOCK, (ForgeRegistryEntry)Blocks.field_150475_bE).withOverride(ResourceType.GEM, (ForgeRegistryEntry)Items.field_151166_bC);
        ResourceRegistry.getOrCreate("nether_quartz").setColor(14537926).withOverride(ResourceType.NETHER_ORE, (ForgeRegistryEntry)Blocks.field_196766_fg).withOverride(ResourceType.GEM_BLOCK, (ForgeRegistryEntry)Blocks.field_150371_ca).withOverride(ResourceType.GEM, (ForgeRegistryEntry)Items.field_151128_bU);
        ResourceRegistry.getOrCreate("glowstone").setColor(16759902).withOverride(ResourceType.GEM_BLOCK, (ForgeRegistryEntry)Blocks.field_150426_aN).withOverride(ResourceType.DUST, (ForgeRegistryEntry)Items.field_151114_aO);
        SidedHandler.runOn(Dist.CLIENT, () -> () -> EventManager.mod(ColorHandlerEvent.Item.class).process(item -> ResourceRegistry.getMaterials().forEach(material -> material.getGenerated().values().stream().filter(entry -> entry instanceof IHasColor).forEach(entry -> {
            if (entry instanceof Block) {
                item.getBlockColors().func_186722_a((state, world, pos, tint) -> ((IHasColor)entry).getColor(tint), new Block[]{(Block)entry});
            } else if (entry instanceof Item) {
                item.getItemColors().func_199877_a((stack, tint) -> ((IHasColor)entry).getColor(tint), new IItemProvider[]{(IItemProvider)entry});
            }
        }))).subscribe());
        EventManager.mod(RegistryEvent.Register.class).process(event -> MATERIALS.values().stream().forEach(material -> material.getGenerated().values().stream().filter(entry -> entry.getRegistryName().func_110624_b().equals("titanium") && ((Class)event.getGenericType()).isAssignableFrom(entry.getRegistryType())).forEach(entry -> event.getRegistry().register((IForgeRegistryEntry)entry)))).subscribe();
    }

    private static void scanForReferences() {
        if (modifiersField == null) {
            try {
                modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                LOGGER.error((Object)e);
            }
        }
        for (Field annotatedField : AnnotationUtil.getAnnotatedFields(MaterialReference.class)) {
            if (!Modifier.isStatic(annotatedField.getModifiers())) continue;
            MaterialReference reference = annotatedField.getAnnotation(MaterialReference.class);
            if (!annotatedField.isAccessible()) {
                annotatedField.setAccessible(true);
            }
            if (Modifier.isFinal(annotatedField.getModifiers())) {
                try {
                    modifiersField.setInt(annotatedField, annotatedField.getModifiers() & 0xFFFFFFEF);
                }
                catch (IllegalAccessException e) {
                    LOGGER.error((Object)e);
                }
            }
            ANNOTATED_FIELDS.computeIfAbsent(reference.material(), s -> HashMultimap.create()).put((Object)reference.type(), (Object)annotatedField);
        }
    }

    public static void initModules(ModuleController controller) {
    }

    public static void onPostInit() {
        ResourceRegistry.getMaterials().forEach(material -> {
            if (material.getGeneratorTypes().size() > 0) {
                material.getGeneratorTypes().values().forEach(type -> {
                    ForgeRegistryEntry entry = material.generate((IResourceType)type);
                });
            }
        });
        ResourceRegistry.getMaterials().stream().map(material -> material.getGenerated().values()).flatMap(Collection::stream).filter(forgeRegistryEntry -> forgeRegistryEntry instanceof IItemProvider && ForgeRegistries.ITEMS.containsKey(forgeRegistryEntry.getRegistryName())).forEach(forgeRegistryEntry -> RESOURCES.addIconStack(new ItemStack((IItemProvider)((IItemProvider)forgeRegistryEntry).func_199767_j())));
    }

    public static ResourceMaterial getOrCreate(String type) {
        return MATERIALS.computeIfAbsent(type, s -> new ResourceMaterial(type));
    }

    public static Collection<ResourceMaterial> getMaterials() {
        return MATERIALS.values();
    }

    public static void injectField(ResourceMaterial material, IResourceType type, ForgeRegistryEntry entry) {
        HashMultimap<String, Field> multimap;
        if (ANNOTATED_FIELDS.containsKey(material.getMaterialType()) && (multimap = ANNOTATED_FIELDS.get(material.getMaterialType())).containsKey((Object)type.func_176610_l())) {
            multimap.get((Object)type.func_176610_l()).stream().filter(field -> entry.getRegistryType().isAssignableFrom(field.getType())).forEach(field -> {
                try {
                    field.set(null, entry);
                }
                catch (IllegalAccessException e) {
                    LOGGER.error((Object)e);
                }
            });
        }
    }
}

