/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.material;

import com.google.gson.JsonObject;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.material.IHasColor;
import com.hrznstudio.titanium.api.material.IResourceHolder;
import com.hrznstudio.titanium.api.material.IResourceType;
import com.hrznstudio.titanium.block.BlockBase;
import com.hrznstudio.titanium.material.IAdvancedResourceType;
import com.hrznstudio.titanium.material.ResourceMaterial;
import com.hrznstudio.titanium.material.ResourceRegistry;
import com.hrznstudio.titanium.material.ResourceTypeProperties;
import com.hrznstudio.titanium.recipe.generator.IJSONGenerator;
import com.hrznstudio.titanium.recipe.generator.IJsonFile;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class ResourceTypeBlock
extends BlockBase
implements IJsonFile,
IJSONGenerator,
IResourceHolder,
IHasColor {
    private final ResourceMaterial resourceMaterial;
    private final IResourceType resourceType;
    private final IAdvancedResourceType blockResourceType;

    public ResourceTypeBlock(ResourceMaterial material, IResourceType type, IAdvancedResourceType blockType, ResourceTypeProperties<Block.Properties> properties) {
        super(material.getMaterialType() + "_" + type.func_176610_l(), properties == null ? (Block.Properties)ResourceTypeProperties.DEFAULTS.get(Block.class).get() : properties.get());
        this.resourceMaterial = material;
        this.resourceType = type;
        this.blockResourceType = blockType;
        this.setItemGroup(ResourceRegistry.RESOURCES);
    }

    @Override
    public int getColor(int tintIndex) {
        return this.blockResourceType.getColor(this.resourceMaterial, tintIndex);
    }

    @Override
    public ResourceMaterial getMaterial() {
        return this.resourceMaterial;
    }

    @Override
    public IResourceType getType() {
        return this.resourceType;
    }

    @Override
    public JsonObject generate() {
        return this.blockResourceType.generate(this.resourceType);
    }

    @Override
    public String getRecipeKey() {
        return this.getRegistryName().func_110623_a();
    }

    @Override
    @Nullable
    public String getRecipeSubfolder() {
        return "assets/titanium/models/block/";
    }

    @Override
    public IFactory<BlockItem> getItemBlockFactory() {
        return () -> (BlockItem)new BlockItem(this, new Item.Properties().func_200916_a(this.getItemGroup())){

            public ITextComponent func_200295_i(ItemStack p_200295_1_) {
                return ResourceTypeBlock.this.resourceType.getTextComponent(ResourceTypeBlock.this.resourceMaterial.getTextComponent());
            }
        }.setRegistryName(Objects.requireNonNull(this.getRegistryName()));
    }
}

