/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.recipe.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hrznstudio.titanium.block.BlockBase;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockItemModelGeneratorProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogManager.getLogger();
    private final DataGenerator generator;
    private final String modid;

    public BlockItemModelGeneratorProvider(DataGenerator generator, String modid) {
        this.generator = generator;
        this.modid = modid;
    }

    private static JsonObject createModel(Block block) {
        JsonObject object = new JsonObject();
        object.addProperty("parent", block.getRegistryName().func_110624_b() + ":block/" + block.getRegistryName().func_110623_a());
        return object;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        Path output = path.resolve("assets/" + this.modid + "/models/item/");
        Files.createDirectories(output, new FileAttribute[0]);
        BlockBase.BLOCKS.stream().filter(blockBase -> blockBase.getRegistryName().func_110624_b().equals(this.modid)).forEach(blockBase -> {
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(output.resolve(blockBase.getRegistryName().func_110623_a() + ".json"), new OpenOption[0]);){
                bufferedwriter.write(GSON.toJson((JsonElement)BlockItemModelGeneratorProvider.createModel(blockBase)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public String func_200397_b() {
        return "Block Model Item Generator (" + this.modid + ")";
    }
}

