/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.registry.IFRegistries;
import com.buuz135.industrial.utils.BlockUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BlockTileBase;
import com.hrznstudio.titanium.block.tile.fluid.PosFluidTank;
import com.hrznstudio.titanium.block.tile.fluid.SidedFluidTank;
import com.hrznstudio.titanium.block.tile.inventory.PosInvHandler;
import com.hrznstudio.titanium.block.tile.inventory.SidedInvHandler;
import java.util.List;
import java.util.Optional;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PlantGathererTile
extends IndustrialAreaWorkingTile {
    @Save
    private SidedInvHandler output = (SidedInvHandler)new SidedInvHandler("output", 70, 22, 15, 0).setColor(DyeColor.ORANGE).setRange(5, 3).setTile((TileEntity)this);
    @Save
    private SidedFluidTank tank;

    public PlantGathererTile() {
        super((BlockTileBase)ModuleAgricultureHusbandry.PLANT_GATHERER, RangeManager.RangeType.BEHIND);
        this.addInventory((PosInvHandler)this.output);
        this.tank = (SidedFluidTank)new SidedFluidTank("sludge", 8000, 45, 20, 1).setColor(DyeColor.MAGENTA).setTile((TileEntity)this);
        this.addTank((PosFluidTank)this.tank);
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.hasEnergy(400)) {
            int amount = Math.max(1, BlockUtils.getBlockPosInAABB(this.getWorkingArea().func_197752_a()).size() / 4);
            for (int i = 0; i < amount; ++i) {
                Optional<PlantRecollectable> optional;
                if (this.isLoaded(this.getPointedBlockPos()) && (optional = IFRegistries.PLANT_RECOLLECTABLES_REGISTRY.getValues().stream().filter(plantRecollectable -> plantRecollectable.canBeHarvested(this.field_145850_b, this.getPointedBlockPos(), this.field_145850_b.func_180495_p(this.getPointedBlockPos()))).findFirst()).isPresent()) {
                    List<ItemStack> drops = optional.get().doHarvestOperation(this.field_145850_b, this.getPointedBlockPos(), this.field_145850_b.func_180495_p(this.getPointedBlockPos()));
                    this.tank.fill(new FluidStack((Fluid)ModuleCore.SLUDGE.getSourceFluid(), 10 * drops.size()), IFluidHandler.FluidAction.EXECUTE);
                    drops.forEach(stack -> ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)stack, (boolean)false));
                    if (optional.get().shouldCheckNextPlant(this.field_145850_b, this.getPointedBlockPos(), this.field_145850_b.func_180495_p(this.getPointedBlockPos()))) {
                        this.increasePointer();
                    }
                    return new IndustrialWorkingTile.WorkAction(this, 0.3f, 400);
                }
                this.increasePointer();
            }
        }
        this.increasePointer();
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    @Override
    public int getMaxProgress() {
        return 40;
    }
}

