/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.item.RangeAddonItem;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.augment.IAugment;
import com.hrznstudio.titanium.api.filter.FilterSlot;
import com.hrznstudio.titanium.api.filter.IFilter;
import com.hrznstudio.titanium.block.BlockTileBase;
import com.hrznstudio.titanium.block.tile.inventory.PosInvHandler;
import com.hrznstudio.titanium.block.tile.inventory.SidedInvHandler;
import com.hrznstudio.titanium.filter.ItemstackFilter;
import net.minecraft.block.BushBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.IPlantable;

public class PlantSowerTile
extends IndustrialAreaWorkingTile {
    public static DyeColor[] COLORS = new DyeColor[]{DyeColor.RED, DyeColor.YELLOW, DyeColor.LIME, DyeColor.CYAN, DyeColor.WHITE, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.BLACK};
    @Save
    private ItemstackFilter filter = new ItemstackFilter("filter", 9){

        public void onContentChanged() {
            super.onContentChanged();
            PlantSowerTile.this.markForUpdate();
        }
    };
    @Save
    private SidedInvHandler input;

    public PlantSowerTile() {
        super((BlockTileBase)ModuleAgricultureHusbandry.PLANT_SOWER, RangeManager.RangeType.TOP_UP);
        this.addFilter((IFilter)this.filter);
        int pos = 0;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                FilterSlot slot = new FilterSlot(45 + x * 18, 21 + y * 18, pos, (Object)ItemStack.field_190927_a);
                slot.setColor(COLORS[pos]);
                this.filter.setFilter(pos, slot);
                ++pos;
            }
        }
        this.input = (SidedInvHandler)new SidedInvHandler("input", 108, 22, 9, 0).setColor(DyeColor.CYAN).setInputFilter((itemStack, integer) -> itemStack.func_77973_b() instanceof BlockItem && ((BlockItem)itemStack.func_77973_b()).func_179223_d() instanceof IPlantable).setRange(3, 3).setTile((TileEntity)this);
        this.addInventory((PosInvHandler)this.input);
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        BlockPos pos = this.getPointedBlockPos();
        if (this.isLoaded(pos) && this.field_145850_b.func_175623_d(pos) && this.hasEnergy(1000)) {
            BushBlock block;
            int slot = this.getFilteredSlot(pos);
            ItemStack stack = ItemStack.field_190927_a;
            for (int i = 0; i < this.input.getSlots(); ++i) {
                if (this.input.getStackInSlot(i).func_190926_b() || !((ItemStack)this.filter.getFilterSlots()[slot].getFilter()).func_190926_b() && !((ItemStack)this.filter.getFilterSlots()[slot].getFilter()).func_77969_a(this.input.getStackInSlot(i))) continue;
                stack = this.input.getStackInSlot(i);
                break;
            }
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() instanceof BushBlock && (block = (BushBlock)((BlockItem)stack.func_77973_b()).func_179223_d()).func_196260_a(this.field_145850_b.func_180495_p(pos), (IWorldReader)this.field_145850_b, pos) && this.field_145850_b.func_175656_a(pos, block.getPlant((IBlockReader)this.field_145850_b, pos))) {
                stack.func_190918_g(1);
                this.increasePointer();
                return new IndustrialWorkingTile.WorkAction(this, 0.2f, 1000);
            }
        }
        this.increasePointer();
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    private int getFilteredSlot(BlockPos pos) {
        int radius;
        int n = radius = this.hasAugmentInstalled(RangeAddonItem.RANGE) ? (int)((IAugment)this.getInstalledAugments(RangeAddonItem.RANGE).get(0)).getAugmentRatio() + 1 : 0;
        if (radius == 0) {
            for (int i = 0; i < this.input.getSlots(); ++i) {
                if (this.input.getStackInSlot(i).func_190926_b()) continue;
                return i;
            }
        }
        int x = Math.round(1.49f * (float)(pos.func_177958_n() - this.field_174879_c.func_177958_n()) / (float)radius);
        int z = Math.round(1.49f * (float)(pos.func_177952_p() - this.field_174879_c.func_177952_p()) / (float)radius);
        return 4 + x + 3 * z;
    }

    @Override
    public int getMaxProgress() {
        return 40;
    }
}

