/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.core.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BlockTileBase;
import com.hrznstudio.titanium.block.tile.fluid.PosFluidTank;
import com.hrznstudio.titanium.block.tile.fluid.SidedFluidTank;
import com.hrznstudio.titanium.block.tile.inventory.PosInvHandler;
import com.hrznstudio.titanium.block.tile.inventory.SidedInvHandler;
import com.hrznstudio.titanium.util.RecipeUtil;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class DissolutionChamberTile
extends IndustrialProcessingTile {
    @Save
    private SidedInvHandler input;
    @Save
    private SidedFluidTank inputFluid;
    @Save
    private SidedInvHandler output;
    @Save
    private SidedFluidTank outputFluid;
    private DissolutionChamberRecipe currentRecipe;

    public DissolutionChamberTile() {
        super((BlockTileBase)ModuleCore.DISSOLUTION_CHAMBER, 102, 41);
        int slotSpacing = 22;
        this.input = (SidedInvHandler)new SidedInvHandler("input", 34, 19, 8, 0).setColor(DyeColor.LIGHT_BLUE).setSlotPosition(integer -> DissolutionChamberTile.getSlotPos(integer)).setSlotLimit(1).setTile((TileEntity)this).setOnSlotChanged((stack, integer) -> this.checkForRecipe());
        this.addInventory((PosInvHandler)this.input);
        this.inputFluid = (SidedFluidTank)new SidedFluidTank("input_fluid", 8000, 33 + slotSpacing, 18 + slotSpacing, 1).setColor(DyeColor.LIME).setTankType(PosFluidTank.Type.SMALL).setTile((TileEntity)this).setTankAction(PosFluidTank.Action.FILL).setOnContentChange(() -> this.checkForRecipe());
        this.addTank((PosFluidTank)this.inputFluid);
        this.output = (SidedInvHandler)new SidedInvHandler("output", 129, 22, 3, 2).setColor(DyeColor.ORANGE).setRange(1, 3).setInputFilter((stack, integer) -> false).setTile((TileEntity)this);
        this.addInventory((PosInvHandler)this.output);
        this.outputFluid = (SidedFluidTank)new SidedFluidTank("output_fluid", 16000, 149, 20, 3).setColor(DyeColor.MAGENTA).setTile((TileEntity)this).setTankAction(PosFluidTank.Action.DRAIN);
        this.addTank((PosFluidTank)this.outputFluid);
    }

    private void checkForRecipe() {
        if (this.isServer()) {
            if (this.currentRecipe != null && this.currentRecipe.matches((IItemHandler)this.input, (PosFluidTank)this.inputFluid)) {
                return;
            }
            this.currentRecipe = RecipeUtil.getRecipes((World)this.field_145850_b, (IRecipeType)DissolutionChamberRecipe.SERIALIZER.getRecipeType()).stream().filter(dissolutionChamberRecipe -> dissolutionChamberRecipe.matches((IItemHandler)this.input, (PosFluidTank)this.inputFluid)).findFirst().orElse(null);
        }
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.checkForRecipe();
    }

    @Override
    public boolean canIncrease() {
        return this.currentRecipe != null && ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)this.currentRecipe.output.func_77946_l(), (boolean)true).func_190926_b() && this.outputFluid.fillForced(this.currentRecipe.outputFluid.copy(), IFluidHandler.FluidAction.SIMULATE) == this.currentRecipe.outputFluid.getAmount();
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            if (this.currentRecipe != null) {
                DissolutionChamberRecipe dissolutionChamberRecipe = this.currentRecipe;
                this.inputFluid.drainForced(dissolutionChamberRecipe.inputFluid, IFluidHandler.FluidAction.EXECUTE);
                for (int i = 0; i < this.input.getSlots(); ++i) {
                    this.input.getStackInSlot(i).func_190918_g(1);
                }
                if (dissolutionChamberRecipe.outputFluid != null && !dissolutionChamberRecipe.outputFluid.isEmpty()) {
                    this.outputFluid.fillForced(dissolutionChamberRecipe.outputFluid.copy(), IFluidHandler.FluidAction.EXECUTE);
                }
                ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)dissolutionChamberRecipe.output.func_77946_l(), (boolean)false);
            }
        };
    }

    @Override
    protected int getTickPower() {
        return 60;
    }

    @Override
    public int getMaxProgress() {
        return this.currentRecipe != null ? this.currentRecipe.processingTime : 100;
    }

    public static Pair<Integer, Integer> getSlotPos(int slot) {
        int slotSpacing = 22;
        int offset = 2;
        switch (slot) {
            case 1: {
                return Pair.of((Object)slotSpacing, (Object)(-offset));
            }
            case 2: {
                return Pair.of((Object)(slotSpacing * 2), (Object)0);
            }
            case 3: {
                return Pair.of((Object)(-offset), (Object)slotSpacing);
            }
            case 4: {
                return Pair.of((Object)(slotSpacing * 2 + offset), (Object)slotSpacing);
            }
            case 5: {
                return Pair.of((Object)0, (Object)(slotSpacing * 2));
            }
            case 6: {
                return Pair.of((Object)slotSpacing, (Object)(slotSpacing * 2 + offset));
            }
            case 7: {
                return Pair.of((Object)(slotSpacing * 2), (Object)(slotSpacing * 2));
            }
        }
        return Pair.of((Object)0, (Object)0);
    }
}

