/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.core.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.FluidExtractorRecipe;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BlockTileBase;
import com.hrznstudio.titanium.block.tile.fluid.PosFluidTank;
import com.hrznstudio.titanium.block.tile.fluid.SidedFluidTank;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.DyeColor;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidExtractorTile
extends IndustrialAreaWorkingTile {
    public static HashMap<DimensionType, HashMap<ChunkPos, HashMap<BlockPos, FluidExtractionProgress>>> EXTRACTION = new HashMap();
    private FluidExtractorRecipe currentRecipe;
    @Save
    private SidedFluidTank tank = (SidedFluidTank)new SidedFluidTank("latex", 1000, 43, 20, 0).setColor(DyeColor.LIGHT_GRAY).setTile((TileEntity)this).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)ModuleCore.LATEX.getSourceFluid()));

    public FluidExtractorTile() {
        super((BlockTileBase)ModuleCore.FLUID_EXTRACTOR, RangeManager.RangeType.BEHIND);
        this.addTank((PosFluidTank)this.tank);
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        BlockPos pos = this.getPointedBlockPos();
        if (this.isLoaded(pos)) {
            if (this.currentRecipe == null || !this.currentRecipe.matches(this.field_145850_b, pos)) {
                this.currentRecipe = this.findRecipe(this.field_145850_b, pos);
            }
            if (this.currentRecipe != null) {
                FluidExtractionProgress extractionProgress = EXTRACTION.computeIfAbsent(this.field_145850_b.field_73011_w.func_186058_p(), dimensionType -> new HashMap()).computeIfAbsent(this.field_145850_b.func_175726_f(pos).func_76632_l(), chunkPos -> new HashMap()).computeIfAbsent(pos, pos1 -> new FluidExtractionProgress(this.field_145850_b));
                this.tank.fill(this.currentRecipe.output.copy(), IFluidHandler.FluidAction.EXECUTE);
                if (this.field_145850_b.field_73012_v.nextDouble() <= (double)this.currentRecipe.breakChance) {
                    extractionProgress.setProgress(extractionProgress.getProgress() + 1);
                }
                if (extractionProgress.getProgress() > 7) {
                    extractionProgress.setProgress(0);
                    this.field_145850_b.func_175656_a(pos, this.currentRecipe.result.func_176223_P());
                }
                if (this.hasEnergy(500)) {
                    return new IndustrialWorkingTile.WorkAction(this, 0.4f, 500);
                }
                return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
            }
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    @Override
    public int getMaxProgress() {
        return 30;
    }

    @Nullable
    public FluidExtractorRecipe findRecipe(World world, BlockPos pos) {
        return RecipeUtil.getRecipes((World)world, (IRecipeType)FluidExtractorRecipe.SERIALIZER.getRecipeType()).stream().filter(fluidExtractorRecipe -> fluidExtractorRecipe.matches(world, pos) && !fluidExtractorRecipe.defaultRecipe).findFirst().orElseGet(() -> RecipeUtil.getRecipes((World)world, (IRecipeType)FluidExtractorRecipe.SERIALIZER.getRecipeType()).stream().filter(fluidExtractorRecipe -> fluidExtractorRecipe.matches(world, pos)).findFirst().orElse(null));
    }

    public static class FluidExtractionProgress {
        private int progress = 0;
        private int breakID;

        public FluidExtractionProgress(World world) {
            this.breakID = world.field_73012_v.nextInt();
        }

        public int getProgress() {
            return this.progress;
        }

        public void setProgress(int progress) {
            this.progress = progress;
        }

        public int getBreakID() {
            return this.breakID;
        }
    }
}

