/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.tile;

import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleGenerator;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IGuiAddon;
import com.hrznstudio.titanium.block.BlockTileBase;
import com.hrznstudio.titanium.block.tile.TileBase;
import com.hrznstudio.titanium.block.tile.fluid.PosFluidTank;
import com.hrznstudio.titanium.block.tile.fluid.SidedFluidTank;
import com.hrznstudio.titanium.block.tile.inventory.PosInvHandler;
import com.hrznstudio.titanium.block.tile.inventory.SidedInvHandler;
import com.hrznstudio.titanium.block.tile.progress.PosProgressBar;
import com.hrznstudio.titanium.client.gui.addon.ProgressBarGuiAddon;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BioReactorTile
extends IndustrialWorkingTile {
    public static Tag<Item>[] VALID = new Tag[]{IndustrialTags.Items.BIOREACTOR_INPUT, Tags.Items.CROPS_CARROT, Tags.Items.CROPS_POTATO, Tags.Items.CROPS_NETHER_WART, Tags.Items.DYES, Tags.Items.HEADS, Tags.Items.MUSHROOMS, Tags.Items.SEEDS, IndustrialTags.Items.SAPLING};
    @Save
    private SidedFluidTank biofuel;
    @Save
    private SidedFluidTank water = (SidedFluidTank)new SidedFluidTank("water", 16000, 45, 20, 0).setColor(DyeColor.CYAN).setTile((TileEntity)this).setTankAction(PosFluidTank.Action.FILL).setValidator(fluidStack -> fluidStack.getFluid().equals(Fluids.field_204546_a));
    @Save
    private SidedInvHandler input;
    @Save
    private PosProgressBar bar;

    public BioReactorTile() {
        super((BlockTileBase)ModuleGenerator.BIOREACTOR);
        this.addTank((PosFluidTank)this.water);
        this.input = (SidedInvHandler)new SidedInvHandler("input", 69, 22, 9, 1).setColor(DyeColor.BLUE).setRange(3, 3).setInputFilter((stack, integer) -> this.canInsert((int)integer, (ItemStack)stack)).setOutputFilter((stack, integer) -> false).setTile((TileEntity)this);
        this.addInventory((PosInvHandler)this.input);
        this.biofuel = (SidedFluidTank)new SidedFluidTank("biofuel", 16000, 128, 20, 2).setColor(DyeColor.PURPLE).setTile((TileEntity)this).setTankAction(PosFluidTank.Action.DRAIN).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)ModuleCore.BIOFUEL.getSourceFluid()));
        this.addTank((PosFluidTank)this.biofuel);
        this.bar = new PosProgressBar(150, 20, 100){

            public List<IFactory<? extends IGuiAddon>> getGuiAddons() {
                return Collections.singletonList(() -> new ProgressBarGuiAddon(BioReactorTile.this.bar.getPosX(), BioReactorTile.this.bar.getPosY(), this){

                    public List<String> getTooltipLines() {
                        return Arrays.asList(TextFormatting.GOLD + "Efficiency: " + TextFormatting.WHITE + (int)((double)BioReactorTile.this.getEfficiency() / 9.0 * 100.0) + TextFormatting.DARK_AQUA + "%");
                    }
                });
            }
        }.setColor(DyeColor.YELLOW).setCanIncrease(tileEntity -> true).setOnTickWork(() -> this.bar.setProgress((int)((double)this.getEfficiency() / 9.0 * 100.0))).setCanReset(tileEntity -> false).setTile((TileBase)this);
        this.addProgressBar(this.bar);
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.hasEnergy(2000)) {
            int efficiency = this.getEfficiency();
            if (efficiency <= 0) {
                return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
            }
            int fluidAmount = ((efficiency - 1) * 10 + 80) * efficiency;
            if (this.water.getFluidAmount() >= fluidAmount && this.biofuel.getCapacity() - this.biofuel.getFluidAmount() >= fluidAmount) {
                this.water.drainForced(fluidAmount, IFluidHandler.FluidAction.EXECUTE);
                this.biofuel.fillForced(new FluidStack((Fluid)ModuleCore.BIOFUEL.getSourceFluid(), fluidAmount), IFluidHandler.FluidAction.EXECUTE);
                for (int i = 0; i < this.input.getSlots(); ++i) {
                    this.input.getStackInSlot(i).func_190918_g(1);
                }
                new IndustrialWorkingTile.WorkAction(this, 1.0f, 2000);
            }
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    private boolean canInsert(int slot, ItemStack stack) {
        for (int i = 0; i < this.input.getSlots(); ++i) {
            if (i == slot || !this.input.getStackInSlot(i).func_77969_a(stack)) continue;
            return false;
        }
        for (Tag<Item> itemTag : VALID) {
            if (!itemTag.func_199685_a_((Object)stack.func_77973_b())) continue;
            return true;
        }
        return false;
    }

    private int getEfficiency() {
        int slots = 0;
        for (int i = 0; i < this.input.getSlots(); ++i) {
            if (this.input.getStackInSlot(i).func_190926_b()) continue;
            ++slots;
        }
        return slots;
    }

    @Override
    public int getMaxProgress() {
        return 200;
    }
}

