/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.gui.component.ItemGuiAddon;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IGuiAddon;
import com.hrznstudio.titanium.block.BlockTileBase;
import com.hrznstudio.titanium.block.tile.button.ArrowButton;
import com.hrznstudio.titanium.block.tile.inventory.PosInvHandler;
import com.hrznstudio.titanium.block.tile.inventory.SidedInvHandler;
import com.hrznstudio.titanium.block.tile.progress.PosProgressBar;
import com.hrznstudio.titanium.client.gui.addon.ProgressBarGuiAddon;
import com.hrznstudio.titanium.util.FacingUtil;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class DyeMixerTile
extends IndustrialProcessingTile {
    private static ColorUsage[] colorUsages = new ColorUsage[]{new ColorUsage(1, 1, 1), new ColorUsage(1, 1, 1), new ColorUsage(1, 0, 1), new ColorUsage(0, 0, 1), new ColorUsage(0, 1, 1), new ColorUsage(0, 1, 0), new ColorUsage(1, 0, 0), new ColorUsage(1, 1, 1), new ColorUsage(1, 1, 1), new ColorUsage(0, 0, 1), new ColorUsage(1, 0, 1), new ColorUsage(0, 0, 3), new ColorUsage(1, 1, 1), new ColorUsage(0, 3, 0), new ColorUsage(3, 0, 0), new ColorUsage(1, 1, 1)};
    @Save
    private SidedInvHandler inputRed = (SidedInvHandler)new SidedInvHandler("input_red", 33, 21, 1, 0).setColor(DyeColor.RED).setInputFilter((stack, integer) -> stack.func_77973_b().func_206844_a(Tags.Items.DYES_RED)).setTile((TileEntity)this);
    @Save
    private SidedInvHandler inputGreen;
    @Save
    private SidedInvHandler inputBlue;
    @Save
    private PosProgressBar red;
    @Save
    private PosProgressBar green;
    @Save
    private PosProgressBar blue;
    @Save
    private PosInvHandler output;
    @Save
    private int dye;

    public DyeMixerTile() {
        super((BlockTileBase)ModuleResourceProduction.DYE_MIXER, 96, 40);
        this.addInventory((PosInvHandler)this.inputRed);
        this.inputGreen = (SidedInvHandler)new SidedInvHandler("input_green", 33, 40, 1, 1).setColor(DyeColor.GREEN).setInputFilter((stack, integer) -> stack.func_77973_b().func_206844_a(Tags.Items.DYES_GREEN)).setTile((TileEntity)this);
        this.addInventory((PosInvHandler)this.inputGreen);
        this.inputBlue = (SidedInvHandler)new SidedInvHandler("input_blue", 33, 59, 1, 2).setColor(DyeColor.BLUE).setInputFilter((stack, integer) -> stack.func_77973_b().func_206844_a(Tags.Items.DYES_BLUE)).setTile((TileEntity)this);
        this.addInventory((PosInvHandler)this.inputBlue);
        this.red = new PosProgressBar(53, 20, 300){

            public List<IFactory<? extends IGuiAddon>> getGuiAddons() {
                return Collections.singletonList(() -> new ProgressBarGuiAddon(DyeMixerTile.this.red.getPosX(), DyeMixerTile.this.red.getPosY(), this){

                    public List<String> getTooltipLines() {
                        return Arrays.asList(TextFormatting.GOLD + "Amount: " + TextFormatting.WHITE + new DecimalFormat().format(DyeMixerTile.this.red.getProgress()) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + new DecimalFormat().format(DyeMixerTile.this.red.getMaxProgress()));
                    }
                });
            }
        }.setCanIncrease(tileEntity -> false).setCanReset(tileEntity -> false).setColor(DyeColor.RED);
        this.addProgressBar(this.red);
        this.blue = new PosProgressBar(66, 20, 300){

            public List<IFactory<? extends IGuiAddon>> getGuiAddons() {
                return Collections.singletonList(() -> new ProgressBarGuiAddon(DyeMixerTile.this.blue.getPosX(), DyeMixerTile.this.blue.getPosY(), this){

                    public List<String> getTooltipLines() {
                        return Arrays.asList(TextFormatting.GOLD + "Amount: " + TextFormatting.WHITE + new DecimalFormat().format(DyeMixerTile.this.blue.getProgress()) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + new DecimalFormat().format(DyeMixerTile.this.blue.getMaxProgress()));
                    }
                });
            }
        }.setCanIncrease(tileEntity -> false).setCanReset(tileEntity -> false).setColor(DyeColor.BLUE);
        this.addProgressBar(this.blue);
        this.green = new PosProgressBar(79, 20, 300){

            public List<IFactory<? extends IGuiAddon>> getGuiAddons() {
                return Collections.singletonList(() -> new ProgressBarGuiAddon(DyeMixerTile.this.green.getPosX(), DyeMixerTile.this.green.getPosY(), this){

                    public List<String> getTooltipLines() {
                        return Arrays.asList(TextFormatting.GOLD + "Amount: " + TextFormatting.WHITE + new DecimalFormat().format(DyeMixerTile.this.green.getProgress()) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + new DecimalFormat().format(DyeMixerTile.this.green.getMaxProgress()));
                    }
                });
            }
        }.setCanIncrease(tileEntity -> false).setCanReset(tileEntity -> false).setColor(DyeColor.GREEN);
        this.addProgressBar(this.green);
        this.output = new SidedInvHandler("output", 134, 58, 1, 3).setColor(DyeColor.ORANGE).setInputFilter((stack, integer) -> false).setTile((TileEntity)this);
        this.addInventory(this.output);
        this.addButton(new ArrowButton(116, 22, 14, 14, FacingUtil.Sideness.LEFT).setId(1).setPredicate((playerEntity, compoundNBT) -> {
            --this.dye;
            if (this.dye < 0) {
                this.dye = 15;
            }
            this.markForUpdate();
        }));
        this.addButton(new ArrowButton(154, 22, 14, 14, FacingUtil.Sideness.RIGHT).setId(2).setPredicate((playerEntity, compoundNBT) -> {
            ++this.dye;
            if (this.dye > 15) {
                this.dye = 0;
            }
            this.markForUpdate();
        }));
        this.addGuiAddonFactory(() -> new ItemGuiAddon(133, 20){

            @Override
            public ItemStack getItemStack() {
                return new ItemStack((IItemProvider)DyeItem.func_195961_a((DyeColor)DyeColor.func_196056_a((int)DyeMixerTile.this.dye)));
            }
        });
    }

    @Override
    public boolean canIncrease() {
        this.increaseBar(this.inputRed.getStackInSlot(0), this.red);
        this.increaseBar(this.inputGreen.getStackInSlot(0), this.green);
        this.increaseBar(this.inputBlue.getStackInSlot(0), this.blue);
        ColorUsage color = colorUsages[this.dye];
        ItemStack dye = new ItemStack((IItemProvider)DyeItem.func_195961_a((DyeColor)DyeColor.func_196056_a((int)this.dye)));
        return this.red.getProgress() >= color.r && this.green.getProgress() >= color.g && this.blue.getProgress() >= color.b && ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)dye, (boolean)true).func_190926_b();
    }

    private void increaseBar(ItemStack stack, PosProgressBar bar) {
        if (bar.getProgress() + 3 <= bar.getMaxProgress() && !stack.func_190926_b()) {
            stack.func_190918_g(1);
            bar.setProgress(bar.getProgress() + 3);
            this.markForUpdate();
        }
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            ItemStack dye = new ItemStack((IItemProvider)DyeItem.func_195961_a((DyeColor)DyeColor.func_196056_a((int)this.dye)));
            if (ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)dye, (boolean)true).func_190926_b()) {
                ColorUsage color = colorUsages[this.dye];
                this.red.setProgress(this.red.getProgress() - color.r);
                this.green.setProgress(this.green.getProgress() - color.g);
                this.blue.setProgress(this.blue.getProgress() - color.b);
                ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)dye, (boolean)false);
                this.markForUpdate();
            }
        };
    }

    @Override
    protected int getTickPower() {
        return 30;
    }

    private static class ColorUsage {
        private int r;
        private int g;
        private int b;

        public ColorUsage(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public int getR() {
            return this.r;
        }

        public int getG() {
            return this.g;
        }

        public int getB() {
            return this.b;
        }
    }
}

