/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BlockTileBase;
import com.hrznstudio.titanium.block.tile.fluid.PosFluidTank;
import com.hrznstudio.titanium.block.tile.fluid.SidedFluidTank;
import com.hrznstudio.titanium.block.tile.inventory.PosInvHandler;
import com.hrznstudio.titanium.block.tile.inventory.SidedInvHandler;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.util.Collection;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ResourcefulFurnaceTile
extends IndustrialProcessingTile {
    @Save
    private SidedInvHandler input = (SidedInvHandler)new SidedInvHandler("input", 44, 22, 3, 0).setColor(DyeColor.BLUE).setSlotLimit(1).setRange(1, 3).setOnSlotChanged((itemStack, integer) -> this.checkForRecipe((int)integer));
    @Save
    private SidedInvHandler output;
    @Save
    private SidedFluidTank tank;
    private FurnaceRecipe[] recipes;

    public ResourcefulFurnaceTile() {
        super((BlockTileBase)ModuleResourceProduction.RESOURCEFUL_FURNACE, 74, 40);
        this.addInventory((PosInvHandler)this.input);
        this.output = (SidedInvHandler)new SidedInvHandler("output", 110, 22, 3, 1).setColor(DyeColor.ORANGE).setInputFilter((itemStack, integer) -> false).setRange(1, 3);
        this.addInventory((PosInvHandler)this.output);
        this.tank = (SidedFluidTank)new SidedFluidTank("essence", 8000, 132, 20, 2).setColor(DyeColor.LIME).setTankAction(PosFluidTank.Action.DRAIN);
        this.addTank((PosFluidTank)this.tank);
        this.recipes = new FurnaceRecipe[3];
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.checkForRecipe(0);
        this.checkForRecipe(1);
        this.checkForRecipe(2);
    }

    private void checkForRecipe(int slot) {
        Collection recipes = RecipeUtil.getCookingRecipes((World)this.field_145850_b);
        this.recipes[slot] = recipes.stream().filter(furnaceRecipe -> ((Ingredient)furnaceRecipe.func_192400_c().get(0)).test(this.input.getStackInSlot(slot))).findAny().orElse(null);
    }

    @Override
    public boolean canIncrease() {
        for (FurnaceRecipe recipe : this.recipes) {
            if (recipe == null || !ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)recipe.func_77571_b().func_77946_l(), (boolean)true).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            for (int i = 0; i < this.recipes.length; ++i) {
                FurnaceRecipe recipe = this.recipes[i];
                if (recipe == null || !ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)recipe.func_77571_b().func_77946_l(), (boolean)true).func_190926_b() || !ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)recipe.func_77571_b().func_77946_l(), (boolean)true).func_190926_b()) continue;
                this.input.setStackInSlot(i, ItemStack.field_190927_a);
                ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)recipe.func_77571_b().func_77946_l(), (boolean)false);
                this.tank.fill(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid(), (int)(recipe.func_222138_b() * 20.0f)), IFluidHandler.FluidAction.EXECUTE);
            }
        };
    }

    @Override
    protected int getTickPower() {
        return 40;
    }
}

