/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.tile;

import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.item.RangeAddonItem;
import com.buuz135.industrial.proxy.client.IndustrialAssetProvider;
import com.buuz135.industrial.utils.BlockUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.augment.IAugment;
import com.hrznstudio.titanium.api.client.IGuiAddon;
import com.hrznstudio.titanium.block.BlockTileBase;
import com.hrznstudio.titanium.block.tile.button.PosButton;
import com.hrznstudio.titanium.client.gui.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.gui.addon.StateButtonInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;

public abstract class IndustrialAreaWorkingTile
extends IndustrialWorkingTile {
    @Save
    private int pointer = 0;
    @Save
    private boolean showingArea = false;
    private PosButton areaButton = new PosButton(154, 84, 14, 14){

        public List<IFactory<? extends IGuiAddon>> getGuiAddons() {
            ArrayList<IFactory<? extends IGuiAddon>> addons = new ArrayList<IFactory<? extends IGuiAddon>>();
            addons.add(() -> new StateButtonAddon(IndustrialAreaWorkingTile.this.areaButton, new StateButtonInfo[]{new StateButtonInfo(0, IndustrialAssetProvider.BUTTON_SHOW_AREA, new String[]{"text.industrialforegoing.button.show_area"}), new StateButtonInfo(1, IndustrialAssetProvider.BUTTON_HIDE_AREA, new String[]{"text.industrialforegoing.button.hide_area"})}){

                public int getState() {
                    return IndustrialAreaWorkingTile.this.showingArea ? 1 : 0;
                }
            });
            return addons;
        }
    }.setPredicate((playerEntity, compoundNBT) -> {
        this.showingArea = !this.showingArea;
    });
    private RangeManager.RangeType type;

    public IndustrialAreaWorkingTile(BlockTileBase blockTileBase, RangeManager.RangeType type) {
        super(blockTileBase);
        this.addButton(this.areaButton);
        this.type = type;
    }

    public VoxelShape getWorkingArea() {
        return new RangeManager(this.field_174879_c, this.getFacingDirection(), this.type).get(this.hasAugmentInstalled(RangeAddonItem.RANGE) ? (int)((IAugment)this.getInstalledAugments(RangeAddonItem.RANGE).get(0)).getAugmentRatio() + 1 : 0);
    }

    public BlockPos getPointedBlockPos() {
        List<BlockPos> blockPosList = BlockUtils.getBlockPosInAABB(this.getWorkingArea().func_197752_a());
        this.pointer = this.safetyPointerCheck(blockPosList);
        return blockPosList.get(this.pointer);
    }

    private int safetyPointerCheck(List<BlockPos> blockPosList) {
        return this.pointer < blockPosList.size() ? this.pointer : 0;
    }

    public void increasePointer() {
        ++this.pointer;
    }

    public boolean isShowingArea() {
        return this.showingArea;
    }

    public boolean isLoaded(BlockPos pos) {
        return this.field_145850_b.func_175707_a(pos, pos);
    }

    public boolean canAcceptAugment(IAugment augment) {
        return super.canAcceptAugment(augment) && augment.getAugmentType().equals(RangeAddonItem.RANGE);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getWorkingArea().func_197752_a();
    }
}

