/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.tile;

import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BlockTileBase;
import com.hrznstudio.titanium.block.tile.TileBase;
import com.hrznstudio.titanium.block.tile.TileMachine;
import com.hrznstudio.titanium.block.tile.progress.PosProgressBar;
import com.hrznstudio.titanium.client.gui.addon.EnergyBarGuiAddon;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class IndustrialProcessingTile
extends TileMachine {
    @Save
    private PosProgressBar progressBar;

    public IndustrialProcessingTile(BlockTileBase blockTileBase, int x, int y) {
        super(blockTileBase);
        this.addGuiAddonFactory(() -> new EnergyBarGuiAddon(10, 20, (IEnergyStorage)this.getEnergyStorage()));
        this.progressBar = new PosProgressBar(x, y, 100).setTile((TileBase)this).setBarDirection(PosProgressBar.BarDirection.HORIZONTAL_RIGHT).setCanReset(tileEntity -> true).setOnStart(() -> this.progressBar.setMaxProgress(this.getMaxProgress())).setCanIncrease(tileEntity -> this.getEnergyStorage().getEnergyStored() > this.getTickPower() && this.canIncrease()).setOnTickWork(() -> this.getEnergyStorage().extractEnergyForced(this.getTickPower())).setOnFinishWork(() -> this.onFinish().run());
        this.addProgressBar(this.progressBar);
    }

    public PosProgressBar getProgressBar() {
        return this.progressBar;
    }

    public boolean onActivated(PlayerEntity playerIn, Hand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ)) {
            return true;
        }
        this.openGui(playerIn);
        return true;
    }

    public int getMaxProgress() {
        return 100;
    }

    public abstract boolean canIncrease();

    public abstract Runnable onFinish();

    protected abstract int getTickPower();
}

