/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.tile;

import com.buuz135.industrial.proxy.client.IndustrialAssetProvider;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BlockTileBase;
import com.hrznstudio.titanium.block.tile.TileBase;
import com.hrznstudio.titanium.block.tile.TileMachine;
import com.hrznstudio.titanium.block.tile.progress.PosProgressBar;
import com.hrznstudio.titanium.client.gui.addon.EnergyBarGuiAddon;
import com.hrznstudio.titanium.client.gui.asset.IAssetProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class IndustrialWorkingTile
extends TileMachine {
    @Save
    private PosProgressBar workingBar;

    public IndustrialWorkingTile(BlockTileBase blockTileBase) {
        super(blockTileBase);
        this.addGuiAddonFactory(() -> new EnergyBarGuiAddon(10, 20, (IEnergyStorage)this.getEnergyStorage()));
        this.workingBar = new PosProgressBar(30, 20, 0, this.getMaxProgress()).setTile((TileBase)this).setBarDirection(PosProgressBar.BarDirection.VERTICAL_UP).setIncreaseType(false).setOnFinishWork(() -> {
            if (this.isServer()) {
                WorkAction work = this.work();
                this.workingBar.setProgress((int)((float)this.workingBar.getMaxProgress() * work.getWorkAmount()));
                this.getEnergyStorage().extractEnergyForced(work.getEnergyConsumed());
            }
        }).setOnStart(() -> this.workingBar.setMaxProgress(this.getMaxProgress())).setCanReset(tileEntity -> true).setCanIncrease(tileEntity -> true).setColor(DyeColor.LIME);
        this.addProgressBar(this.workingBar);
    }

    public boolean onActivated(PlayerEntity playerIn, Hand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ)) {
            return true;
        }
        this.openGui(playerIn);
        return true;
    }

    public abstract WorkAction work();

    public boolean hasEnergy(int amount) {
        return this.getEnergyStorage().getEnergyStored() >= amount;
    }

    public int getMaxProgress() {
        return 100;
    }

    public IAssetProvider getAssetProvider() {
        return IndustrialAssetProvider.INSTANCE;
    }

    public class WorkAction {
        private final float workAmount;
        private final int energyConsumed;

        public WorkAction(float workAmount, int energyConsumed) {
            this.workAmount = workAmount;
            this.energyConsumed = energyConsumed;
        }

        public float getWorkAmount() {
            return this.workAmount;
        }

        public int getEnergyConsumed() {
            return this.energyConsumed;
        }
    }
}

