/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transport;

import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.block.transport.tile.ConveyorTile;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.IRecipeProvider;
import com.hrznstudio.titanium.api.raytrace.DistanceRayTraceResult;
import com.hrznstudio.titanium.block.BlockTileBase;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.util.RayTraceUtils;
import com.hrznstudio.titanium.util.TileUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

public class ConveyorBlock
extends BlockTileBase<ConveyorTile>
implements IWaterLoggable,
IRecipeProvider {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<EnumType> TYPE = EnumProperty.func_177709_a((String)"type", EnumType.class);
    public static final EnumProperty<EnumSides> SIDES = EnumProperty.func_177709_a((String)"sides", EnumSides.class);
    private ConveyorItem item;

    public ConveyorBlock(ItemGroup group) {
        super("conveyor", Block.Properties.func_200949_a((Material)Material.field_151574_g, (MaterialColor)MaterialColor.field_151676_q).func_200942_a().func_200943_b(2.0f), ConveyorTile.class);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a(SIDES, (Comparable)((Object)EnumSides.NONE))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.item = new ConveyorItem((Block)this, group);
        this.setItemGroup(group);
    }

    public Item func_199767_j() {
        return this.item;
    }

    public IFactory<BlockItem> getItemBlockFactory() {
        return this::getItem;
    }

    public int func_180656_a(BlockState blockState, IBlockReader world, BlockPos pos, Direction side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ConveyorTile) {
            return ((ConveyorTile)tileEntity).getPower();
        }
        return super.func_180656_a(blockState, world, pos, side);
    }

    public int func_176211_b(BlockState blockState, IBlockReader world, BlockPos pos, Direction side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ConveyorTile) {
            return side == Direction.UP ? ((ConveyorTile)tileEntity).getPower() : 0;
        }
        return super.func_176211_b(blockState, world, pos, side);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ConveyorTile) {
            ConveyorUpgrade upgrade;
            if (target instanceof DistanceRayTraceResult && (upgrade = ((ConveyorTile)tileEntity).getUpgradeMap().get(this.getFacingUpgradeHit(state, player.field_70170_p, pos, player))) != null) {
                return new ItemStack((IItemProvider)upgrade.getFactory().getUpgradeItem(), 1);
            }
            return new ItemStack((IItemProvider)this, 1);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public BlockState getStateAtViewpoint(BlockState state, IBlockReader world, BlockPos pos, Vec3d viewpoint) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ConveyorTile) {
            state = (BlockState)((BlockState)state.func_206870_a((IProperty)FACING, (Comparable)((ConveyorTile)tileEntity).getFacing())).func_206870_a(TYPE, (Comparable)((Object)((ConveyorTile)tileEntity).getConveyorType()));
        }
        if (((EnumType)((Object)state.func_177229_b(TYPE))).equals((Object)EnumType.FLAT) || ((EnumType)((Object)state.func_177229_b(TYPE))).equals((Object)EnumType.FLAT_FAST)) {
            Direction right = ((Direction)state.func_177229_b((IProperty)FACING)).func_176746_e();
            Direction left = ((Direction)state.func_177229_b((IProperty)FACING)).func_176735_f();
            state = this.isConveyorAndFacing(pos.func_177972_a(right), world, left) && this.isConveyorAndFacing(pos.func_177972_a(left), world, right) || this.isConveyorAndFacing(pos.func_177972_a(right).func_177977_b(), world, left) && this.isConveyorAndFacing(pos.func_177972_a(left).func_177977_b(), world, right) ? (BlockState)state.func_206870_a(SIDES, (Comparable)((Object)EnumSides.BOTH)) : (this.isConveyorAndFacing(pos.func_177972_a(right), world, left) || this.isConveyorAndFacing(pos.func_177972_a(right).func_177977_b(), world, left) ? (BlockState)state.func_206870_a(SIDES, (Comparable)((Object)EnumSides.RIGHT)) : (this.isConveyorAndFacing(pos.func_177972_a(left), world, right) || this.isConveyorAndFacing(pos.func_177972_a(left).func_177977_b(), world, right) ? (BlockState)state.func_206870_a(SIDES, (Comparable)((Object)EnumSides.LEFT)) : (BlockState)state.func_206870_a(SIDES, (Comparable)((Object)EnumSides.NONE))));
        }
        return state;
    }

    private boolean isConveyorAndFacing(BlockPos pos, IBlockReader world, Direction toFace) {
        return world.func_180495_p(pos).func_177230_c() instanceof ConveyorBlock && (toFace == null || ((Direction)world.func_180495_p(pos).func_177229_b((IProperty)FACING)).equals((Object)toFace));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, p_220069_6_);
    }

    public List<VoxelShape> getBoundingBoxes(BlockState state, IBlockReader source, BlockPos pos) {
        ArrayList<VoxelShape> boxes = new ArrayList<VoxelShape>();
        if (((EnumType)((Object)state.func_177229_b(TYPE))).isVertical()) {
            boxes.add(VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0));
        } else {
            boxes.add(VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0));
        }
        TileEntity entity = source.func_175625_s(pos);
        if (entity instanceof ConveyorTile) {
            for (ConveyorUpgrade upgrade : ((ConveyorTile)entity).getUpgradeMap().values()) {
                if (upgrade == null) continue;
                boxes.add(VoxelShapes.func_197881_a((AxisAlignedBB)upgrade.getBoundingBox().func_197752_a()));
            }
        }
        return boxes;
    }

    public boolean hasCustomBoxes(BlockState state, IBlockReader source, BlockPos pos) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{FACING, SIDES, TYPE, WATERLOGGED});
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_149716_u() {
        return true;
    }

    public IFactory<ConveyorTile> getTileEntityFactory() {
        return ConveyorTile::new;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (placer != null) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof ConveyorTile) {
                ((ConveyorTile)tileEntity).setFacing(placer.func_174811_aO());
            }
            this.updateConveyorPlacing(worldIn, pos, state, true);
        }
    }

    private void updateConveyorPlacing(World worldIn, BlockPos pos, BlockState state, boolean first) {
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity instanceof ConveyorTile) {
            Direction direction = ((ConveyorTile)entity).getFacing();
            Direction right = ((Direction)state.func_177229_b((IProperty)FACING)).func_176746_e();
            Direction left = ((Direction)state.func_177229_b((IProperty)FACING)).func_176735_f();
            if (((ConveyorTile)entity).getUpgradeMap().isEmpty()) {
                if (this.isConveyorAndFacing(pos.func_177984_a().func_177972_a(direction), (IBlockReader)worldIn, null)) {
                    ((ConveyorTile)entity).setType(((ConveyorTile)entity).getConveyorType().getVertical(Direction.UP));
                } else if (this.isConveyorAndFacing(pos.func_177984_a().func_177972_a(direction.func_176734_d()), (IBlockReader)worldIn, null)) {
                    ((ConveyorTile)entity).setType(((ConveyorTile)entity).getConveyorType().getVertical(Direction.DOWN));
                }
            }
            if (!first) {
                return;
            }
            if (this.isConveyorAndFacing(pos.func_177972_a(direction.func_176734_d()).func_177977_b(), (IBlockReader)worldIn, direction)) {
                this.updateConveyorPlacing(worldIn, pos.func_177972_a(direction.func_176734_d()).func_177977_b(), state, false);
            }
            if (this.isConveyorAndFacing(pos.func_177972_a(left).func_177977_b(), (IBlockReader)worldIn, right)) {
                this.updateConveyorPlacing(worldIn, pos.func_177972_a(left).func_177977_b(), state, false);
            }
            if (this.isConveyorAndFacing(pos.func_177972_a(right).func_177977_b(), (IBlockReader)worldIn, left)) {
                this.updateConveyorPlacing(worldIn, pos.func_177972_a(right).func_177977_b(), state, false);
            }
            if (this.isConveyorAndFacing(pos.func_177972_a(direction).func_177977_b(), (IBlockReader)worldIn, direction)) {
                this.updateConveyorPlacing(worldIn, pos.func_177972_a(direction).func_177977_b(), state, false);
            }
            worldIn.func_184138_a(pos, state, state, 3);
        }
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        ItemStack handStack = player.func_184586_b(hand);
        if (tileEntity instanceof ConveyorTile) {
            Direction facing = this.getFacingUpgradeHit(state, worldIn, pos, player);
            if (player.func_70093_af()) {
                if (facing != null) {
                    ((ConveyorTile)tileEntity).removeUpgrade(facing, true);
                    return true;
                }
                return false;
            }
            if (facing == null) {
                if (handStack.func_77973_b().equals(Items.field_151114_aO) && !((ConveyorTile)tileEntity).getConveyorType().isFast()) {
                    ((ConveyorTile)tileEntity).setType(((ConveyorTile)tileEntity).getConveyorType().getFast());
                    handStack.func_190918_g(1);
                    return true;
                }
                if (handStack.func_77973_b().equals((Object)ModuleCore.PLASTIC) && !((ConveyorTile)tileEntity).isSticky()) {
                    ((ConveyorTile)tileEntity).setSticky(true);
                    handStack.func_190918_g(1);
                    return true;
                }
                if (handStack.func_77973_b() instanceof DyeItem) {
                    ((ConveyorTile)tileEntity).setColor(((DyeItem)handStack.func_77973_b()).func_195962_g());
                    return true;
                }
            } else if (((ConveyorTile)tileEntity).hasUpgrade(facing)) {
                ConveyorUpgrade upgrade = ((ConveyorTile)tileEntity).getUpgradeMap().get(facing);
                if (upgrade.onUpgradeActivated(player, hand)) {
                    return true;
                }
                if (upgrade.hasGui()) {
                    ((ConveyorTile)tileEntity).openGui(player, facing);
                    return true;
                }
            }
            return false;
        }
        return super.func_220051_a(state, worldIn, pos, player, hand, ray);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext p_220053_4_) {
        if (((EnumType)((Object)state.func_177229_b(TYPE))).isVertical()) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.4, (double)1.0);
        }
        VoxelShape shape = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0);
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof ConveyorTile) {
            for (ConveyorUpgrade upgrade : ((ConveyorTile)entity).getUpgradeMap().values()) {
                if (upgrade == null) continue;
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)upgrade.getBoundingBox().func_197752_a()));
            }
        }
        return shape;
    }

    public Direction getFacingUpgradeHit(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        VoxelShape hit;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        RayTraceResult result = RayTraceUtils.rayTraceSimple((World)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f);
        if (result instanceof BlockRayTraceResult && (hit = RayTraceUtils.rayTraceVoxelShape((BlockRayTraceResult)((BlockRayTraceResult)result), (World)worldIn, (LivingEntity)player, (double)32.0, (float)0.0f)) != null && tileEntity instanceof ConveyorTile) {
            for (Direction direction : ((ConveyorTile)tileEntity).getUpgradeMap().keySet()) {
                if (!VoxelShapes.func_197879_c((VoxelShape)((ConveyorTile)tileEntity).getUpgradeMap().get(direction).getBoundingBox(), (VoxelShape)hit, (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
                return direction;
            }
        }
        return null;
    }

    public boolean hasIndividualRenderVoxelShape() {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        ConveyorTile tile = new ConveyorTile();
        return tile;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195999_j().func_174811_aO())).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity instanceof ConveyorTile) {
            ((ConveyorTile)entity).handleEntityMovement(entityIn);
        }
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        NonNullList drops = NonNullList.func_191196_a();
        Optional entity = TileUtil.getTileEntity((IBlockReader)worldIn, (BlockPos)pos, ConveyorTile.class);
        entity.ifPresent(tileEntityConveyor -> {
            for (Direction value : Direction.values()) {
                if (!tileEntityConveyor.getUpgradeMap().containsKey(value)) continue;
                ConveyorUpgrade upgrade = tileEntityConveyor.getUpgradeMap().get(value);
                drops.addAll(upgrade.getDrops());
            }
            if (tileEntityConveyor.isSticky()) {
                drops.add((Object)new ItemStack((IItemProvider)ModuleCore.PLASTIC));
            }
            if (tileEntityConveyor.getConveyorType().isFast()) {
                drops.add((Object)new ItemStack((IItemProvider)Items.field_151114_aO));
            }
        });
        return drops;
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return true;
    }

    public boolean func_220067_a(BlockState state, IBlockReader worldIn, BlockPos pos, EntityType<?> type) {
        return true;
    }

    public boolean func_181623_g() {
        return true;
    }

    public ConveyorItem getItem() {
        return this.item;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new ConveyorTile();
    }

    public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((IItemProvider)this, (int)6).func_200472_a("ppp").func_200472_a("iri").func_200472_a("ppp").func_200469_a(Character.valueOf('p'), IndustrialTags.Items.PLASTIC).func_200469_a(Character.valueOf('i'), Tags.Items.INGOTS_IRON).func_200462_a(Character.valueOf('r'), (IItemProvider)Items.field_151137_ax).func_200464_a(consumer);
    }

    private class ConveyorItem
    extends BlockItem {
        public ConveyorItem(Block block, ItemGroup group) {
            super(block, new Item.Properties().func_200916_a(group));
            this.setRegistryName(block.getRegistryName());
        }

        @Nullable
        public String getCreatorModId(ItemStack itemStack) {
            return new TranslationTextComponent(this.field_77701_a.func_78024_c(), new Object[0]).func_150254_d();
        }
    }

    public static enum EnumSides implements IStringSerializable
    {
        NONE,
        LEFT,
        RIGHT,
        BOTH;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        FLAT(false),
        UP(false),
        DOWN(false),
        FLAT_FAST(true),
        UP_FAST(true),
        DOWN_FAST(true);

        private boolean fast;

        private EnumType(boolean fast) {
            this.fast = fast;
        }

        public static EnumType getFromName(String name) {
            for (EnumType type : EnumType.values()) {
                if (!type.func_176610_l().equalsIgnoreCase(name)) continue;
                return type;
            }
            return FLAT;
        }

        public boolean isFast() {
            return this.fast;
        }

        public EnumType getFast() {
            switch (this) {
                case FLAT: {
                    return FLAT_FAST;
                }
                case UP: {
                    return UP_FAST;
                }
                case DOWN: {
                    return DOWN_FAST;
                }
            }
            return this;
        }

        public EnumType getVertical(Direction facing) {
            if (this.isFast()) {
                if (facing == Direction.UP) {
                    return UP_FAST;
                }
                if (facing == Direction.DOWN) {
                    return DOWN_FAST;
                }
                return FLAT_FAST;
            }
            if (facing == Direction.UP) {
                return UP;
            }
            if (facing == Direction.DOWN) {
                return DOWN;
            }
            return FLAT_FAST;
        }

        public boolean isVertical() {
            return this.isDown() || this.isUp();
        }

        public boolean isUp() {
            return this.equals((Object)UP) || this.equals((Object)UP_FAST);
        }

        public boolean isDown() {
            return this.equals((Object)DOWN) || this.equals((Object)DOWN_FAST);
        }

        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

