/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.component;

import com.buuz135.industrial.api.conveyor.gui.PositionedGuiComponent;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.conveyor.GuiConveyor;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;

public abstract class TexturedStateButtonGuiComponent
extends PositionedGuiComponent {
    private final int id;
    private StateButtonInfo[] buttonInfos;

    public TexturedStateButtonGuiComponent(int id, int x, int y, int xSize, int ySize, StateButtonInfo ... buttonInfos) {
        super(x, y, xSize, ySize);
        this.id = id;
        this.buttonInfos = new StateButtonInfo[0];
        if (buttonInfos != null) {
            this.buttonInfos = buttonInfos;
        }
    }

    @Override
    public boolean handleClick(GuiConveyor conveyor, int guiX, int guiY, double mouseX, double mouseY) {
        conveyor.sendMessage(this.id, new CompoundNBT());
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SimpleSound(SoundEvents.field_187909_gi, SoundCategory.PLAYERS, 1.0f, 1.0f, Minecraft.func_71410_x().field_71439_g.func_180425_c()));
        return true;
    }

    @Override
    public void drawGuiBackgroundLayer(int guiX, int guiY, double mouseX, double mouseY) {
        StateButtonInfo buttonInfo = this.getStateInfo();
        if (buttonInfo != null) {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(buttonInfo.getTexture());
            Minecraft.func_71410_x().field_71462_r.blit(guiX + this.getXPos(), guiY + this.getYPos(), buttonInfo.getTextureX(), buttonInfo.getTextureY(), this.getXSize(), this.getYSize());
        }
    }

    @Override
    public void drawGuiForegroundLayer(int guiX, int guiY, double mouseX, double mouseY) {
        StateButtonInfo buttonInfo = this.getStateInfo();
        if (buttonInfo != null && this.isInside(mouseX, mouseY)) {
            GlStateManager.disableLighting();
            GlStateManager.enableDepthTest();
            Screen cfr_ignored_0 = Minecraft.func_71410_x().field_71462_r;
            Screen.fill((int)(this.getXPos() - guiX), (int)(this.getYPos() - guiY), (int)(this.getXPos() + this.getXSize() - guiX), (int)(this.getYPos() + this.getYSize() - guiY), (int)-2130706433);
            GlStateManager.enableLighting();
            GlStateManager.disableAlphaTest();
        }
    }

    @Override
    @Nullable
    public List<String> getTooltip(int guiX, int guiY, double mouseX, double mouseY) {
        StateButtonInfo buttonInfo = this.getStateInfo();
        if (buttonInfo != null) {
            return Arrays.asList(buttonInfo.getTooltip());
        }
        return null;
    }

    public abstract int getState();

    private StateButtonInfo getStateInfo() {
        for (StateButtonInfo buttonInfo : this.buttonInfos) {
            if (buttonInfo.getState() != this.getState()) continue;
            return buttonInfo;
        }
        return null;
    }
}

