/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity;

import com.buuz135.industrial.item.IFCustomItem;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.proxy.CommonProxy;
import com.google.common.collect.Multimap;
import com.hrznstudio.titanium.item.ItemBase;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.util.RayTraceUtils;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class ItemInfinityDrill
extends IFCustomItem {
    public static Material[] mineableMaterials = new Material[]{Material.field_151574_g, Material.field_151571_B, Material.field_151592_s, Material.field_151588_w, Material.field_151573_f, Material.field_151598_x, Material.field_76233_E, Material.field_151576_e, Material.field_151595_p, Material.field_151597_y};
    public static int POWER_CONSUMPTION = 10000;
    public static int FUEL_CONSUMPTION = 3;

    public ItemInfinityDrill(ItemGroup group) {
        super("infinity_drill", group, new Item.Properties().func_200917_a(1).addToolType(ToolType.PICKAXE, 3).addToolType(ToolType.SHOVEL, 3));
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        this.addNbt(stack, 0L, 0, CommonProxy.CONTRIBUTORS.contains(playerIn.func_110124_au().toString()));
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return 2;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnchantmentType.DIGGER;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (DrillTier value : DrillTier.values()) {
                items.add((Object)this.createStack(value.getPowerNeeded(), 0, false));
            }
            items.add((Object)this.createStack(DrillTier.ARTIFACT.getPowerNeeded(), 1000000, true));
        }
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.BOW;
    }

    public boolean func_150897_b(BlockState blockIn) {
        return Items.field_151046_w.func_150897_b(blockIn) || Items.field_151047_v.func_150897_b(blockIn);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged && !oldStack.equals(newStack);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return this.enoughFuel(stack) ? 10.0f : 0.0f;
    }

    private boolean isValidMaterial(Material material) {
        for (Material mineableMaterial : mineableMaterials) {
            if (!mineableMaterial.equals(material)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new InfinityDrillCapabilityProvider(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (Screen.hasShiftDown()) {
            int fuel = this.getFuelFromStack(stack);
            return 1.0 - (double)fuel / 1000000.0;
        }
        long power = this.getPowerFromStack(stack);
        return 1.0 - (double)power / (double)((DrillTier)((Object)DrillTier.getTierBraquet(power).getRight())).getPowerNeeded();
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return Screen.hasShiftDown() ? 13304063 : 53503;
    }

    public boolean hasTooltipDetails(@Nullable ItemBase.Key key) {
        return true;
    }

    public void addTooltipDetails(@Nullable ItemBase.Key key, ItemStack stack, List<ITextComponent> tooltip, boolean advanced) {
        long power = this.getPowerFromStack(stack);
        Pair<DrillTier, DrillTier> braquet = DrillTier.getTierBraquet(power);
        DrillTier current = this.getSelectedDrillTier(stack);
        tooltip.add(new TranslationTextComponent("text.industrialforegoing.display.current_area", new Object[0]).func_150258_a(" ").func_150258_a(this.getFormattedArea(current, current.getRadius())).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        tooltip.add(new TranslationTextComponent("text.industrialforegoing.display.tier", new Object[0]).func_150258_a(" ").func_150258_a(((DrillTier)((Object)braquet.getLeft())).getColor() + ((DrillTier)((Object)braquet.getLeft())).getLocalizedName()).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        tooltip.add(new TranslationTextComponent("text.industrialforegoing.display.power", new Object[0]).func_150258_a(" ").func_150258_a(new DecimalFormat().format(power)).func_150258_a("/").func_150258_a(new DecimalFormat().format(((DrillTier)((Object)braquet.getRight())).getPowerNeeded())).func_150258_a("RF ").func_150257_a((ITextComponent)new TranslationTextComponent("text.industrialforegoing.display.next_tier", new Object[0])).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        int fuelAmount = this.getFuelFromStack(stack);
        tooltip.add(new TranslationTextComponent("text.industrialforegoing.display.fluid", new Object[0]).func_150258_a(" ").func_150258_a(new DecimalFormat().format(fuelAmount)).func_150258_a("/").func_150258_a(new DecimalFormat().format(1000000L)).func_150258_a(" mb of Biofuel").func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        tooltip.add(new TranslationTextComponent("text.industrialforegoing.display.max_area", new Object[0]).func_150258_a(" ").func_150258_a(this.getFormattedArea((DrillTier)((Object)braquet.getLeft()), ((DrillTier)((Object)braquet.getLeft())).getRadius())).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        if (this.isSpecial(stack)) {
            tooltip.add(new TranslationTextComponent("text.industrialforegoing.display.special", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        }
    }

    public long getPowerFromStack(ItemStack stack) {
        long power = 0L;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Energy")) {
            power = stack.func_77978_p().func_74763_f("Energy");
        }
        return power;
    }

    public int getFuelFromStack(ItemStack stack) {
        int fuelAmount = 0;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Fluid") && stack.func_77978_p().func_74775_l("Fluid").func_74764_b("Amount")) {
            fuelAmount = stack.func_77978_p().func_74775_l("Fluid").func_74762_e("Amount");
        }
        return fuelAmount;
    }

    public boolean isSpecial(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("Special") && stack.func_77978_p().func_74767_n("Special");
    }

    public ItemStack createStack(long power, int fuel, boolean special) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        this.addNbt(stack, power, fuel, special);
        return stack;
    }

    public void addNbt(ItemStack stack, long power, int fuel, boolean special) {
        CompoundNBT tagCompound = new CompoundNBT();
        tagCompound.func_74772_a("Energy", power);
        CompoundNBT fluid = new CompoundNBT();
        fluid.func_74778_a("FluidName", "biofuel");
        fluid.func_74768_a("Amount", fuel);
        tagCompound.func_218657_a("Fluid", (INBT)fluid);
        tagCompound.func_74757_a("Special", special);
        tagCompound.func_74778_a("Selected", ((DrillTier)((Object)DrillTier.getTierBraquet(power).getLeft())).name());
        stack.func_77982_d(tagCompound);
    }

    private String getFormattedArea(DrillTier tier, int radius) {
        int diameter = radius * 2 + 1;
        return diameter + "x" + diameter + "x" + (tier == DrillTier.ARTIFACT ? diameter : 1);
    }

    private boolean enoughFuel(ItemStack stack) {
        return this.getFuelFromStack(stack) >= FUEL_CONSUMPTION || this.getPowerFromStack(stack) >= (long)POWER_CONSUMPTION;
    }

    private void consumeFuel(ItemStack stack) {
        if (this.getFuelFromStack(stack) >= FUEL_CONSUMPTION) {
            ((IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).orElseThrow(RuntimeException::new)).drain(FUEL_CONSUMPTION, IFluidHandler.FluidAction.EXECUTE);
        } else {
            stack.func_77978_p().func_74772_a("Energy", stack.func_77978_p().func_74763_f("Energy") - (long)POWER_CONSUMPTION);
        }
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        RayTraceResult rayTraceResult;
        if (entityLiving instanceof PlayerEntity && (rayTraceResult = RayTraceUtils.rayTraceSimple((World)worldIn, (LivingEntity)entityLiving, (double)16.0, (float)0.0f)).func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockResult = (BlockRayTraceResult)rayTraceResult;
            Direction facing = blockResult.func_216354_b();
            DrillTier currentTier = this.getSelectedDrillTier(stack);
            Pair<BlockPos, BlockPos> area = this.getArea(pos, facing, currentTier, true);
            BlockPos.func_218278_a((BlockPos)((BlockPos)area.getLeft()), (BlockPos)((BlockPos)area.getRight())).forEach(blockPos -> {
                if (this.enoughFuel(stack) && worldIn.func_175625_s(blockPos) == null && entityLiving instanceof ServerPlayerEntity && !worldIn.func_175623_d(blockPos)) {
                    BlockState tempState = worldIn.func_180495_p(blockPos);
                    Block block = tempState.func_177230_c();
                    if (block.func_176195_g(tempState, (IBlockReader)worldIn, blockPos) < 0.0f) {
                        return;
                    }
                    int xp = ForgeHooks.onBlockBreakEvent((World)worldIn, (GameType)((ServerPlayerEntity)entityLiving).field_71134_c.func_73081_b(), (ServerPlayerEntity)((ServerPlayerEntity)entityLiving), (BlockPos)blockPos);
                    if (xp >= 0 && block.removedByPlayer(tempState, worldIn, blockPos, (PlayerEntity)entityLiving, true, tempState.func_204520_s())) {
                        block.func_176206_d((IWorld)worldIn, blockPos, tempState);
                        block.func_180657_a(worldIn, (PlayerEntity)entityLiving, blockPos, tempState, null, stack);
                        block.func_180637_b(worldIn, blockPos, xp);
                        this.consumeFuel(stack);
                    }
                }
            });
            worldIn.func_217357_a(ItemEntity.class, new AxisAlignedBB((BlockPos)area.getLeft(), (BlockPos)area.getRight()).func_186662_g(1.0)).forEach(ItemEntity2 -> {
                ItemEntity2.func_70634_a(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v);
                ItemEntity2.func_174867_a(0);
            });
            worldIn.func_217357_a(ExperienceOrbEntity.class, new AxisAlignedBB((BlockPos)area.getLeft(), (BlockPos)area.getRight()).func_186662_g(1.0)).forEach(entityXPOrb -> entityXPOrb.func_70634_a(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v));
        }
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    public DrillTier getSelectedDrillTier(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("Selected") ? DrillTier.valueOf(stack.func_77978_p().func_74779_i("Selected")) : (DrillTier)((Object)DrillTier.getTierBraquet(this.getPowerFromStack(stack)).getLeft());
    }

    public void setSelectedDrillTier(ItemStack stack, DrillTier tier) {
        stack.func_77978_p().func_74778_a("Selected", tier.name());
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        if (player.func_70093_af()) {
            player.func_184185_a(SoundEvents.field_187750_dc, 0.5f, 0.5f);
            ItemStack stack = player.func_184586_b(handIn);
            DrillTier next = this.getSelectedDrillTier(stack).getNext((DrillTier)((Object)DrillTier.getTierBraquet(this.getPowerFromStack(stack)).getLeft()));
            player.func_146105_b(new TranslationTextComponent("text.industrialforegoing.display.current_area", new Object[0]).func_150258_a(" ").func_150258_a(this.getFormattedArea(next, next.getRadius())), true);
            this.setSelectedDrillTier(stack, next);
        }
        return super.func_77659_a(worldIn, player, handIn);
    }

    public Pair<BlockPos, BlockPos> getArea(BlockPos pos, Direction facing, DrillTier currentTier, boolean withDepth) {
        int radius = currentTier.radius;
        BlockPos bottomLeft = pos.func_177967_a(facing.func_176740_k() == Direction.Axis.Y ? Direction.SOUTH : Direction.DOWN, radius).func_177967_a(facing.func_176740_k() == Direction.Axis.Y ? Direction.WEST : facing.func_176735_f(), radius);
        BlockPos topRight = pos.func_177967_a(facing.func_176740_k() == Direction.Axis.Y ? Direction.NORTH : Direction.UP, radius).func_177967_a(facing.func_176740_k() == Direction.Axis.Y ? Direction.EAST : facing.func_176746_e(), radius);
        if (facing.func_176740_k() != Direction.Axis.Y && radius > 0) {
            bottomLeft = bottomLeft.func_177967_a(Direction.UP, radius - 1);
            topRight = topRight.func_177967_a(Direction.UP, radius - 1);
        }
        if (currentTier == DrillTier.ARTIFACT && withDepth) {
            topRight = topRight.func_177967_a(facing.func_176734_d(), radius);
        }
        return Pair.of((Object)bottomLeft, (Object)topRight);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlotType.MAINHAND) {
            DrillTier drillTier = (DrillTier)((Object)DrillTier.getTierBraquet(this.getPowerFromStack(stack)).getLeft());
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)(2 + drillTier.getRadius()), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -2.5, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((IItemProvider)this).func_200472_a(" DD").func_200472_a(" ID").func_200472_a("I  ").func_200462_a(Character.valueOf('D'), (IItemProvider)Blocks.field_150484_ah).func_200462_a(Character.valueOf('I'), (IItemProvider)Blocks.field_150339_S).func_200464_a(consumer);
    }

    private class InfinityDrillEnergyStorage
    implements IEnergyStorage {
        private final long capacity = DrillTier.ARTIFACT.getPowerNeeded();
        private long energy = 0L;

        public int receiveEnergy(int maxReceive, boolean simulate) {
            long stored = this.getLongEnergyStored();
            int energyReceived = (int)Math.min(this.capacity - stored, Math.min(Long.MAX_VALUE, (long)maxReceive));
            if (!simulate) {
                this.setEnergyStored(stored + (long)energyReceived);
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return (int)this.energy;
        }

        public void setEnergyStored(long power) {
            this.energy = power;
        }

        public int getMaxEnergyStored() {
            return (int)this.capacity;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public long getLongEnergyStored() {
            return this.energy;
        }
    }

    private class InfinityDrillCapabilityProvider
    implements ICapabilityProvider {
        private final FluidHandlerItemStack tank;
        private final InfinityDrillEnergyStorage energyStorage;
        private final LazyOptional<IEnergyStorage> energyStorageCap;
        private final LazyOptional<IFluidHandlerItem> tankCap;

        private InfinityDrillCapabilityProvider(final ItemStack stack) {
            this.tank = new FluidHandlerItemStack(stack, 1000000){

                public boolean canFillFluidType(FluidStack fluid) {
                    return fluid != null && fluid.getFluid() != null && fluid.getFluid().equals(ModuleCore.BIOFUEL.getSourceFluid());
                }

                public boolean canDrainFluidType(FluidStack fluid) {
                    return false;
                }
            };
            this.energyStorage = new InfinityDrillEnergyStorage(){

                @Override
                public long getLongEnergyStored() {
                    if (stack.func_77942_o()) {
                        return Math.min(stack.func_77978_p().func_74763_f("Energy"), DrillTier.ARTIFACT.getPowerNeeded());
                    }
                    return 0L;
                }

                @Override
                public void setEnergyStored(long energy) {
                    if (!stack.func_77942_o()) {
                        stack.func_77982_d(new CompoundNBT());
                    }
                    stack.func_77978_p().func_74772_a("Energy", Math.min(energy, DrillTier.ARTIFACT.getPowerNeeded()));
                }
            };
            this.tankCap = LazyOptional.of(() -> this.tank);
            this.energyStorageCap = LazyOptional.of(() -> this.energyStorage);
        }

        @Nullable
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                return this.tankCap.cast();
            }
            if (capability == CapabilityEnergy.ENERGY) {
                return this.energyStorageCap.cast();
            }
            return LazyOptional.empty();
        }
    }

    public static enum DrillTier {
        POOR("poor", 0L, 0, TextFormatting.GRAY, 0x7C7C7A),
        COMMON("common", 4000000L, 1, TextFormatting.WHITE, 0xFFFFFF),
        UNCOMMON("uncommon", 16000000L, 2, TextFormatting.GREEN, 1894425),
        RARE("rare", 80000000L, 3, TextFormatting.BLUE, 34815),
        EPIC("epic", 480000000L, 4, TextFormatting.DARK_PURPLE, 14745855),
        LEGENDARY("legendary", 3360000000L, 5, TextFormatting.GOLD, 0xFFAA00),
        ARTIFACT("artifact", Long.MAX_VALUE, 6, TextFormatting.YELLOW, 0xFFF887);

        private final String name;
        private final TextFormatting color;
        private final int textureColor;
        private long powerNeeded;
        private int radius;

        private DrillTier(String name, long powerNeeded, int radius, TextFormatting color, int textureColor) {
            this.name = name;
            this.powerNeeded = powerNeeded;
            this.radius = radius;
            this.color = color;
            this.textureColor = textureColor;
        }

        public static Pair<DrillTier, DrillTier> getTierBraquet(long power) {
            DrillTier lastTier = POOR;
            for (DrillTier drillTier : DrillTier.values()) {
                if (power >= lastTier.getPowerNeeded() && power < drillTier.getPowerNeeded()) {
                    return Pair.of((Object)((Object)lastTier), (Object)((Object)drillTier));
                }
                lastTier = drillTier;
            }
            return Pair.of((Object)((Object)ARTIFACT), (Object)((Object)ARTIFACT));
        }

        public String getLocalizedName() {
            return new TranslationTextComponent("text.industrialforegoing.tooltip.infinitydrill." + this.name, new Object[0]).func_150261_e();
        }

        public String getName() {
            return this.name;
        }

        public long getPowerNeeded() {
            return this.powerNeeded;
        }

        public void setPowerNeeded(long powerNeeded) {
            this.powerNeeded = powerNeeded;
        }

        public int getRadius() {
            return this.radius;
        }

        public void setRadius(int radius) {
            this.radius = radius;
        }

        public TextFormatting getColor() {
            return this.color;
        }

        public int getTextureColor() {
            return this.textureColor;
        }

        public DrillTier getNext(DrillTier maxTier) {
            DrillTier lastTier = POOR;
            for (DrillTier drillTier : DrillTier.values()) {
                if (drillTier == POOR) continue;
                if (lastTier == maxTier) {
                    return POOR;
                }
                if (this == lastTier) {
                    return drillTier;
                }
                lastTier = drillTier;
            }
            return POOR;
        }
    }
}

