/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.particle;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleVex
extends Particle {
    private final Entity entity;
    private List<Direction> directions;
    private List<Vec3d> lines;
    private boolean isDying = false;

    public ParticleVex(Entity entity) {
        super(entity.field_70170_p, entity.field_70165_t + entity.field_70170_p.field_73012_v.nextDouble() - 0.5, entity.field_70163_u + 1.0 + entity.field_70170_p.field_73012_v.nextDouble() - 0.5, entity.field_70161_v + entity.field_70170_p.field_73012_v.nextDouble() - 0.5);
        this.entity = entity;
        this.directions = new ArrayList<Direction>();
        Direction prev = Direction.NORTH;
        this.directions.add(0, prev);
        for (int i = 1; i < 50; ++i) {
            prev = this.directions.get(i - 1);
            this.directions.add(i, this.field_187122_b.field_73012_v.nextDouble() < 0.05 ? this.getRandomFacing(this.field_187122_b.field_73012_v, prev) : prev);
        }
        this.calculateLines();
        this.field_70547_e = 500;
    }

    public void func_189213_a() {
        super.func_189213_a();
        if (this.entity.func_180425_c().func_218140_a(this.field_187126_f, this.field_187127_g, this.field_187128_h, true) > 2.0) {
            this.isDying = true;
        }
        if (!this.isDying) {
            this.directions.add(0, this.field_187122_b.field_73012_v.nextDouble() < 0.05 ? this.getRandomFacing(this.field_187122_b.field_73012_v, this.directions.get(0)) : this.directions.get(0));
            this.directions.remove(50);
            Vec3d directionVector = new Vec3d((double)this.directions.get(0).func_176730_m().func_177958_n(), (double)this.directions.get(0).func_176730_m().func_177956_o(), (double)this.directions.get(0).func_176730_m().func_177952_p()).func_186678_a(0.01);
            this.func_187109_b(this.field_187126_f - directionVector.field_72450_a, this.field_187127_g - directionVector.field_72448_b, this.field_187128_h - directionVector.field_72449_c);
            this.calculateLines();
        } else {
            this.directions.remove(this.directions.size() - 1);
            this.calculateLines();
            if (this.directions.isEmpty()) {
                this.func_187112_i();
            }
        }
    }

    public void func_180434_a(BufferBuilder buffer, ActiveRenderInfo entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
    }

    public IParticleRenderType func_217558_b() {
        return null;
    }

    private Direction getRandomFacing(Random random, Direction opposite) {
        Direction facing = Direction.func_176741_a((Random)random);
        while (facing.func_176734_d().equals((Object)opposite)) {
            facing = Direction.func_176741_a((Random)random);
        }
        return facing;
    }

    private void calculateLines() {
        this.lines = new ArrayList<Vec3d>();
        if (this.directions.size() == 0) {
            return;
        }
        Direction prev = this.directions.get(0);
        int currentPosition = 0;
        Vec3d prevBlockPos = new Vec3d(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        this.lines.add(prevBlockPos);
        for (int i = 1; i < this.directions.size(); ++i) {
            if (this.directions.get(i).equals((Object)prev) && i != this.directions.size() - 1) continue;
            Vec3d directionVector = new Vec3d((double)prev.func_176730_m().func_177958_n(), (double)prev.func_176730_m().func_177956_o(), (double)prev.func_176730_m().func_177952_p()).func_186678_a(0.01);
            Vec3d endBlockPos = new Vec3d(prevBlockPos.field_72450_a + directionVector.field_72450_a * (double)(i - currentPosition), prevBlockPos.field_72448_b + directionVector.field_72448_b * (double)(i - currentPosition), prevBlockPos.field_72449_c + directionVector.field_72449_c * (double)(i - currentPosition));
            this.lines.add(endBlockPos);
            prev = this.directions.get(i);
            currentPosition = i;
            prevBlockPos = endBlockPos;
        }
    }
}

