/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColorUtils {
    public static int getColorFrom(ResourceLocation location) {
        AtlasTexture textureMap = Minecraft.func_71410_x().func_147117_R();
        TextureAtlasSprite sprite = textureMap.func_110572_b(location.toString());
        return ColorUtils.getColorFrom(sprite);
    }

    public static int getColorFrom(TextureAtlasSprite sprite) {
        if (sprite == null) {
            return -1;
        }
        if (sprite.func_110970_k() == 0) {
            return -1;
        }
        int[][] pixelMatrix = new int[][]{{0}};
        int total = 0;
        int red = 0;
        int blue = 0;
        int green = 0;
        for (int pixel : pixelMatrix[pixelMatrix.length - 1]) {
            Color color = new Color(pixel);
            if (color.getAlpha() < 255) continue;
            ++total;
            red += color.getRed();
            green += color.getGreen();
            blue += color.getBlue();
        }
        if (total > 0) {
            return new Color(red / total, green / total, blue / total, 255).getRGB();
        }
        return -1;
    }

    public static int getColorFrom(TextureAtlasSprite sprite, Color filter) {
        if (sprite == null) {
            return -1;
        }
        if (sprite.func_110970_k() == 0) {
            return -1;
        }
        int[][] pixelMatrix = new int[][]{{0}};
        int total = 0;
        int red = 0;
        int blue = 0;
        int green = 0;
        for (int pixel : pixelMatrix[pixelMatrix.length - 1]) {
            Color color = new Color(pixel);
            if (color.getAlpha() < 255 || color.getRGB() - filter.getRGB() < 100 && color.getRGB() - filter.getRGB() > 100) continue;
            ++total;
            red += color.getRed();
            green += color.getGreen();
            blue += color.getBlue();
        }
        if (total > 0) {
            return new Color(red / total, green / total, blue / total, 255).brighter().getRGB();
        }
        return -1;
    }
}

