/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import com.buuz135.industrial.utils.ColorUtils;
import com.buuz135.industrial.utils.TagUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ItemStackUtils {
    public static final Random RANDOM = new Random();

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemIntoGUI(ItemStack stack, int x, int y, int gl) {
        GlStateManager.pushMatrix();
        RenderHelper.func_74520_c();
        ItemRenderer renderItem = Minecraft.func_71410_x().func_175599_af();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, false);
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IBakedModel bakedmodel = renderItem.func_184393_a(stack, null, null);
        GlStateManager.translatef((float)x, (float)y, (float)(100.0f + renderItem.field_77023_b));
        GlStateManager.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.scalef((float)16.0f, (float)16.0f, (float)16.0f);
        if (bakedmodel.func_177556_c()) {
            GlStateManager.enableLighting();
        } else {
            GlStateManager.disableLighting();
        }
        bakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        if (!stack.func_190926_b()) {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            if (bakedmodel.func_188618_c()) {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.enableRescaleNormal();
                ItemStackTileEntityRenderer.field_147719_a.func_179022_a(stack);
            } else {
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder vertexbuffer = tessellator.func_178180_c();
                vertexbuffer.func_181668_a(gl, DefaultVertexFormats.field_176599_b);
                for (Direction Direction2 : Direction.values()) {
                    ItemStackUtils.renderQuads(vertexbuffer, bakedmodel.func_200117_a(null, Direction2, RANDOM), -1, stack);
                }
                ItemStackUtils.renderQuads(vertexbuffer, bakedmodel.func_200117_a(null, null, RANDOM), -1, stack);
                tessellator.func_78381_a();
            }
            GlStateManager.popMatrix();
        }
        GlStateManager.disableAlphaTest();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableLighting();
        GlStateManager.popMatrix();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
    }

    private static void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, int color, ItemStack stack) {
        boolean flag = color == -1 && !stack.func_190926_b();
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int k = color;
            if (flag && bakedquad.func_178212_b()) {
                k = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, bakedquad.func_178211_c());
                k |= 0xFF000000;
            }
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)bakedquad, (int)k);
        }
    }

    public static void renderEntity(int posX, int posY, int scale, float mouseX, float mouseY, LivingEntity ent) {
        GlStateManager.enableColorMaterial();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)posX, (float)posY, (float)50.0f);
        GlStateManager.scalef((float)(-scale), (float)scale, (float)scale);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        ent.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 40.0f;
        ent.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)0.0f);
        EntityRendererManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 0.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = f;
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.matrixMode((int)5888);
        GlStateManager.popMatrix();
        RenderHelper.func_74518_a();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableTexture();
    }

    public static boolean isOre(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return TagUtil.hasTag(stack.func_77973_b(), Tags.Items.ORES);
    }

    public static boolean isInventoryFull(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!handler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static boolean isChorusFlower(ItemStack stack) {
        return !Block.func_149634_a((Item)stack.func_77973_b()).equals(Blocks.field_150350_a) && Block.func_149634_a((Item)stack.func_77973_b()).equals(Blocks.field_185766_cS);
    }

    public static boolean acceptsFluidItem(ItemStack stack) {
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getColor(ItemStack stack) {
        return ColorUtils.getColorFrom(Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, (World)Minecraft.func_71410_x().field_71441_e, (LivingEntity)Minecraft.func_71410_x().field_71439_g).func_177554_e(), Color.GRAY);
    }
}

