/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.tile;

import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.config.machine.generator.BioReactorConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleGenerator;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.energy.NBTEnergyHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.Tag;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BioReactorTile
extends IndustrialWorkingTile<BioReactorTile> {
    public static Tag<Item>[] VALID = new Tag[]{IndustrialTags.Items.BIOREACTOR_INPUT, Tags.Items.CROPS_CARROT, Tags.Items.CROPS_POTATO, Tags.Items.CROPS_NETHER_WART, Tags.Items.DYES, Tags.Items.HEADS, Tags.Items.MUSHROOMS, Tags.Items.SEEDS, IndustrialTags.Items.SAPLING};
    private int getMaxProgress;
    private int getPowerPerOperation;
    @Save
    private SidedFluidTankComponent<BioReactorTile> biofuel;
    @Save
    private SidedFluidTankComponent<BioReactorTile> water = (SidedFluidTankComponent)new SidedFluidTankComponent("water", BioReactorConfig.maxWaterTankStorage, 45, 20, 0).setColor(DyeColor.CYAN).setComponentHarness((IComponentHarness)this).setTankAction(FluidTankComponent.Action.FILL).setValidator(fluidStack -> fluidStack.getFluid().equals(Fluids.field_204546_a));
    @Save
    private SidedInventoryComponent<BioReactorTile> input;
    @Save
    private ProgressBarComponent<BioReactorTile> bar;

    public BioReactorTile() {
        super(ModuleGenerator.BIOREACTOR);
        this.addTank((FluidTankComponent)this.water);
        this.input = (SidedInventoryComponent)new SidedInventoryComponent("input", 69, 22, 9, 1).setColor(DyeColor.BLUE).setRange(3, 3).setInputFilter((stack, integer) -> this.canInsert((int)integer, (ItemStack)stack)).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.input);
        this.biofuel = (SidedFluidTankComponent)new SidedFluidTankComponent("biofuel", BioReactorConfig.maxBioFuelTankStorage, 128, 20, 2).setColor(DyeColor.PURPLE).setComponentHarness((IComponentHarness)this).setTankAction(FluidTankComponent.Action.DRAIN).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)ModuleCore.BIOFUEL.getSourceFluid()));
        this.addTank((FluidTankComponent)this.biofuel);
        this.bar = new ProgressBarComponent<BioReactorTile>(150, 20, BioReactorConfig.maxProgress){

            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon<BioReactorTile>(BioReactorTile.this.bar.getPosX(), BioReactorTile.this.bar.getPosY(), (ProgressBarComponent)this){

                    public List<String> getTooltipLines() {
                        return Arrays.asList(TextFormatting.GOLD + "Efficiency: " + TextFormatting.WHITE + (int)((double)BioReactorTile.this.getEfficiency() / 9.0 * 100.0) + TextFormatting.DARK_AQUA + "%");
                    }
                });
            }
        }.setColor(DyeColor.YELLOW).setCanIncrease(tileEntity -> true).setOnTickWork(() -> this.bar.setProgress((int)((double)this.getEfficiency() / 9.0 * 100.0))).setCanReset(tileEntity -> false).setComponentHarness((IComponentHarness)this);
        this.addProgressBar(this.bar);
        this.getMaxProgress = BioReactorConfig.maxProgress;
        this.getPowerPerOperation = BioReactorConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.hasEnergy(this.getPowerPerOperation)) {
            int efficiency = this.getEfficiency();
            if (efficiency <= 0) {
                return new IndustrialWorkingTile.WorkAction(1.0f, 0);
            }
            int fluidAmount = ((efficiency - 1) * 10 + 80) * efficiency;
            if (this.water.getFluidAmount() >= fluidAmount && this.biofuel.getCapacity() - this.biofuel.getFluidAmount() >= fluidAmount) {
                this.water.drainForced(fluidAmount, IFluidHandler.FluidAction.EXECUTE);
                this.biofuel.fillForced(new FluidStack((Fluid)ModuleCore.BIOFUEL.getSourceFluid(), fluidAmount), IFluidHandler.FluidAction.EXECUTE);
                for (int i = 0; i < this.input.getSlots(); ++i) {
                    this.input.getStackInSlot(i).func_190918_g(1);
                }
                new IndustrialWorkingTile.WorkAction(1.0f, this.getPowerPerOperation);
            }
        }
        return new IndustrialWorkingTile.WorkAction(1.0f, 0);
    }

    private boolean canInsert(int slot, ItemStack stack) {
        for (int i = 0; i < this.input.getSlots(); ++i) {
            if (i != slot && this.input.getStackInSlot(i).func_77969_a(stack)) {
                return false;
            }
            if (i != slot || !this.input.getStackInSlot(i).func_77969_a(stack) || this.input.getStackInSlot(i).func_190916_E() + stack.func_190916_E() > this.input.getStackInSlot(i).func_77976_d()) continue;
            return true;
        }
        for (Tag<Item> itemTag : VALID) {
            if (!itemTag.func_199685_a_((Object)stack.func_77973_b())) continue;
            return true;
        }
        return false;
    }

    private int getEfficiency() {
        int slots = 0;
        for (int i = 0; i < this.input.getSlots(); ++i) {
            if (this.input.getStackInSlot(i).func_190926_b()) continue;
            ++slots;
        }
        return slots;
    }

    protected IFactory<NBTEnergyHandler> getEnergyHandlerFactory() {
        return () -> new NBTEnergyHandler((BasicTile)this, BioReactorConfig.maxStoredPower);
    }

    @Override
    public int getMaxProgress() {
        return this.getMaxProgress;
    }

    @Nonnull
    public BioReactorTile getSelf() {
        return this;
    }
}

