/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.tile;

import com.buuz135.industrial.item.addon.EfficiencyAddonItem;
import com.buuz135.industrial.item.addon.SpeedAddonItem;
import com.buuz135.industrial.proxy.client.IndustrialAssetProvider;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.augment.IAugment;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.MachineTile;
import com.hrznstudio.titanium.client.screen.addon.EnergyBarScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class IndustrialWorkingTile<T extends IndustrialWorkingTile<T>>
extends MachineTile<T> {
    @Save
    private ProgressBarComponent<T> workingBar;

    public IndustrialWorkingTile(BasicTileBlock<T> basicTileBlock) {
        super(basicTileBlock);
        this.addGuiAddonFactory(() -> new EnergyBarScreenAddon(10, 20, (IEnergyStorage)this.getEnergyStorage()));
        this.workingBar = new ProgressBarComponent(30, 20, 0, this.getMaxProgress()).setComponentHarness((IComponentHarness)this.getSelf()).setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP).setIncreaseType(false).setOnFinishWork(() -> {
            if (this.isServer()) {
                WorkAction work = this.work();
                int maxProgress = (int)Math.floor((double)this.getMaxProgress() * (this.hasAugmentInstalled(EfficiencyAddonItem.EFFICIENCY) ? 0.1 * (double)((IAugment)this.getInstalledAugments(EfficiencyAddonItem.EFFICIENCY).get(0)).getAugmentRatio() : 1.0));
                this.workingBar.setMaxProgress(maxProgress);
                this.workingBar.setProgress((int)((float)maxProgress * work.getWorkAmount()));
                this.getEnergyStorage().extractEnergyForced(work.getEnergyConsumed());
            }
        }).setOnTickWork(() -> this.workingBar.setProgressIncrease(this.hasAugmentInstalled(SpeedAddonItem.SPEED) ? (int)((IAugment)this.getInstalledAugments(SpeedAddonItem.SPEED).get(0)).getAugmentRatio() + 1 : 1)).setCanReset(tileEntity -> true).setCanIncrease(tileEntity -> true).setColor(DyeColor.LIME);
        this.addProgressBar(this.workingBar);
    }

    public ActionResultType onActivated(PlayerEntity playerIn, Hand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == ActionResultType.SUCCESS) {
            return ActionResultType.SUCCESS;
        }
        this.openGui(playerIn);
        return ActionResultType.PASS;
    }

    public abstract WorkAction work();

    public boolean hasEnergy(int amount) {
        return this.getEnergyStorage().getEnergyStored() >= amount;
    }

    public int getMaxProgress() {
        return 100;
    }

    public IAssetProvider getAssetProvider() {
        return IndustrialAssetProvider.INSTANCE;
    }

    public class WorkAction {
        private final float workAmount;
        private final int energyConsumed;

        public WorkAction(float workAmount, int energyConsumed) {
            this.workAmount = workAmount;
            this.energyConsumed = energyConsumed;
        }

        public float getWorkAmount() {
            return this.workAmount;
        }

        public int getEnergyConsumed() {
            return this.energyConsumed;
        }
    }
}

