/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item;

import com.buuz135.industrial.item.IFCustomItem;
import com.buuz135.industrial.module.ModuleCore;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class MeatFeederItem
extends IFCustomItem {
    public MeatFeederItem(ItemGroup group) {
        super("meat_feeder", group, new Item.Properties().func_200917_a(1));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        FluidHandlerItemStack handlerItemStack = new FluidHandlerItemStack(stack, 128000){

            public boolean canFillFluidType(FluidStack fluid) {
                return fluid.getFluid().func_207187_a((Fluid)ModuleCore.MEAT.getSourceFluid());
            }
        };
        handlerItemStack.fill(new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid(), 0), IFluidHandler.FluidAction.EXECUTE);
        return handlerItemStack;
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<ITextComponent> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        if (stack.func_77978_p() != null && key == null) {
            tooltip.add((ITextComponent)new StringTextComponent(NumberFormat.getNumberInstance(Locale.ROOT).format(stack.func_77978_p().func_74775_l("Fluid").func_74762_e("Amount")) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + NumberFormat.getNumberInstance(Locale.ROOT).format(128000L) + TextFormatting.GOLD + "mb of Meat"));
        }
    }

    public int getFilledAmount(ItemStack stack) {
        FluidHandlerItemStack handlerItemStack = (FluidHandlerItemStack)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElseThrow(RuntimeException::new);
        return handlerItemStack.getFluid() == null ? 0 : handlerItemStack.getFluid().getAmount();
    }

    public void drain(ItemStack stack, int amount) {
        FluidHandlerItemStack handlerItemStack = (FluidHandlerItemStack)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElseThrow(RuntimeException::new);
        handlerItemStack.drain(new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid(), amount), IFluidHandler.FluidAction.EXECUTE);
    }

    public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((IItemProvider)this).func_200472_a("pip").func_200472_a("gig").func_200472_a(" i ").func_200462_a(Character.valueOf('p'), (IItemProvider)ModuleCore.PLASTIC).func_200469_a(Character.valueOf('i'), Tags.Items.INGOTS_IRON).func_200462_a(Character.valueOf('g'), (IItemProvider)Items.field_151069_bo).func_200464_a(consumer);
    }
}

