/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity;

import com.buuz135.industrial.item.IFCustomItem;
import com.buuz135.industrial.item.infinity.IInfinityDrillScreenAddons;
import com.buuz135.industrial.item.infinity.InfinityCapabilityProvider;
import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.proxy.CommonProxy;
import com.google.common.collect.Multimap;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ArrowButtonScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.container.BasicAddonContainer;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.itemstack.ItemStackHarnessRegistry;
import com.hrznstudio.titanium.network.IButtonHandler;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.HeldStackLocatorInstance;
import com.hrznstudio.titanium.util.FacingUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;

public class ItemInfinity
extends IFCustomItem
implements INamedContainerProvider,
IButtonHandler,
IInfinityDrillScreenAddons {
    private final int powerConsumption;
    private final int biofuelConsumption;

    public ItemInfinity(String name, ItemGroup group, Item.Properties builder, int powerConsumption, int biofuelConsumption) {
        super(name, group, builder);
        this.powerConsumption = powerConsumption;
        this.biofuelConsumption = biofuelConsumption;
    }

    public static long getPowerFromStack(ItemStack stack) {
        long power = 0L;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Energy")) {
            power = stack.func_77978_p().func_74763_f("Energy");
        }
        return power;
    }

    public static String getFormattedArea(InfinityTier tier, int radius) {
        int diameter = radius * 2 + 1;
        return diameter + "x" + diameter + "x" + (tier == InfinityTier.ARTIFACT ? diameter : 1);
    }

    public static InfinityTier getSelectedTier(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("Selected") ? InfinityTier.valueOf(stack.func_77978_p().func_74779_i("Selected")) : (InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinity.getPowerFromStack(stack)).getLeft());
    }

    public static boolean canCharge(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("CanCharge")) {
            return stack.func_77978_p().func_74767_n("CanCharge");
        }
        return true;
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        this.addNbt(stack, 0L, 0, CommonProxy.CONTRIBUTORS.contains(playerIn.func_110124_au().toString()));
    }

    public void addNbt(ItemStack stack, long power, int fuel, boolean special) {
        CompoundNBT tagCompound = new CompoundNBT();
        tagCompound.func_74772_a("Energy", power);
        CompoundNBT fluid = new CompoundNBT();
        fluid.func_74778_a("FluidName", "biofuel");
        fluid.func_74768_a("Amount", fuel);
        tagCompound.func_218657_a("Fluid", (INBT)fluid);
        tagCompound.func_74757_a("Special", special);
        tagCompound.func_74778_a("Selected", ((InfinityTier)((Object)InfinityTier.getTierBraquet(power).getLeft())).name());
        tagCompound.func_74757_a("CanCharge", true);
        stack.func_77982_d(tagCompound);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (InfinityTier value : InfinityTier.values()) {
                items.add((Object)this.createStack(value.getPowerNeeded(), 0, false));
            }
            items.add((Object)this.createStack(InfinityTier.ARTIFACT.getPowerNeeded(), 1000000, true));
        }
    }

    public ItemStack createStack(long power, int fuel, boolean special) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        this.addNbt(stack, power, fuel, special);
        return stack;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return 50;
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.BOW;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged && !oldStack.equals(newStack);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return this.enoughFuel(stack) ? 10.0f : 0.0f;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (Screen.hasShiftDown()) {
            int fuel = this.getFuelFromStack(stack);
            return 1.0 - (double)fuel / 1000000.0;
        }
        long power = ItemInfinity.getPowerFromStack(stack);
        return 1.0 - (double)power / (double)((InfinityTier)((Object)InfinityTier.getTierBraquet(power).getRight())).getPowerNeeded();
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return Screen.hasShiftDown() ? 13304063 : 53503;
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public int getFuelFromStack(ItemStack stack) {
        int fuelAmount = 0;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Fluid") && stack.func_77978_p().func_74775_l("Fluid").func_74764_b("Amount")) {
            fuelAmount = stack.func_77978_p().func_74775_l("Fluid").func_74762_e("Amount");
        }
        return fuelAmount;
    }

    public boolean isSpecial(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("Special") && stack.func_77978_p().func_74767_n("Special");
    }

    public boolean enoughFuel(ItemStack stack) {
        return this.getFuelFromStack(stack) >= this.biofuelConsumption || ItemInfinity.getPowerFromStack(stack) >= (long)this.powerConsumption;
    }

    public void consumeFuel(ItemStack stack) {
        if (this.getFuelFromStack(stack) >= this.biofuelConsumption) {
            stack.func_77978_p().func_74775_l("Fluid").func_74768_a("Amount", Math.max(0, stack.func_77978_p().func_74775_l("Fluid").func_74762_e("Amount") - this.biofuelConsumption));
        } else {
            stack.func_77978_p().func_74772_a("Energy", stack.func_77978_p().func_74763_f("Energy") - (long)this.powerConsumption);
        }
    }

    public void setCanCharge(ItemStack stack, boolean canCharge) {
        stack.func_77978_p().func_74757_a("CanCharge", canCharge);
    }

    public void setSelectedDrillTier(ItemStack stack, InfinityTier tier) {
        stack.func_77978_p().func_74778_a("Selected", tier.name());
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<ITextComponent> tooltip, boolean advanced) {
        long power = ItemInfinity.getPowerFromStack(stack);
        Pair<InfinityTier, InfinityTier> braquet = InfinityTier.getTierBraquet(power);
        InfinityTier current = ItemInfinity.getSelectedTier(stack);
        tooltip.add(new TranslationTextComponent("text.industrialforegoing.display.current_area", new Object[0]).func_150258_a(" ").func_150258_a(ItemInfinity.getFormattedArea(current, current.getRadius())).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        tooltip.add(new TranslationTextComponent("text.industrialforegoing.display.tier", new Object[0]).func_150258_a(" ").func_150258_a(((InfinityTier)((Object)braquet.getLeft())).getColor() + ((InfinityTier)((Object)braquet.getLeft())).getLocalizedName()).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        tooltip.add(new TranslationTextComponent("text.industrialforegoing.display.power", new Object[0]).func_150258_a(" ").func_150258_a(NumberFormat.getNumberInstance(Locale.ROOT).format(power)).func_150258_a("/").func_150258_a(NumberFormat.getNumberInstance(Locale.ROOT).format(((InfinityTier)((Object)braquet.getRight())).getPowerNeeded())).func_150258_a("RF ").func_150257_a((ITextComponent)new TranslationTextComponent("text.industrialforegoing.display.next_tier", new Object[0])).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        int fuelAmount = this.getFuelFromStack(stack);
        tooltip.add(new TranslationTextComponent("text.industrialforegoing.display.fluid", new Object[0]).func_150258_a(" ").func_150258_a(NumberFormat.getNumberInstance(Locale.ROOT).format(fuelAmount)).func_150258_a("/").func_150258_a(NumberFormat.getNumberInstance(Locale.ROOT).format(1000000L)).func_150258_a(" mb of Biofuel").func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        tooltip.add(new TranslationTextComponent("text.industrialforegoing.display.max_area", new Object[0]).func_150258_a(" ").func_150258_a(ItemInfinity.getFormattedArea((InfinityTier)((Object)braquet.getLeft()), ((InfinityTier)((Object)braquet.getLeft())).getRadius())).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        if (ItemInfinity.canCharge(stack)) {
            tooltip.add(new TranslationTextComponent("text.industrialforegoing.display.charging", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)).func_150257_a(new TranslationTextComponent("text.industrialforegoing.display.enabled", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN))));
        } else {
            tooltip.add(new TranslationTextComponent("text.industrialforegoing.display.charging", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)).func_150257_a(new TranslationTextComponent("text.industrialforegoing.display.disabled", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))));
        }
        if (this.isSpecial(stack)) {
            tooltip.add(new TranslationTextComponent("text.industrialforegoing.display.special", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
        }
    }

    public Pair<BlockPos, BlockPos> getArea(BlockPos pos, Direction facing, InfinityTier currentTier, boolean withDepth) {
        int radius = currentTier.getRadius();
        BlockPos bottomLeft = pos.func_177967_a(facing.func_176740_k() == Direction.Axis.Y ? Direction.SOUTH : Direction.DOWN, radius).func_177967_a(facing.func_176740_k() == Direction.Axis.Y ? Direction.WEST : facing.func_176735_f(), radius);
        BlockPos topRight = pos.func_177967_a(facing.func_176740_k() == Direction.Axis.Y ? Direction.NORTH : Direction.UP, radius).func_177967_a(facing.func_176740_k() == Direction.Axis.Y ? Direction.EAST : facing.func_176746_e(), radius);
        if (facing.func_176740_k() != Direction.Axis.Y && radius > 0) {
            bottomLeft = bottomLeft.func_177967_a(Direction.UP, radius - 1);
            topRight = topRight.func_177967_a(Direction.UP, radius - 1);
        }
        if (currentTier == InfinityTier.ARTIFACT && withDepth) {
            topRight = topRight.func_177967_a(facing.func_176734_d(), radius);
        }
        return Pair.of((Object)bottomLeft, (Object)topRight);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlotType.MAINHAND) {
            InfinityTier infinityTier = (InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinity.getPowerFromStack(stack)).getLeft());
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)(2 + infinityTier.getRadius()), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -2.5, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_77658_a(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY));
    }

    @Nullable
    public Container createMenu(int menu, PlayerInventory p_createMenu_2_, PlayerEntity playerEntity) {
        return new BasicAddonContainer(((Function)ItemStackHarnessRegistry.getHarnessCreators().get(this)).apply(playerEntity.func_184614_ca()), (LocatorInstance)new HeldStackLocatorInstance(true), new IWorldPosCallable(){

            public <T> Optional<T> func_221484_a(BiFunction<World, BlockPos, T> p_221484_1_) {
                return Optional.empty();
            }
        }, playerEntity.field_71071_by, menu);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        if (player.func_213453_ef()) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buffer -> LocatorFactory.writePacketBuffer((PacketBuffer)buffer, (LocatorInstance)new HeldStackLocatorInstance(handIn == Hand.MAIN_HAND)));
            }
            return ActionResult.func_226248_a_((Object)player.func_184586_b(handIn));
        }
        return super.func_77659_a(worldIn, player, handIn);
    }

    public boolean func_77651_p() {
        return true;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new InfinityCapabilityProvider(stack);
    }

    public void handleButtonMessage(int id, PlayerEntity playerEntity, CompoundNBT compound) {
        ItemStack stack = playerEntity.func_184586_b(Hand.MAIN_HAND);
        if (!(stack.func_77973_b() instanceof ItemInfinity)) {
            stack = playerEntity.func_184586_b(Hand.OFF_HAND);
        }
        if (stack.func_77973_b() instanceof ItemInfinity) {
            if (id == 1) {
                InfinityTier prev = ItemInfinity.getSelectedTier(stack).getPrev((InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinity.getPowerFromStack(stack)).getLeft()));
                this.setSelectedDrillTier(stack, prev);
            }
            if (id == 2) {
                InfinityTier next = ItemInfinity.getSelectedTier(stack).getNext((InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinity.getPowerFromStack(stack)).getLeft()));
                this.setSelectedDrillTier(stack, next);
            }
            if (id == 3) {
                this.setCanCharge(stack, !ItemInfinity.canCharge(stack));
            }
        }
    }

    public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
    }

    @Override
    public List<IFactory<? extends IScreenAddon>> getScreenAddons(final Supplier<ItemStack> stack) {
        ArrayList<IFactory<? extends IScreenAddon>> factory = new ArrayList<IFactory<? extends IScreenAddon>>();
        factory.add(() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(154, 20, 14, 14, FacingUtil.Sideness.RIGHT).setId(2)));
        factory.add(() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(54, 20, 14, 14, FacingUtil.Sideness.LEFT).setId(1)));
        factory.add(() -> new TextScreenAddon("", 72, 24, false){

            public String getText() {
                InfinityTier current = ItemInfinity.getSelectedTier((ItemStack)stack.get());
                return TextFormatting.DARK_GRAY + "Area: " + ItemInfinity.getFormattedArea(current, current.getRadius());
            }
        });
        factory.add(() -> new StateButtonAddon(new ButtonComponent(54, 38, 14, 15).setId(3), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[0]), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[0])}){

            public int getState() {
                return ItemInfinity.canCharge((ItemStack)stack.get()) ? 0 : 1;
            }
        });
        factory.add(() -> new TextScreenAddon("", 72, 42, false){

            public String getText() {
                if (ItemInfinity.canCharge((ItemStack)stack.get())) {
                    return new TranslationTextComponent("text.industrialforegoing.display.charging", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY)).func_150257_a(new TranslationTextComponent("text.industrialforegoing.display.enabled", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN))).func_150254_d();
                }
                return new TranslationTextComponent("text.industrialforegoing.display.charging", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY)).func_150257_a(new TranslationTextComponent("text.industrialforegoing.display.disabled", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))).func_150254_d();
            }
        });
        return factory;
    }
}

