/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile;

import com.google.common.collect.Sets;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.energy.NBTEnergyHandler;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class PoweredTile<T extends PoweredTile<T>>
extends ActiveTile<T> {
    @Save
    private NBTEnergyHandler energyHandler = this.getEnergyHandlerFactory().create();
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energyHandler);

    public PoweredTile(BasicTileBlock<T> basicTileBlock) {
        super(basicTileBlock);
    }

    protected IFactory<NBTEnergyHandler> getEnergyHandlerFactory() {
        return () -> new NBTEnergyHandler(this, 10000);
    }

    public NBTEnergyHandler getEnergyStorage() {
        return this.energyHandler;
    }

    public Set<Direction> getValidEnergyFaces() {
        return Sets.newHashSet((Object[])Direction.values());
    }

    @Override
    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }
}

