/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.component.energy;

import com.google.common.collect.Lists;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.client.screen.addon.EnergyBarScreenAddon;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.container.addon.IContainerAddonProvider;
import com.hrznstudio.titanium.container.addon.IntReferenceHolderAddon;
import com.hrznstudio.titanium.container.referenceholder.FunctionReferenceHolder;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorageComponent
extends EnergyStorage
implements INBTSerializable<CompoundNBT>,
IScreenAddonProvider,
IContainerAddonProvider {
    private final int xPos;
    private final int yPos;

    public EnergyStorageComponent(int maxCapacity, int xPos, int yPos) {
        this(maxCapacity, maxCapacity, xPos, yPos);
    }

    public EnergyStorageComponent(int maxCapacity, int maxIO, int xPos, int yPos) {
        this(maxCapacity, maxIO, maxIO, xPos, yPos);
    }

    public EnergyStorageComponent(int maxCapacity, int maxReceive, int maxExtract, int xPos, int yPos) {
        super(maxCapacity, maxReceive, maxExtract);
        this.xPos = xPos;
        this.yPos = yPos;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("energy", this.energy);
        return nbt;
    }

    public void setEnergyStored(int energy) {
        this.energy = energy > this.getMaxEnergyStored() ? this.getMaxEnergyStored() : Math.max(energy, 0);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.energy = nbt.func_74762_e("energy");
    }

    @Override
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        return Lists.newArrayList((Object[])new IFactory[]{() -> new EnergyBarScreenAddon(this.xPos, this.yPos, (IEnergyStorage)this)});
    }

    @Override
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        return Lists.newArrayList((Object[])new IFactory[]{() -> new IntReferenceHolderAddon(new FunctionReferenceHolder(this::setEnergyStored, () -> ((EnergyStorageComponent)this).getEnergyStored()))});
    }
}

