/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.component.inventory;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.sideness.ICapabilityHolder;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.container.addon.IContainerAddonProvider;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class MultiInventoryComponent<T extends IComponentHarness>
implements IScreenAddonProvider,
IContainerAddonProvider,
ICapabilityHolder<InventoryComponent<T>, MultiInvCapabilityHandler<T>> {
    private final LinkedHashSet<InventoryComponent<T>> inventoryHandlers = new LinkedHashSet();
    private final Map<FacingUtil.Sideness, LazyOptional<MultiInvCapabilityHandler<T>>> lazyOptionals = new HashMap<FacingUtil.Sideness, LazyOptional<MultiInvCapabilityHandler<T>>>();

    public MultiInventoryComponent() {
        this.lazyOptionals.put(null, LazyOptional.empty());
        for (FacingUtil.Sideness value : FacingUtil.Sideness.values()) {
            this.lazyOptionals.put(value, LazyOptional.empty());
        }
    }

    @Override
    public void add(@Nonnull InventoryComponent<T> inventoryComponent) {
        this.inventoryHandlers.add(inventoryComponent);
        this.rebuildCapability(new FacingUtil.Sideness[]{null});
        this.rebuildCapability(FacingUtil.Sideness.values());
    }

    private void rebuildCapability(FacingUtil.Sideness[] sides) {
        for (FacingUtil.Sideness side : sides) {
            this.lazyOptionals.get((Object)side).invalidate();
            this.lazyOptionals.put(side, LazyOptional.of(() -> new MultiInvCapabilityHandler<T>(this.getHandlersForSide(side))));
        }
    }

    private List<InventoryComponent<T>> getHandlersForSide(FacingUtil.Sideness sideness) {
        if (sideness == null) {
            return new ArrayList<InventoryComponent<T>>(this.inventoryHandlers);
        }
        ArrayList<InventoryComponent<T>> handlers = new ArrayList<InventoryComponent<T>>();
        for (InventoryComponent inventoryComponent : this.inventoryHandlers) {
            if (inventoryComponent instanceof IFacingComponent) {
                if (!((IFacingComponent)((Object)inventoryComponent)).getFacingModes().containsKey((Object)sideness) || !((IFacingComponent)((Object)inventoryComponent)).getFacingModes().get((Object)sideness).allowsConnection()) continue;
                handlers.add(inventoryComponent);
                continue;
            }
            handlers.add(inventoryComponent);
        }
        return handlers;
    }

    @Override
    @Nonnull
    public LazyOptional<MultiInvCapabilityHandler<T>> getCapabilityForSide(FacingUtil.Sideness sideness) {
        return this.lazyOptionals.get((Object)sideness);
    }

    @Override
    public boolean handleFacingChange(String handlerName, FacingUtil.Sideness facing, IFacingComponent.FaceMode mode) {
        for (InventoryComponent inventoryComponent : this.inventoryHandlers) {
            if (!inventoryComponent.getName().equals(handlerName) || !(inventoryComponent instanceof IFacingComponent)) continue;
            ((IFacingComponent)((Object)inventoryComponent)).getFacingModes().put(facing, mode);
            this.rebuildCapability(new FacingUtil.Sideness[]{facing});
            return true;
        }
        return false;
    }

    public HashSet<InventoryComponent<T>> getInventoryHandlers() {
        return this.inventoryHandlers;
    }

    @Override
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList<IFactory<? extends IScreenAddon>> addons = new ArrayList<IFactory<? extends IScreenAddon>>();
        this.inventoryHandlers.forEach(posInvHandler -> addons.addAll(posInvHandler.getScreenAddons()));
        return addons;
    }

    @Override
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        ArrayList<IFactory<? extends IContainerAddon>> addons = new ArrayList<IFactory<? extends IContainerAddon>>();
        for (InventoryComponent inventoryComponent : this.inventoryHandlers) {
            addons.addAll(inventoryComponent.getContainerAddons());
        }
        return addons;
    }

    public static class MultiInvCapabilityHandler<T extends IComponentHarness>
    extends ItemStackHandler {
        private final List<InventoryComponent<T>> inventoryHandlers;
        private int slotAmount;

        public MultiInvCapabilityHandler(List<InventoryComponent<T>> inventoryHandlers) {
            this.inventoryHandlers = inventoryHandlers;
            this.slotAmount = 0;
            for (InventoryComponent<T> inventoryHandler : this.inventoryHandlers) {
                this.slotAmount += inventoryHandler.getSlots();
            }
        }

        public int getSlots() {
            return this.slotAmount;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            InventoryComponent<T> handler = this.getFromSlot(slot);
            if (handler != null) {
                if (handler.getInsertPredicate().test(stack, slot)) {
                    return handler.insertItem(this.getRelativeSlot(handler, slot), stack, simulate);
                }
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            InventoryComponent<T> handler = this.getFromSlot(slot);
            if (handler != null) {
                int relativeSlot = this.getRelativeSlot(handler, slot);
                if (!handler.getExtractPredicate().test(handler.getStackInSlot(relativeSlot), relativeSlot)) {
                    return ItemStack.field_190927_a;
                }
                return handler.extractItem(relativeSlot, amount, simulate);
            }
            return super.extractItem(slot, amount, simulate);
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            InventoryComponent<T> handler = this.getFromSlot(slot);
            if (handler != null) {
                return handler.getStackInSlot(this.getRelativeSlot(handler, slot));
            }
            return super.getStackInSlot(slot);
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            InventoryComponent<T> handler = this.getFromSlot(slot);
            if (handler != null) {
                handler.setStackInSlot(this.getRelativeSlot(handler, slot), stack);
            }
            super.setStackInSlot(slot, stack);
        }

        protected void validateSlotIndex(int slot) {
            if (slot < 0 || slot >= this.slotAmount) {
                throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.slotAmount + ")");
            }
        }

        public InventoryComponent<T> getFromSlot(int slot) {
            for (InventoryComponent<T> handler : this.inventoryHandlers) {
                if ((slot -= handler.getSlots()) >= 0) continue;
                return handler;
            }
            return null;
        }

        public int getRelativeSlot(InventoryComponent<T> handler, int slot) {
            for (InventoryComponent<T> h : this.inventoryHandlers) {
                if (h.equals(handler)) {
                    return slot;
                }
                slot -= h.getSlots();
            }
            return 0;
        }
    }
}

