/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.config;

import com.hrznstudio.titanium.annotation.config.ConfigFile;
import com.hrznstudio.titanium.annotation.config.ConfigVal;
import com.hrznstudio.titanium.util.AnnotationUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

public class AnnotationConfigManager {
    public List<Type> configClasses = new ArrayList<Type>();
    public HashMap<Field, ForgeConfigSpec.ConfigValue> cachedConfigValues = new HashMap();

    public void add(Type type) {
        this.configClasses.add(type);
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        for (Class configClass : type.configClass) {
            this.scanClass(configClass, builder);
        }
        String fileName = ModLoadingContext.get().getActiveContainer().getModId() + "/" + (type.fileName.isEmpty() ? ModLoadingContext.get().getActiveContainer().getModId() : type.fileName);
        if (!fileName.endsWith(".toml")) {
            fileName = fileName + ".toml";
        }
        ModLoadingContext.get().registerConfig(type.type, builder.build(), fileName);
    }

    private void scanClass(Class configClass, ForgeConfigSpec.Builder builder) {
        builder.push(configClass.getSimpleName());
        try {
            for (Field field : configClass.getFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(ConfigVal.class)) continue;
                if (field.getType().isPrimitive() || field.getType().equals(String.class)) {
                    ConfigVal value = field.getAnnotation(ConfigVal.class);
                    ForgeConfigSpec.ConfigValue configValue = null;
                    if (!value.comment().isEmpty()) {
                        builder.comment(value.comment());
                    }
                    if (field.isAnnotationPresent(ConfigVal.InRangeDouble.class)) {
                        configValue = builder.defineInRange(value.value().isEmpty() ? field.getName() : value.value(), ((Double)field.get(null)).doubleValue(), field.getAnnotation(ConfigVal.InRangeDouble.class).min(), field.getAnnotation(ConfigVal.InRangeDouble.class).max());
                    }
                    if (field.isAnnotationPresent(ConfigVal.InRangeLong.class)) {
                        configValue = builder.defineInRange(value.value().isEmpty() ? field.getName() : value.value(), ((Long)field.get(null)).longValue(), field.getAnnotation(ConfigVal.InRangeLong.class).min(), field.getAnnotation(ConfigVal.InRangeLong.class).max());
                    }
                    if (field.isAnnotationPresent(ConfigVal.InRangeInt.class)) {
                        configValue = builder.defineInRange(value.value().isEmpty() ? field.getName() : value.value(), ((Integer)field.get(null)).intValue(), field.getAnnotation(ConfigVal.InRangeInt.class).min(), field.getAnnotation(ConfigVal.InRangeInt.class).max());
                    }
                    if (configValue == null) {
                        configValue = builder.define(value.value().isEmpty() ? field.getName() : value.value(), field.get(null));
                    }
                    this.cachedConfigValues.put(field, configValue);
                    continue;
                }
                this.scanClass(field.getType(), builder);
            }
            AnnotationUtil.getFilteredAnnotatedClasses(ConfigFile.Child.class, ModLoadingContext.get().getActiveContainer().getModId()).stream().filter(aClass -> aClass.getAnnotation(ConfigFile.Child.class).value().equals(configClass)).forEach(aClass -> this.scanClass((Class)aClass, builder));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        builder.pop();
    }

    public void inject() {
        this.cachedConfigValues.forEach((field, configValue) -> {
            try {
                field.set(null, configValue.get());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
    }

    public boolean isClassManaged(Class clazz) {
        for (Type configClass : this.configClasses) {
            for (Class aClass : configClass.configClass) {
                if (!clazz.equals(aClass)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Type {
        private ModConfig.Type type;
        private Class[] configClass;
        private String fileName;

        private Type(ModConfig.Type type, Class ... configClass) {
            this.type = type;
            this.configClass = configClass;
            this.fileName = "";
        }

        public static Type client(Class ... classes) {
            return new Type(ModConfig.Type.CLIENT, classes);
        }

        public static Type common(Class ... classes) {
            return new Type(ModConfig.Type.COMMON, classes);
        }

        public static Type server(Class ... classes) {
            return new Type(ModConfig.Type.SERVER, classes);
        }

        public static Type of(ModConfig.Type type, Class ... classes) {
            return new Type(type, classes);
        }

        public Type setName(String name) {
            this.fileName = name;
            return this;
        }

        public Class[] getConfigClass() {
            return this.configClass;
        }
    }
}

