/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.itemstack;

import com.google.common.collect.Lists;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.container.addon.IContainerAddonProvider;
import com.hrznstudio.titanium.network.IButtonHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.capabilities.Capability;

public class ItemStackHarness
implements IContainerAddonProvider,
IScreenAddonProvider,
IButtonHandler {
    private final ItemStack itemStack;
    private final IButtonHandler buttonHandler;
    private final Capability<?>[] capabilities;
    private final IScreenAddonProvider defaultProvider;

    public ItemStackHarness(ItemStack itemStack, IScreenAddonProvider defaultProvider, IButtonHandler buttonHandler, Capability<?> ... capabilities) {
        this.itemStack = itemStack;
        this.defaultProvider = defaultProvider;
        this.buttonHandler = buttonHandler;
        this.capabilities = capabilities;
    }

    @Override
    @Nonnull
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList screenAddons = Lists.newArrayList();
        if (this.defaultProvider != null) {
            screenAddons.addAll(this.defaultProvider.getScreenAddons());
        }
        for (Capability<?> capability : this.capabilities) {
            screenAddons.addAll((Collection)this.itemStack.getCapability(capability).filter(cap -> cap instanceof IScreenAddonProvider).map(cap -> (IScreenAddonProvider)cap).map(IScreenAddonProvider::getScreenAddons).orElseGet(Lists::newArrayList));
        }
        return screenAddons;
    }

    @Override
    @Nonnull
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        ArrayList containerAddons = Lists.newArrayList();
        for (Capability<?> capability : this.capabilities) {
            containerAddons.addAll((Collection)this.itemStack.getCapability(capability).filter(cap -> cap instanceof IContainerAddonProvider).map(cap -> (IContainerAddonProvider)cap).map(IContainerAddonProvider::getContainerAddons).orElseGet(Lists::newArrayList));
        }
        return containerAddons;
    }

    @Override
    public void handleButtonMessage(int id, PlayerEntity playerEntity, CompoundNBT compound) {
        if (this.buttonHandler != null) {
            this.buttonHandler.handleButtonMessage(id, playerEntity, compound);
        }
    }
}

